package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Doubles;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfigJsonService.GeneralConfigDtoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code GeneralConfigDto.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.GeneralConfigDtoBase"})
@Immutable
final class GeneralConfigDto extends ConfigJsonService.GeneralConfigDtoBase {
  private final boolean enabled;
  private final int traceStoreThresholdMillis;
  private final int profilingIntervalMillis;
  private final String defaultDisplayedTransactionType;
  private final ImmutableList<Double> defaultDisplayedPercentiles;
  private final String version;

  private GeneralConfigDto(GeneralConfigDto.Builder builder) {
    this.enabled = builder.enabled;
    this.traceStoreThresholdMillis = builder.traceStoreThresholdMillis;
    this.profilingIntervalMillis = builder.profilingIntervalMillis;
    this.defaultDisplayedTransactionType = builder.defaultDisplayedTransactionType;
    this.defaultDisplayedPercentiles = builder.defaultDisplayedPercentilesBuilder.build();
    this.version = builder.version;
  }

  private GeneralConfigDto(
      GeneralConfigDto original,
      boolean enabled,
      int traceStoreThresholdMillis,
      int profilingIntervalMillis,
      String defaultDisplayedTransactionType,
      ImmutableList<Double> defaultDisplayedPercentiles,
      String version) {
    this.enabled = enabled;
    this.traceStoreThresholdMillis = traceStoreThresholdMillis;
    this.profilingIntervalMillis = profilingIntervalMillis;
    this.defaultDisplayedTransactionType = defaultDisplayedTransactionType;
    this.defaultDisplayedPercentiles = defaultDisplayedPercentiles;
    this.version = version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code enabled} attribute
   */
  @JsonProperty("enabled")
  @Override
  public boolean enabled() {
    return enabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceStoreThresholdMillis} attribute
   */
  @JsonProperty("traceStoreThresholdMillis")
  @Override
  public int traceStoreThresholdMillis() {
    return traceStoreThresholdMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code profilingIntervalMillis} attribute
   */
  @JsonProperty("profilingIntervalMillis")
  @Override
  public int profilingIntervalMillis() {
    return profilingIntervalMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultDisplayedTransactionType} attribute
   */
  @JsonProperty("defaultDisplayedTransactionType")
  @Override
  public String defaultDisplayedTransactionType() {
    return defaultDisplayedTransactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultDisplayedPercentiles} attribute
   */
  @JsonProperty("defaultDisplayedPercentiles")
  @Override
  public ImmutableList<Double> defaultDisplayedPercentiles() {
    return defaultDisplayedPercentiles;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.GeneralConfigDtoBase#enabled() enabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for enabled
   * @return modified copy of the {@code this} object
   */
  public final GeneralConfigDto withEnabled(boolean value) {
    if (this.enabled == value) {
      return this;
    }
    boolean newValue = value;
    return new GeneralConfigDto(
        this,
        newValue,
        this.traceStoreThresholdMillis,
        this.profilingIntervalMillis,
        this.defaultDisplayedTransactionType,
        this.defaultDisplayedPercentiles,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.GeneralConfigDtoBase#traceStoreThresholdMillis() traceStoreThresholdMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceStoreThresholdMillis
   * @return modified copy of the {@code this} object
   */
  public final GeneralConfigDto withTraceStoreThresholdMillis(int value) {
    if (this.traceStoreThresholdMillis == value) {
      return this;
    }
    int newValue = value;
    return new GeneralConfigDto(
        this,
        this.enabled,
        newValue,
        this.profilingIntervalMillis,
        this.defaultDisplayedTransactionType,
        this.defaultDisplayedPercentiles,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.GeneralConfigDtoBase#profilingIntervalMillis() profilingIntervalMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for profilingIntervalMillis
   * @return modified copy of the {@code this} object
   */
  public final GeneralConfigDto withProfilingIntervalMillis(int value) {
    if (this.profilingIntervalMillis == value) {
      return this;
    }
    int newValue = value;
    return new GeneralConfigDto(
        this,
        this.enabled,
        this.traceStoreThresholdMillis,
        newValue,
        this.defaultDisplayedTransactionType,
        this.defaultDisplayedPercentiles,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.GeneralConfigDtoBase#defaultDisplayedTransactionType() defaultDisplayedTransactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for defaultDisplayedTransactionType
   * @return modified copy of the {@code this} object
   */
  public final GeneralConfigDto withDefaultDisplayedTransactionType(String value) {
    if (this.defaultDisplayedTransactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new GeneralConfigDto(
        this,
        this.enabled,
        this.traceStoreThresholdMillis,
        this.profilingIntervalMillis,
        newValue,
        this.defaultDisplayedPercentiles,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ConfigJsonService.GeneralConfigDtoBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final GeneralConfigDto withDefaultDisplayedPercentiles(double... elements) {
    ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
    return new GeneralConfigDto(
        this,
        this.enabled,
        this.traceStoreThresholdMillis,
        this.profilingIntervalMillis,
        this.defaultDisplayedTransactionType,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ConfigJsonService.GeneralConfigDtoBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of defaultDisplayedPercentiles elements to set
   * @return modified copy of {@code this} object
   */
  public final GeneralConfigDto withDefaultDisplayedPercentiles(Iterable<Double> elements) {
    if (this.defaultDisplayedPercentiles == elements) {
      return this;
    }
    ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
    return new GeneralConfigDto(
        this,
        this.enabled,
        this.traceStoreThresholdMillis,
        this.profilingIntervalMillis,
        this.defaultDisplayedTransactionType,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.GeneralConfigDtoBase#version() version}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version
   * @return modified copy of the {@code this} object
   */
  public final GeneralConfigDto withVersion(String value) {
    if (this.version == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new GeneralConfigDto(
        this,
        this.enabled,
        this.traceStoreThresholdMillis,
        this.profilingIntervalMillis,
        this.defaultDisplayedTransactionType,
        this.defaultDisplayedPercentiles,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code GeneralConfigDto} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof GeneralConfigDto && equalTo((GeneralConfigDto) another));
  }
  
  private boolean equalTo(GeneralConfigDto another) {
    return enabled == another.enabled
        && traceStoreThresholdMillis == another.traceStoreThresholdMillis
        && profilingIntervalMillis == another.profilingIntervalMillis
        && defaultDisplayedTransactionType.equals(another.defaultDisplayedTransactionType)
        && defaultDisplayedPercentiles.equals(another.defaultDisplayedPercentiles)
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code enabled}, {@code traceStoreThresholdMillis}, {@code profilingIntervalMillis}, {@code defaultDisplayedTransactionType}, {@code defaultDisplayedPercentiles}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(enabled);
    h = h * 17 + traceStoreThresholdMillis;
    h = h * 17 + profilingIntervalMillis;
    h = h * 17 + defaultDisplayedTransactionType.hashCode();
    h = h * 17 + defaultDisplayedPercentiles.hashCode();
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code GeneralConfigDto{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GeneralConfigDto")
        .add("enabled", enabled)
        .add("traceStoreThresholdMillis", traceStoreThresholdMillis)
        .add("profilingIntervalMillis", profilingIntervalMillis)
        .add("defaultDisplayedTransactionType", defaultDisplayedTransactionType)
        .add("defaultDisplayedPercentiles", defaultDisplayedPercentiles)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static GeneralConfigDto fromAllAttributes(
      @JsonProperty("enabled") @Nullable Boolean enabled,
      @JsonProperty("traceStoreThresholdMillis") @Nullable Integer traceStoreThresholdMillis,
      @JsonProperty("profilingIntervalMillis") @Nullable Integer profilingIntervalMillis,
      @JsonProperty("defaultDisplayedTransactionType") @Nullable String defaultDisplayedTransactionType,
      @JsonProperty("defaultDisplayedPercentiles") @Nullable ImmutableList<Double> defaultDisplayedPercentiles,
      @JsonProperty("version") @Nullable String version) {
    GeneralConfigDto.Builder builder = GeneralConfigDto.builder();
    if (enabled != null) {
      builder.enabled(enabled);
    }
    if (traceStoreThresholdMillis != null) {
      builder.traceStoreThresholdMillis(traceStoreThresholdMillis);
    }
    if (profilingIntervalMillis != null) {
      builder.profilingIntervalMillis(profilingIntervalMillis);
    }
    if (defaultDisplayedTransactionType != null) {
      builder.defaultDisplayedTransactionType(defaultDisplayedTransactionType);
    }
    if (defaultDisplayedPercentiles != null) {
      builder.addAllDefaultDisplayedPercentiles(defaultDisplayedPercentiles);
    }
    if (version != null) {
      builder.version(version);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.GeneralConfigDtoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable GeneralConfigDto instance
   */
  static GeneralConfigDto copyOf(ConfigJsonService.GeneralConfigDtoBase instance) {
    if (instance instanceof GeneralConfigDto) {
      return (GeneralConfigDto) instance;
    }
    return GeneralConfigDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.GeneralConfigDto}.
   * @return new GeneralConfigDto builder
   */
  static GeneralConfigDto.Builder builder() {
    return new GeneralConfigDto.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.GeneralConfigDto}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1f;
    private static final long INITIALIZED_BIT_ENABLED = 0x1L;
    private static final long INITIALIZED_BIT_TRACE_STORE_THRESHOLD_MILLIS = 0x2L;
    private static final long INITIALIZED_BIT_PROFILING_INTERVAL_MILLIS = 0x4L;
    private static final long INITIALIZED_BIT_DEFAULT_DISPLAYED_TRANSACTION_TYPE = 0x8L;
    private static final long INITIALIZED_BIT_VERSION = 0x10L;
    private long initializedBitset;
  
    private boolean enabled;
    private int traceStoreThresholdMillis;
    private int profilingIntervalMillis;
    private @Nullable String defaultDisplayedTransactionType;
    private ImmutableList.Builder<Double> defaultDisplayedPercentilesBuilder = ImmutableList.builder();
    private @Nullable String version;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link ConfigJsonService.GeneralConfigDtoBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(ConfigJsonService.GeneralConfigDtoBase instance) {
      Preconditions.checkNotNull(instance);
      enabled(instance.enabled());
      traceStoreThresholdMillis(instance.traceStoreThresholdMillis());
      profilingIntervalMillis(instance.profilingIntervalMillis());
      defaultDisplayedTransactionType(instance.defaultDisplayedTransactionType());
      addAllDefaultDisplayedPercentiles(instance.defaultDisplayedPercentiles());
      version(instance.version());
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.GeneralConfigDtoBase#enabled() enabled}.
     * @param enabled value for enabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder enabled(boolean enabled) {
      this.enabled = enabled;
      initializedBitset |= INITIALIZED_BIT_ENABLED;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.GeneralConfigDtoBase#traceStoreThresholdMillis() traceStoreThresholdMillis}.
     * @param traceStoreThresholdMillis value for traceStoreThresholdMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceStoreThresholdMillis(int traceStoreThresholdMillis) {
      this.traceStoreThresholdMillis = traceStoreThresholdMillis;
      initializedBitset |= INITIALIZED_BIT_TRACE_STORE_THRESHOLD_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.GeneralConfigDtoBase#profilingIntervalMillis() profilingIntervalMillis}.
     * @param profilingIntervalMillis value for profilingIntervalMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder profilingIntervalMillis(int profilingIntervalMillis) {
      this.profilingIntervalMillis = profilingIntervalMillis;
      initializedBitset |= INITIALIZED_BIT_PROFILING_INTERVAL_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.GeneralConfigDtoBase#defaultDisplayedTransactionType() defaultDisplayedTransactionType}.
     * @param defaultDisplayedTransactionType value for defaultDisplayedTransactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder defaultDisplayedTransactionType(String defaultDisplayedTransactionType) {
      this.defaultDisplayedTransactionType = Preconditions.checkNotNull(defaultDisplayedTransactionType);
      initializedBitset |= INITIALIZED_BIT_DEFAULT_DISPLAYED_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Adds one element to {@link ConfigJsonService.GeneralConfigDtoBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles} list.
     * @param element defaultDisplayedPercentiles element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addDefaultDisplayedPercentiles(double element) {
      defaultDisplayedPercentilesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ConfigJsonService.GeneralConfigDtoBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles} list.
     * @param elements array of defaultDisplayedPercentiles elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addDefaultDisplayedPercentiles(double... elements) {
      defaultDisplayedPercentilesBuilder.addAll(Doubles.asList(elements));
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link ConfigJsonService.GeneralConfigDtoBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles} list.
     * @param elements iterable of defaultDisplayedPercentiles elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder defaultDisplayedPercentiles(Iterable<Double> elements) {
      defaultDisplayedPercentilesBuilder = ImmutableList.builder();
      return addAllDefaultDisplayedPercentiles(elements);
    }
  
    /**
     * Adds elements to {@link ConfigJsonService.GeneralConfigDtoBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles} list.
     * @param elements iterable of defaultDisplayedPercentiles elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllDefaultDisplayedPercentiles(Iterable<Double> elements) {
      defaultDisplayedPercentilesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.GeneralConfigDtoBase#version() version}.
     * @param version value for version
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(String version) {
      this.version = Preconditions.checkNotNull(version);
      initializedBitset |= INITIALIZED_BIT_VERSION;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.GeneralConfigDto}.
     * @return immutable instance of GeneralConfigDto
     */
    public org.glowroot.local.ui.GeneralConfigDto build() {
      checkRequiredAttributes();
      return new GeneralConfigDto(this);
    }
  
    private boolean enabledIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ENABLED) != 0;
    }
  
    private boolean traceStoreThresholdMillisIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRACE_STORE_THRESHOLD_MILLIS) != 0;
    }
  
    private boolean profilingIntervalMillisIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PROFILING_INTERVAL_MILLIS) != 0;
    }
  
    private boolean defaultDisplayedTransactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DEFAULT_DISPLAYED_TRANSACTION_TYPE) != 0;
    }
  
    private boolean versionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VERSION) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!enabledIsSet()) {
        attributes.add("enabled");
      }
      if (!traceStoreThresholdMillisIsSet()) {
        attributes.add("traceStoreThresholdMillis");
      }
      if (!profilingIntervalMillisIsSet()) {
        attributes.add("profilingIntervalMillis");
      }
      if (!defaultDisplayedTransactionTypeIsSet()) {
        attributes.add("defaultDisplayedTransactionType");
      }
      if (!versionIsSet()) {
        attributes.add("version");
      }
      return "Cannot build GeneralConfigDto, some of required attributes are not set " + attributes;
    }
  }
}
