package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.AnonymousAccess;

/**
 * Immutable implementation of {@link LayoutBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code Layout.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "LayoutBase"})
@Immutable
final class Layout extends LayoutBase {
  private final boolean jvmHeapDump;
  private final String footerMessage;
  private final boolean adminPasswordEnabled;
  private final boolean readOnlyPasswordEnabled;
  private final AnonymousAccess anonymousAccess;
  private final ImmutableList<String> transactionTypes;
  private final String defaultTransactionType;
  private final ImmutableList<Double> defaultPercentiles;
  private final ImmutableList<String> transactionCustomAttributes;
  private final long fixedAggregateIntervalSeconds;
  private final long fixedAggregateRollupSeconds;
  private final long fixedGaugeIntervalSeconds;
  private final long fixedGaugeRollupSeconds;
  private final String version;

  private Layout(Layout.Builder builder) {
    this.jvmHeapDump = builder.jvmHeapDump;
    this.footerMessage = builder.footerMessage;
    this.adminPasswordEnabled = builder.adminPasswordEnabled;
    this.readOnlyPasswordEnabled = builder.readOnlyPasswordEnabled;
    this.anonymousAccess = builder.anonymousAccess;
    this.transactionTypes = builder.transactionTypesBuilder.build();
    this.defaultTransactionType = builder.defaultTransactionType;
    this.defaultPercentiles = builder.defaultPercentilesBuilder.build();
    this.transactionCustomAttributes = builder.transactionCustomAttributesBuilder.build();
    this.fixedAggregateIntervalSeconds = builder.fixedAggregateIntervalSeconds;
    this.fixedAggregateRollupSeconds = builder.fixedAggregateRollupSeconds;
    this.fixedGaugeIntervalSeconds = builder.fixedGaugeIntervalSeconds;
    this.fixedGaugeRollupSeconds = builder.fixedGaugeRollupSeconds;
    this.version = Preconditions.checkNotNull(super.version());
  }

  private Layout(
      Layout original,
      boolean jvmHeapDump,
      String footerMessage,
      boolean adminPasswordEnabled,
      boolean readOnlyPasswordEnabled,
      AnonymousAccess anonymousAccess,
      ImmutableList<String> transactionTypes,
      String defaultTransactionType,
      ImmutableList<Double> defaultPercentiles,
      ImmutableList<String> transactionCustomAttributes,
      long fixedAggregateIntervalSeconds,
      long fixedAggregateRollupSeconds,
      long fixedGaugeIntervalSeconds,
      long fixedGaugeRollupSeconds) {
    this.jvmHeapDump = jvmHeapDump;
    this.footerMessage = footerMessage;
    this.adminPasswordEnabled = adminPasswordEnabled;
    this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
    this.anonymousAccess = anonymousAccess;
    this.transactionTypes = transactionTypes;
    this.defaultTransactionType = defaultTransactionType;
    this.defaultPercentiles = defaultPercentiles;
    this.transactionCustomAttributes = transactionCustomAttributes;
    this.fixedAggregateIntervalSeconds = fixedAggregateIntervalSeconds;
    this.fixedAggregateRollupSeconds = fixedAggregateRollupSeconds;
    this.fixedGaugeIntervalSeconds = fixedGaugeIntervalSeconds;
    this.fixedGaugeRollupSeconds = fixedGaugeRollupSeconds;
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code jvmHeapDump} attribute
   */
  @JsonProperty("jvmHeapDump")
  @Override
  public boolean jvmHeapDump() {
    return jvmHeapDump;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code footerMessage} attribute
   */
  @JsonProperty("footerMessage")
  @Override
  public String footerMessage() {
    return footerMessage;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code adminPasswordEnabled} attribute
   */
  @JsonProperty("adminPasswordEnabled")
  @Override
  public boolean adminPasswordEnabled() {
    return adminPasswordEnabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code readOnlyPasswordEnabled} attribute
   */
  @JsonProperty("readOnlyPasswordEnabled")
  @Override
  public boolean readOnlyPasswordEnabled() {
    return readOnlyPasswordEnabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code anonymousAccess} attribute
   */
  @JsonProperty("anonymousAccess")
  @Override
  public AnonymousAccess anonymousAccess() {
    return anonymousAccess;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionTypes} attribute
   */
  @JsonProperty("transactionTypes")
  @Override
  public ImmutableList<String> transactionTypes() {
    return transactionTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultTransactionType} attribute
   */
  @JsonProperty("defaultTransactionType")
  @Override
  public String defaultTransactionType() {
    return defaultTransactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultPercentiles} attribute
   */
  @JsonProperty("defaultPercentiles")
  @Override
  public ImmutableList<Double> defaultPercentiles() {
    return defaultPercentiles;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCustomAttributes} attribute
   */
  @JsonProperty("transactionCustomAttributes")
  @Override
  public ImmutableList<String> transactionCustomAttributes() {
    return transactionCustomAttributes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code fixedAggregateIntervalSeconds} attribute
   */
  @JsonProperty("fixedAggregateIntervalSeconds")
  @Override
  public long fixedAggregateIntervalSeconds() {
    return fixedAggregateIntervalSeconds;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code fixedAggregateRollupSeconds} attribute
   */
  @JsonProperty("fixedAggregateRollupSeconds")
  @Override
  public long fixedAggregateRollupSeconds() {
    return fixedAggregateRollupSeconds;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code fixedGaugeIntervalSeconds} attribute
   */
  @JsonProperty("fixedGaugeIntervalSeconds")
  @Override
  public long fixedGaugeIntervalSeconds() {
    return fixedGaugeIntervalSeconds;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code fixedGaugeRollupSeconds} attribute
   */
  @JsonProperty("fixedGaugeRollupSeconds")
  @Override
  public long fixedGaugeRollupSeconds() {
    return fixedGaugeRollupSeconds;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#jvmHeapDump() jvmHeapDump}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for jvmHeapDump
   * @return modified copy of the {@code this} object
   */
  public final Layout withJvmHeapDump(boolean value) {
    if (this.jvmHeapDump == value) {
      return this;
    }
    boolean newValue = value;
    return new Layout(
        this,
        newValue,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#footerMessage() footerMessage}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for footerMessage
   * @return modified copy of the {@code this} object
   */
  public final Layout withFooterMessage(String value) {
    if (this.footerMessage == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Layout(
        this,
        this.jvmHeapDump,
        newValue,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#adminPasswordEnabled() adminPasswordEnabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for adminPasswordEnabled
   * @return modified copy of the {@code this} object
   */
  public final Layout withAdminPasswordEnabled(boolean value) {
    if (this.adminPasswordEnabled == value) {
      return this;
    }
    boolean newValue = value;
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        newValue,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#readOnlyPasswordEnabled() readOnlyPasswordEnabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for readOnlyPasswordEnabled
   * @return modified copy of the {@code this} object
   */
  public final Layout withReadOnlyPasswordEnabled(boolean value) {
    if (this.readOnlyPasswordEnabled == value) {
      return this;
    }
    boolean newValue = value;
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        newValue,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#anonymousAccess() anonymousAccess}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for anonymousAccess
   * @return modified copy of the {@code this} object
   */
  public final Layout withAnonymousAccess(AnonymousAccess value) {
    if (this.anonymousAccess == value) {
      return this;
    }
    AnonymousAccess newValue = Preconditions.checkNotNull(value);
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        newValue,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#transactionTypes() transactionTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withTransactionTypes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        newValue,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#transactionTypes() transactionTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of transactionTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withTransactionTypes(Iterable<String> elements) {
    if (this.transactionTypes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        newValue,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#defaultTransactionType() defaultTransactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for defaultTransactionType
   * @return modified copy of the {@code this} object
   */
  public final Layout withDefaultTransactionType(String value) {
    if (this.defaultTransactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        newValue,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#defaultPercentiles() defaultPercentiles}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withDefaultPercentiles(double... elements) {
    ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        newValue,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#defaultPercentiles() defaultPercentiles}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of defaultPercentiles elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withDefaultPercentiles(Iterable<Double> elements) {
    if (this.defaultPercentiles == elements) {
      return this;
    }
    ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        newValue,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#transactionCustomAttributes() transactionCustomAttributes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withTransactionCustomAttributes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        newValue,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#transactionCustomAttributes() transactionCustomAttributes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of transactionCustomAttributes elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withTransactionCustomAttributes(Iterable<String> elements) {
    if (this.transactionCustomAttributes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        newValue,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#fixedAggregateIntervalSeconds() fixedAggregateIntervalSeconds}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for fixedAggregateIntervalSeconds
   * @return modified copy of the {@code this} object
   */
  public final Layout withFixedAggregateIntervalSeconds(long value) {
    if (this.fixedAggregateIntervalSeconds == value) {
      return this;
    }
    long newValue = value;
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        newValue,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#fixedAggregateRollupSeconds() fixedAggregateRollupSeconds}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for fixedAggregateRollupSeconds
   * @return modified copy of the {@code this} object
   */
  public final Layout withFixedAggregateRollupSeconds(long value) {
    if (this.fixedAggregateRollupSeconds == value) {
      return this;
    }
    long newValue = value;
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        newValue,
        this.fixedGaugeIntervalSeconds,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#fixedGaugeIntervalSeconds() fixedGaugeIntervalSeconds}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for fixedGaugeIntervalSeconds
   * @return modified copy of the {@code this} object
   */
  public final Layout withFixedGaugeIntervalSeconds(long value) {
    if (this.fixedGaugeIntervalSeconds == value) {
      return this;
    }
    long newValue = value;
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        newValue,
        this.fixedGaugeRollupSeconds);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#fixedGaugeRollupSeconds() fixedGaugeRollupSeconds}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for fixedGaugeRollupSeconds
   * @return modified copy of the {@code this} object
   */
  public final Layout withFixedGaugeRollupSeconds(long value) {
    if (this.fixedGaugeRollupSeconds == value) {
      return this;
    }
    long newValue = value;
    return new Layout(
        this,
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.fixedAggregateIntervalSeconds,
        this.fixedAggregateRollupSeconds,
        this.fixedGaugeIntervalSeconds,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code Layout} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof Layout && equalTo((Layout) another));
  }
  
  private boolean equalTo(Layout another) {
    return jvmHeapDump == another.jvmHeapDump
        && footerMessage.equals(another.footerMessage)
        && adminPasswordEnabled == another.adminPasswordEnabled
        && readOnlyPasswordEnabled == another.readOnlyPasswordEnabled
        && anonymousAccess.equals(another.anonymousAccess)
        && transactionTypes.equals(another.transactionTypes)
        && defaultTransactionType.equals(another.defaultTransactionType)
        && defaultPercentiles.equals(another.defaultPercentiles)
        && transactionCustomAttributes.equals(another.transactionCustomAttributes)
        && fixedAggregateIntervalSeconds == another.fixedAggregateIntervalSeconds
        && fixedAggregateRollupSeconds == another.fixedAggregateRollupSeconds
        && fixedGaugeIntervalSeconds == another.fixedGaugeIntervalSeconds
        && fixedGaugeRollupSeconds == another.fixedGaugeRollupSeconds
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code jvmHeapDump}, {@code footerMessage}, {@code adminPasswordEnabled}, {@code readOnlyPasswordEnabled}, {@code anonymousAccess}, {@code transactionTypes}, {@code defaultTransactionType}, {@code defaultPercentiles}, {@code transactionCustomAttributes}, {@code fixedAggregateIntervalSeconds}, {@code fixedAggregateRollupSeconds}, {@code fixedGaugeIntervalSeconds}, {@code fixedGaugeRollupSeconds}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(jvmHeapDump);
    h = h * 17 + footerMessage.hashCode();
    h = h * 17 + Booleans.hashCode(adminPasswordEnabled);
    h = h * 17 + Booleans.hashCode(readOnlyPasswordEnabled);
    h = h * 17 + anonymousAccess.hashCode();
    h = h * 17 + transactionTypes.hashCode();
    h = h * 17 + defaultTransactionType.hashCode();
    h = h * 17 + defaultPercentiles.hashCode();
    h = h * 17 + transactionCustomAttributes.hashCode();
    h = h * 17 + Longs.hashCode(fixedAggregateIntervalSeconds);
    h = h * 17 + Longs.hashCode(fixedAggregateRollupSeconds);
    h = h * 17 + Longs.hashCode(fixedGaugeIntervalSeconds);
    h = h * 17 + Longs.hashCode(fixedGaugeRollupSeconds);
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Layout{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Layout")
        .add("jvmHeapDump", jvmHeapDump)
        .add("footerMessage", footerMessage)
        .add("adminPasswordEnabled", adminPasswordEnabled)
        .add("readOnlyPasswordEnabled", readOnlyPasswordEnabled)
        .add("anonymousAccess", anonymousAccess)
        .add("transactionTypes", transactionTypes)
        .add("defaultTransactionType", defaultTransactionType)
        .add("defaultPercentiles", defaultPercentiles)
        .add("transactionCustomAttributes", transactionCustomAttributes)
        .add("fixedAggregateIntervalSeconds", fixedAggregateIntervalSeconds)
        .add("fixedAggregateRollupSeconds", fixedAggregateRollupSeconds)
        .add("fixedGaugeIntervalSeconds", fixedGaugeIntervalSeconds)
        .add("fixedGaugeRollupSeconds", fixedGaugeRollupSeconds)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static Layout fromAllAttributes(
      @JsonProperty("jvmHeapDump") @Nullable Boolean jvmHeapDump,
      @JsonProperty("footerMessage") @Nullable String footerMessage,
      @JsonProperty("adminPasswordEnabled") @Nullable Boolean adminPasswordEnabled,
      @JsonProperty("readOnlyPasswordEnabled") @Nullable Boolean readOnlyPasswordEnabled,
      @JsonProperty("anonymousAccess") @Nullable AnonymousAccess anonymousAccess,
      @JsonProperty("transactionTypes") @Nullable ImmutableList<String> transactionTypes,
      @JsonProperty("defaultTransactionType") @Nullable String defaultTransactionType,
      @JsonProperty("defaultPercentiles") @Nullable ImmutableList<Double> defaultPercentiles,
      @JsonProperty("transactionCustomAttributes") @Nullable ImmutableList<String> transactionCustomAttributes,
      @JsonProperty("fixedAggregateIntervalSeconds") @Nullable Long fixedAggregateIntervalSeconds,
      @JsonProperty("fixedAggregateRollupSeconds") @Nullable Long fixedAggregateRollupSeconds,
      @JsonProperty("fixedGaugeIntervalSeconds") @Nullable Long fixedGaugeIntervalSeconds,
      @JsonProperty("fixedGaugeRollupSeconds") @Nullable Long fixedGaugeRollupSeconds) {
    Layout.Builder builder = Layout.builder();
    if (jvmHeapDump != null) {
      builder.jvmHeapDump(jvmHeapDump);
    }
    if (footerMessage != null) {
      builder.footerMessage(footerMessage);
    }
    if (adminPasswordEnabled != null) {
      builder.adminPasswordEnabled(adminPasswordEnabled);
    }
    if (readOnlyPasswordEnabled != null) {
      builder.readOnlyPasswordEnabled(readOnlyPasswordEnabled);
    }
    if (anonymousAccess != null) {
      builder.anonymousAccess(anonymousAccess);
    }
    if (transactionTypes != null) {
      builder.addAllTransactionTypes(transactionTypes);
    }
    if (defaultTransactionType != null) {
      builder.defaultTransactionType(defaultTransactionType);
    }
    if (defaultPercentiles != null) {
      builder.addAllDefaultPercentiles(defaultPercentiles);
    }
    if (transactionCustomAttributes != null) {
      builder.addAllTransactionCustomAttributes(transactionCustomAttributes);
    }
    if (fixedAggregateIntervalSeconds != null) {
      builder.fixedAggregateIntervalSeconds(fixedAggregateIntervalSeconds);
    }
    if (fixedAggregateRollupSeconds != null) {
      builder.fixedAggregateRollupSeconds(fixedAggregateRollupSeconds);
    }
    if (fixedGaugeIntervalSeconds != null) {
      builder.fixedGaugeIntervalSeconds(fixedGaugeIntervalSeconds);
    }
    if (fixedGaugeRollupSeconds != null) {
      builder.fixedGaugeRollupSeconds(fixedGaugeRollupSeconds);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link LayoutBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable Layout instance
   */
  static Layout copyOf(LayoutBase instance) {
    if (instance instanceof Layout) {
      return (Layout) instance;
    }
    return Layout.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.Layout}.
   * @return new Layout builder
   */
  static Layout.Builder builder() {
    return new Layout.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.Layout}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3ff;
    private static final long INITIALIZED_BIT_JVM_HEAP_DUMP = 0x1L;
    private static final long INITIALIZED_BIT_FOOTER_MESSAGE = 0x2L;
    private static final long INITIALIZED_BIT_ADMIN_PASSWORD_ENABLED = 0x4L;
    private static final long INITIALIZED_BIT_READ_ONLY_PASSWORD_ENABLED = 0x8L;
    private static final long INITIALIZED_BIT_ANONYMOUS_ACCESS = 0x10L;
    private static final long INITIALIZED_BIT_DEFAULT_TRANSACTION_TYPE = 0x20L;
    private static final long INITIALIZED_BIT_FIXED_AGGREGATE_INTERVAL_SECONDS = 0x40L;
    private static final long INITIALIZED_BIT_FIXED_AGGREGATE_ROLLUP_SECONDS = 0x80L;
    private static final long INITIALIZED_BIT_FIXED_GAUGE_INTERVAL_SECONDS = 0x100L;
    private static final long INITIALIZED_BIT_FIXED_GAUGE_ROLLUP_SECONDS = 0x200L;
    private long initializedBitset;
  
    private boolean jvmHeapDump;
    private @Nullable String footerMessage;
    private boolean adminPasswordEnabled;
    private boolean readOnlyPasswordEnabled;
    private @Nullable AnonymousAccess anonymousAccess;
    private ImmutableList.Builder<String> transactionTypesBuilder = ImmutableList.builder();
    private @Nullable String defaultTransactionType;
    private ImmutableList.Builder<Double> defaultPercentilesBuilder = ImmutableList.builder();
    private ImmutableList.Builder<String> transactionCustomAttributesBuilder = ImmutableList.builder();
    private long fixedAggregateIntervalSeconds;
    private long fixedAggregateRollupSeconds;
    private long fixedGaugeIntervalSeconds;
    private long fixedGaugeRollupSeconds;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link LayoutBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(LayoutBase instance) {
      Preconditions.checkNotNull(instance);
      jvmHeapDump(instance.jvmHeapDump());
      footerMessage(instance.footerMessage());
      adminPasswordEnabled(instance.adminPasswordEnabled());
      readOnlyPasswordEnabled(instance.readOnlyPasswordEnabled());
      anonymousAccess(instance.anonymousAccess());
      addAllTransactionTypes(instance.transactionTypes());
      defaultTransactionType(instance.defaultTransactionType());
      addAllDefaultPercentiles(instance.defaultPercentiles());
      addAllTransactionCustomAttributes(instance.transactionCustomAttributes());
      fixedAggregateIntervalSeconds(instance.fixedAggregateIntervalSeconds());
      fixedAggregateRollupSeconds(instance.fixedAggregateRollupSeconds());
      fixedGaugeIntervalSeconds(instance.fixedGaugeIntervalSeconds());
      fixedGaugeRollupSeconds(instance.fixedGaugeRollupSeconds());
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#jvmHeapDump() jvmHeapDump}.
     * @param jvmHeapDump value for jvmHeapDump
     * @return {@code this} builder for chained invocation
     */
    public final Builder jvmHeapDump(boolean jvmHeapDump) {
      this.jvmHeapDump = jvmHeapDump;
      initializedBitset |= INITIALIZED_BIT_JVM_HEAP_DUMP;
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#footerMessage() footerMessage}.
     * @param footerMessage value for footerMessage
     * @return {@code this} builder for chained invocation
     */
    public final Builder footerMessage(String footerMessage) {
      this.footerMessage = Preconditions.checkNotNull(footerMessage);
      initializedBitset |= INITIALIZED_BIT_FOOTER_MESSAGE;
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#adminPasswordEnabled() adminPasswordEnabled}.
     * @param adminPasswordEnabled value for adminPasswordEnabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder adminPasswordEnabled(boolean adminPasswordEnabled) {
      this.adminPasswordEnabled = adminPasswordEnabled;
      initializedBitset |= INITIALIZED_BIT_ADMIN_PASSWORD_ENABLED;
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#readOnlyPasswordEnabled() readOnlyPasswordEnabled}.
     * @param readOnlyPasswordEnabled value for readOnlyPasswordEnabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder readOnlyPasswordEnabled(boolean readOnlyPasswordEnabled) {
      this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
      initializedBitset |= INITIALIZED_BIT_READ_ONLY_PASSWORD_ENABLED;
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#anonymousAccess() anonymousAccess}.
     * @param anonymousAccess value for anonymousAccess
     * @return {@code this} builder for chained invocation
     */
    public final Builder anonymousAccess(AnonymousAccess anonymousAccess) {
      this.anonymousAccess = Preconditions.checkNotNull(anonymousAccess);
      initializedBitset |= INITIALIZED_BIT_ANONYMOUS_ACCESS;
      return this;
    }
  
    /**
     * Adds one element to {@link LayoutBase#transactionTypes() transactionTypes} list.
     * @param element transactionTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTransactionTypes(String element) {
      transactionTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#transactionTypes() transactionTypes} list.
     * @param elements array of transactionTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTransactionTypes(String... elements) {
      transactionTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link LayoutBase#transactionTypes() transactionTypes} list.
     * @param elements iterable of transactionTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionTypes(Iterable<String> elements) {
      transactionTypesBuilder = ImmutableList.builder();
      return addAllTransactionTypes(elements);
    }
  
    /**
     * Adds elements to {@link LayoutBase#transactionTypes() transactionTypes} list.
     * @param elements iterable of transactionTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllTransactionTypes(Iterable<String> elements) {
      transactionTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#defaultTransactionType() defaultTransactionType}.
     * @param defaultTransactionType value for defaultTransactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder defaultTransactionType(String defaultTransactionType) {
      this.defaultTransactionType = Preconditions.checkNotNull(defaultTransactionType);
      initializedBitset |= INITIALIZED_BIT_DEFAULT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Adds one element to {@link LayoutBase#defaultPercentiles() defaultPercentiles} list.
     * @param element defaultPercentiles element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addDefaultPercentiles(double element) {
      defaultPercentilesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#defaultPercentiles() defaultPercentiles} list.
     * @param elements array of defaultPercentiles elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addDefaultPercentiles(double... elements) {
      defaultPercentilesBuilder.addAll(Doubles.asList(elements));
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link LayoutBase#defaultPercentiles() defaultPercentiles} list.
     * @param elements iterable of defaultPercentiles elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder defaultPercentiles(Iterable<Double> elements) {
      defaultPercentilesBuilder = ImmutableList.builder();
      return addAllDefaultPercentiles(elements);
    }
  
    /**
     * Adds elements to {@link LayoutBase#defaultPercentiles() defaultPercentiles} list.
     * @param elements iterable of defaultPercentiles elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllDefaultPercentiles(Iterable<Double> elements) {
      defaultPercentilesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link LayoutBase#transactionCustomAttributes() transactionCustomAttributes} list.
     * @param element transactionCustomAttributes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTransactionCustomAttributes(String element) {
      transactionCustomAttributesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#transactionCustomAttributes() transactionCustomAttributes} list.
     * @param elements array of transactionCustomAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTransactionCustomAttributes(String... elements) {
      transactionCustomAttributesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link LayoutBase#transactionCustomAttributes() transactionCustomAttributes} list.
     * @param elements iterable of transactionCustomAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionCustomAttributes(Iterable<String> elements) {
      transactionCustomAttributesBuilder = ImmutableList.builder();
      return addAllTransactionCustomAttributes(elements);
    }
  
    /**
     * Adds elements to {@link LayoutBase#transactionCustomAttributes() transactionCustomAttributes} list.
     * @param elements iterable of transactionCustomAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllTransactionCustomAttributes(Iterable<String> elements) {
      transactionCustomAttributesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#fixedAggregateIntervalSeconds() fixedAggregateIntervalSeconds}.
     * @param fixedAggregateIntervalSeconds value for fixedAggregateIntervalSeconds
     * @return {@code this} builder for chained invocation
     */
    public final Builder fixedAggregateIntervalSeconds(long fixedAggregateIntervalSeconds) {
      this.fixedAggregateIntervalSeconds = fixedAggregateIntervalSeconds;
      initializedBitset |= INITIALIZED_BIT_FIXED_AGGREGATE_INTERVAL_SECONDS;
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#fixedAggregateRollupSeconds() fixedAggregateRollupSeconds}.
     * @param fixedAggregateRollupSeconds value for fixedAggregateRollupSeconds
     * @return {@code this} builder for chained invocation
     */
    public final Builder fixedAggregateRollupSeconds(long fixedAggregateRollupSeconds) {
      this.fixedAggregateRollupSeconds = fixedAggregateRollupSeconds;
      initializedBitset |= INITIALIZED_BIT_FIXED_AGGREGATE_ROLLUP_SECONDS;
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#fixedGaugeIntervalSeconds() fixedGaugeIntervalSeconds}.
     * @param fixedGaugeIntervalSeconds value for fixedGaugeIntervalSeconds
     * @return {@code this} builder for chained invocation
     */
    public final Builder fixedGaugeIntervalSeconds(long fixedGaugeIntervalSeconds) {
      this.fixedGaugeIntervalSeconds = fixedGaugeIntervalSeconds;
      initializedBitset |= INITIALIZED_BIT_FIXED_GAUGE_INTERVAL_SECONDS;
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#fixedGaugeRollupSeconds() fixedGaugeRollupSeconds}.
     * @param fixedGaugeRollupSeconds value for fixedGaugeRollupSeconds
     * @return {@code this} builder for chained invocation
     */
    public final Builder fixedGaugeRollupSeconds(long fixedGaugeRollupSeconds) {
      this.fixedGaugeRollupSeconds = fixedGaugeRollupSeconds;
      initializedBitset |= INITIALIZED_BIT_FIXED_GAUGE_ROLLUP_SECONDS;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.Layout}.
     * @return immutable instance of Layout
     */
    public org.glowroot.local.ui.Layout build() {
      checkRequiredAttributes();
      return new Layout(this);
    }
  
    private boolean jvmHeapDumpIsSet() {
      return (initializedBitset & INITIALIZED_BIT_JVM_HEAP_DUMP) != 0;
    }
  
    private boolean footerMessageIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FOOTER_MESSAGE) != 0;
    }
  
    private boolean adminPasswordEnabledIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ADMIN_PASSWORD_ENABLED) != 0;
    }
  
    private boolean readOnlyPasswordEnabledIsSet() {
      return (initializedBitset & INITIALIZED_BIT_READ_ONLY_PASSWORD_ENABLED) != 0;
    }
  
    private boolean anonymousAccessIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ANONYMOUS_ACCESS) != 0;
    }
  
    private boolean defaultTransactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DEFAULT_TRANSACTION_TYPE) != 0;
    }
  
    private boolean fixedAggregateIntervalSecondsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FIXED_AGGREGATE_INTERVAL_SECONDS) != 0;
    }
  
    private boolean fixedAggregateRollupSecondsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FIXED_AGGREGATE_ROLLUP_SECONDS) != 0;
    }
  
    private boolean fixedGaugeIntervalSecondsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FIXED_GAUGE_INTERVAL_SECONDS) != 0;
    }
  
    private boolean fixedGaugeRollupSecondsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FIXED_GAUGE_ROLLUP_SECONDS) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!jvmHeapDumpIsSet()) {
        attributes.add("jvmHeapDump");
      }
      if (!footerMessageIsSet()) {
        attributes.add("footerMessage");
      }
      if (!adminPasswordEnabledIsSet()) {
        attributes.add("adminPasswordEnabled");
      }
      if (!readOnlyPasswordEnabledIsSet()) {
        attributes.add("readOnlyPasswordEnabled");
      }
      if (!anonymousAccessIsSet()) {
        attributes.add("anonymousAccess");
      }
      if (!defaultTransactionTypeIsSet()) {
        attributes.add("defaultTransactionType");
      }
      if (!fixedAggregateIntervalSecondsIsSet()) {
        attributes.add("fixedAggregateIntervalSeconds");
      }
      if (!fixedAggregateRollupSecondsIsSet()) {
        attributes.add("fixedAggregateRollupSeconds");
      }
      if (!fixedGaugeIntervalSecondsIsSet()) {
        attributes.add("fixedGaugeIntervalSeconds");
      }
      if (!fixedGaugeRollupSecondsIsSet()) {
        attributes.add("fixedGaugeRollupSeconds");
      }
      return "Cannot build Layout, some of required attributes are not set " + attributes;
    }
  }
}
