package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ErrorJsonService.TabBarDataRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code TabBarDataRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ErrorJsonService.TabBarDataRequestBase"})
@Immutable
final class TabBarDataRequest extends ErrorJsonService.TabBarDataRequestBase {
  private final long from;
  private final long to;
  private final String transactionType;
  private final @Nullable String transactionName;

  private TabBarDataRequest(TabBarDataRequest.Builder builder) {
    this.from = builder.from;
    this.to = builder.to;
    this.transactionType = builder.transactionType;
    this.transactionName = builder.transactionName;
  }

  private TabBarDataRequest(
      TabBarDataRequest original,
      long from,
      long to,
      String transactionType,
      @Nullable String transactionName) {
    this.from = from;
    this.to = to;
    this.transactionType = transactionType;
    this.transactionName = transactionName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code from} attribute
   */
  @JsonProperty("from")
  @Override
  public long from() {
    return from;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code to} attribute
   */
  @JsonProperty("to")
  @Override
  public long to() {
    return to;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionType} attribute
   */
  @JsonProperty("transactionType")
  @Override
  public String transactionType() {
    return transactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionName} attribute
   */
  @Nullable
  @JsonProperty("transactionName")
  @Override
  public String transactionName() {
    return transactionName;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.TabBarDataRequestBase#from() from}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for from
   * @return modified copy of the {@code this} object
   */
  public final TabBarDataRequest withFrom(long value) {
    if (this.from == value) {
      return this;
    }
    long newValue = value;
    return new TabBarDataRequest(this, newValue, this.to, this.transactionType, this.transactionName);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.TabBarDataRequestBase#to() to}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for to
   * @return modified copy of the {@code this} object
   */
  public final TabBarDataRequest withTo(long value) {
    if (this.to == value) {
      return this;
    }
    long newValue = value;
    return new TabBarDataRequest(this, this.from, newValue, this.transactionType, this.transactionName);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.TabBarDataRequestBase#transactionType() transactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionType
   * @return modified copy of the {@code this} object
   */
  public final TabBarDataRequest withTransactionType(String value) {
    if (this.transactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new TabBarDataRequest(this, this.from, this.to, newValue, this.transactionName);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.TabBarDataRequestBase#transactionName() transactionName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TabBarDataRequest withTransactionName(@Nullable String value) {
    if (this.transactionName == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new TabBarDataRequest(this, this.from, this.to, this.transactionType, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code TabBarDataRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof TabBarDataRequest && equalTo((TabBarDataRequest) another));
  }
  
  private boolean equalTo(TabBarDataRequest another) {
    return from == another.from
        && to == another.to
        && transactionType.equals(another.transactionType)
        && Objects.equal(transactionName, another.transactionName);
  }
  
  /**
   * Computes hash code from attributes: {@code from}, {@code to}, {@code transactionType}, {@code transactionName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(from);
    h = h * 17 + Longs.hashCode(to);
    h = h * 17 + transactionType.hashCode();
    h = h * 17 + Objects.hashCode(transactionName);
    return h;
  }
  
  /**
   * Prints immutable value {@code TabBarDataRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TabBarDataRequest")
        .add("from", from)
        .add("to", to)
        .add("transactionType", transactionType)
        .add("transactionName", transactionName)
        .toString();
  }
  
  @JsonCreator
  public static TabBarDataRequest fromAllAttributes(
      @JsonProperty("from") @Nullable Long from,
      @JsonProperty("to") @Nullable Long to,
      @JsonProperty("transactionType") @Nullable String transactionType,
      @JsonProperty("transactionName") @Nullable String transactionName) {
    TabBarDataRequest.Builder builder = TabBarDataRequest.builder();
    if (from != null) {
      builder.from(from);
    }
    if (to != null) {
      builder.to(to);
    }
    if (transactionType != null) {
      builder.transactionType(transactionType);
    }
    if (transactionName != null) {
      builder.transactionName(transactionName);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ErrorJsonService.TabBarDataRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable TabBarDataRequest instance
   */
  static TabBarDataRequest copyOf(ErrorJsonService.TabBarDataRequestBase instance) {
    if (instance instanceof TabBarDataRequest) {
      return (TabBarDataRequest) instance;
    }
    return TabBarDataRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.TabBarDataRequest}.
   * @return new TabBarDataRequest builder
   */
  static TabBarDataRequest.Builder builder() {
    return new TabBarDataRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.TabBarDataRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_FROM = 0x1L;
    private static final long INITIALIZED_BIT_TO = 0x2L;
    private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 0x4L;
    private long initializedBitset;
  
    private long from;
    private long to;
    private @Nullable String transactionType;
    private @Nullable String transactionName;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link ErrorJsonService.TabBarDataRequestBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(ErrorJsonService.TabBarDataRequestBase instance) {
      Preconditions.checkNotNull(instance);
      from(instance.from());
      to(instance.to());
      transactionType(instance.transactionType());
      @Nullable String transactionNameValue = instance.transactionName();
      if (transactionNameValue != null) {
        transactionName(transactionNameValue);
      }
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.TabBarDataRequestBase#from() from}.
     * @param from value for from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(long from) {
      this.from = from;
      initializedBitset |= INITIALIZED_BIT_FROM;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.TabBarDataRequestBase#to() to}.
     * @param to value for to
     * @return {@code this} builder for chained invocation
     */
    public final Builder to(long to) {
      this.to = to;
      initializedBitset |= INITIALIZED_BIT_TO;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.TabBarDataRequestBase#transactionType() transactionType}.
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(String transactionType) {
      this.transactionType = Preconditions.checkNotNull(transactionType);
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.TabBarDataRequestBase#transactionName() transactionName}.
     * @param transactionName value for transactionName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionName(@Nullable String transactionName) {
      this.transactionName = transactionName;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.TabBarDataRequest}.
     * @return immutable instance of TabBarDataRequest
     */
    public org.glowroot.local.ui.TabBarDataRequest build() {
      checkRequiredAttributes();
      return new TabBarDataRequest(this);
    }
  
    private boolean fromIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FROM) != 0;
    }
  
    private boolean toIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TO) != 0;
    }
  
    private boolean transactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_TYPE) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!fromIsSet()) {
        attributes.add("from");
      }
      if (!toIsSet()) {
        attributes.add("to");
      }
      if (!transactionTypeIsSet()) {
        attributes.add("transactionType");
      }
      return "Cannot build TabBarDataRequest, some of required attributes are not set " + attributes;
    }
  }
}
