package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfigJsonService.UserRecordingConfigDtoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code UserRecordingConfigDto.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.UserRecordingConfigDtoBase"})
@Immutable
final class UserRecordingConfigDto
    extends ConfigJsonService.UserRecordingConfigDtoBase {
  private final boolean enabled;
  private final String user;
  private final int profileIntervalMillis;
  private final String version;

  private UserRecordingConfigDto(UserRecordingConfigDto.Builder builder) {
    this.enabled = builder.enabled;
    this.user = builder.user;
    this.profileIntervalMillis = builder.profileIntervalMillis;
    this.version = builder.version;
  }

  private UserRecordingConfigDto(
      UserRecordingConfigDto original,
      boolean enabled,
      String user,
      int profileIntervalMillis,
      String version) {
    this.enabled = enabled;
    this.user = user;
    this.profileIntervalMillis = profileIntervalMillis;
    this.version = version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code enabled} attribute
   */
  @JsonProperty("enabled")
  @Override
  public boolean enabled() {
    return enabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code user} attribute
   */
  @JsonProperty("user")
  @Override
  public String user() {
    return user;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code profileIntervalMillis} attribute
   */
  @JsonProperty("profileIntervalMillis")
  @Override
  public int profileIntervalMillis() {
    return profileIntervalMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserRecordingConfigDtoBase#enabled() enabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for enabled
   * @return modified copy of the {@code this} object
   */
  public final UserRecordingConfigDto withEnabled(boolean value) {
    if (this.enabled == value) {
      return this;
    }
    boolean newValue = value;
    return new UserRecordingConfigDto(this, newValue, this.user, this.profileIntervalMillis, this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserRecordingConfigDtoBase#user() user}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for user
   * @return modified copy of the {@code this} object
   */
  public final UserRecordingConfigDto withUser(String value) {
    if (this.user == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new UserRecordingConfigDto(this, this.enabled, newValue, this.profileIntervalMillis, this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserRecordingConfigDtoBase#profileIntervalMillis() profileIntervalMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for profileIntervalMillis
   * @return modified copy of the {@code this} object
   */
  public final UserRecordingConfigDto withProfileIntervalMillis(int value) {
    if (this.profileIntervalMillis == value) {
      return this;
    }
    int newValue = value;
    return new UserRecordingConfigDto(this, this.enabled, this.user, newValue, this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserRecordingConfigDtoBase#version() version}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version
   * @return modified copy of the {@code this} object
   */
  public final UserRecordingConfigDto withVersion(String value) {
    if (this.version == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new UserRecordingConfigDto(this, this.enabled, this.user, this.profileIntervalMillis, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code UserRecordingConfigDto} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof UserRecordingConfigDto && equalTo((UserRecordingConfigDto) another));
  }
  
  private boolean equalTo(UserRecordingConfigDto another) {
    return enabled == another.enabled
        && user.equals(another.user)
        && profileIntervalMillis == another.profileIntervalMillis
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code enabled}, {@code user}, {@code profileIntervalMillis}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(enabled);
    h = h * 17 + user.hashCode();
    h = h * 17 + profileIntervalMillis;
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code UserRecordingConfigDto{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UserRecordingConfigDto")
        .add("enabled", enabled)
        .add("user", user)
        .add("profileIntervalMillis", profileIntervalMillis)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static UserRecordingConfigDto fromAllAttributes(
      @JsonProperty("enabled") @Nullable Boolean enabled,
      @JsonProperty("user") @Nullable String user,
      @JsonProperty("profileIntervalMillis") @Nullable Integer profileIntervalMillis,
      @JsonProperty("version") @Nullable String version) {
    UserRecordingConfigDto.Builder builder = UserRecordingConfigDto.builder();
    if (enabled != null) {
      builder.enabled(enabled);
    }
    if (user != null) {
      builder.user(user);
    }
    if (profileIntervalMillis != null) {
      builder.profileIntervalMillis(profileIntervalMillis);
    }
    if (version != null) {
      builder.version(version);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.UserRecordingConfigDtoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable UserRecordingConfigDto instance
   */
  static UserRecordingConfigDto copyOf(ConfigJsonService.UserRecordingConfigDtoBase instance) {
    if (instance instanceof UserRecordingConfigDto) {
      return (UserRecordingConfigDto) instance;
    }
    return UserRecordingConfigDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.UserRecordingConfigDto}.
   * @return new UserRecordingConfigDto builder
   */
  static UserRecordingConfigDto.Builder builder() {
    return new UserRecordingConfigDto.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.UserRecordingConfigDto}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xf;
    private static final long INITIALIZED_BIT_ENABLED = 0x1L;
    private static final long INITIALIZED_BIT_USER = 0x2L;
    private static final long INITIALIZED_BIT_PROFILE_INTERVAL_MILLIS = 0x4L;
    private static final long INITIALIZED_BIT_VERSION = 0x8L;
    private long initializedBitset;
  
    private boolean enabled;
    private @Nullable String user;
    private int profileIntervalMillis;
    private @Nullable String version;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link ConfigJsonService.UserRecordingConfigDtoBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(ConfigJsonService.UserRecordingConfigDtoBase instance) {
      Preconditions.checkNotNull(instance);
      enabled(instance.enabled());
      user(instance.user());
      profileIntervalMillis(instance.profileIntervalMillis());
      version(instance.version());
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserRecordingConfigDtoBase#enabled() enabled}.
     * @param enabled value for enabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder enabled(boolean enabled) {
      this.enabled = enabled;
      initializedBitset |= INITIALIZED_BIT_ENABLED;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserRecordingConfigDtoBase#user() user}.
     * @param user value for user
     * @return {@code this} builder for chained invocation
     */
    public final Builder user(String user) {
      this.user = Preconditions.checkNotNull(user);
      initializedBitset |= INITIALIZED_BIT_USER;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserRecordingConfigDtoBase#profileIntervalMillis() profileIntervalMillis}.
     * @param profileIntervalMillis value for profileIntervalMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder profileIntervalMillis(int profileIntervalMillis) {
      this.profileIntervalMillis = profileIntervalMillis;
      initializedBitset |= INITIALIZED_BIT_PROFILE_INTERVAL_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserRecordingConfigDtoBase#version() version}.
     * @param version value for version
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(String version) {
      this.version = Preconditions.checkNotNull(version);
      initializedBitset |= INITIALIZED_BIT_VERSION;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.UserRecordingConfigDto}.
     * @return immutable instance of UserRecordingConfigDto
     */
    public org.glowroot.local.ui.UserRecordingConfigDto build() {
      checkRequiredAttributes();
      return new UserRecordingConfigDto(this);
    }
  
    private boolean enabledIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ENABLED) != 0;
    }
  
    private boolean userIsSet() {
      return (initializedBitset & INITIALIZED_BIT_USER) != 0;
    }
  
    private boolean profileIntervalMillisIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PROFILE_INTERVAL_MILLIS) != 0;
    }
  
    private boolean versionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VERSION) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!enabledIsSet()) {
        attributes.add("enabled");
      }
      if (!userIsSet()) {
        attributes.add("user");
      }
      if (!profileIntervalMillisIsSet()) {
        attributes.add("profileIntervalMillis");
      }
      if (!versionIsSet()) {
        attributes.add("version");
      }
      return "Cannot build UserRecordingConfigDto, some of required attributes are not set " + attributes;
    }
  }
}
