/**
 * Logback: the reliable, generic, fast and flexible logging framework.
 * Copyright (C) 1999-2015, QOS.ch. All rights reserved.
 *
 * This program and the accompanying materials are dual-licensed under
 * either the terms of the Eclipse Public License v1.0 as published by
 * the Eclipse Foundation
 *
 *   or (per the licensee's choosing)
 *
 * under the terms of the GNU Lesser General Public License version 2.1
 * as published by the Free Software Foundation.
 */
package org.glowroot.shaded.qos.logback.classic.turbo;

import org.glowroot.shaded.qos.logback.classic.Level;


/**
 * Bean pairing an MDC value with a log level.
 * 
 * @author Raplh Goers
 * @author Ceki G&uuml;lc&uuml;
 */
public class MDCValueLevelPair {
  private String value;
  private Level level;

  public String getValue() {
    return value;
  }

  public void setValue(String name) {
    this.value = name;
  }

  public Level getLevel() {
    return level;
  }

  public void setLevel(Level level) {
    this.level = level;
  }
}
