package org.glowroot.weaving;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AnalyzedMethodBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code AnalyzedMethod.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AnalyzedMethodBase"})
@Immutable
final class AnalyzedMethod extends AnalyzedMethodBase {
  private final String name;
  private final ImmutableList<String> parameterTypes;
  private final String returnType;
  private final int modifiers;
  private final @Nullable String signature;
  private final ImmutableList<String> exceptions;
  private final ImmutableList<Advice> advisors;

  private AnalyzedMethod(AnalyzedMethod.Builder builder) {
    this.name = builder.name;
    this.parameterTypes = builder.parameterTypesBuilder.build();
    this.returnType = builder.returnType;
    this.modifiers = builder.modifiers;
    this.signature = builder.signature;
    this.exceptions = builder.exceptionsBuilder.build();
    this.advisors = builder.advisorsBuilder.build();
  }

  private AnalyzedMethod(
      AnalyzedMethod original,
      String name,
      ImmutableList<String> parameterTypes,
      String returnType,
      int modifiers,
      @Nullable String signature,
      ImmutableList<String> exceptions,
      ImmutableList<Advice> advisors) {
    this.name = name;
    this.parameterTypes = parameterTypes;
    this.returnType = returnType;
    this.modifiers = modifiers;
    this.signature = signature;
    this.exceptions = exceptions;
    this.advisors = advisors;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code parameterTypes} attribute
   */
  @Override
  public ImmutableList<String> parameterTypes() {
    return parameterTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code returnType} attribute
   */
  @Override
  public String returnType() {
    return returnType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code modifiers} attribute
   */
  @Override
  public int modifiers() {
    return modifiers;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code signature} attribute
   */
  @Nullable
  @Override
  public String signature() {
    return signature;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code exceptions} attribute
   */
  @Override
  public ImmutableList<String> exceptions() {
    return exceptions;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code advisors} attribute
   */
  @Override
  public ImmutableList<Advice> advisors() {
    return advisors;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AnalyzedMethodBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final AnalyzedMethod withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new AnalyzedMethod(
        this,
        newValue,
        this.parameterTypes,
        this.returnType,
        this.modifiers,
        this.signature,
        this.exceptions,
        this.advisors);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedMethodBase#parameterTypes() parameterTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedMethod withParameterTypes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedMethod(
        this,
        this.name,
        newValue,
        this.returnType,
        this.modifiers,
        this.signature,
        this.exceptions,
        this.advisors);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedMethodBase#parameterTypes() parameterTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of parameterTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedMethod withParameterTypes(Iterable<String> elements) {
    if (this.parameterTypes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedMethod(
        this,
        this.name,
        newValue,
        this.returnType,
        this.modifiers,
        this.signature,
        this.exceptions,
        this.advisors);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AnalyzedMethodBase#returnType() returnType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for returnType
   * @return modified copy of the {@code this} object
   */
  public final AnalyzedMethod withReturnType(String value) {
    if (this.returnType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new AnalyzedMethod(
        this,
        this.name,
        this.parameterTypes,
        newValue,
        this.modifiers,
        this.signature,
        this.exceptions,
        this.advisors);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AnalyzedMethodBase#modifiers() modifiers}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for modifiers
   * @return modified copy of the {@code this} object
   */
  public final AnalyzedMethod withModifiers(int value) {
    if (this.modifiers == value) {
      return this;
    }
    int newValue = value;
    return new AnalyzedMethod(
        this,
        this.name,
        this.parameterTypes,
        this.returnType,
        newValue,
        this.signature,
        this.exceptions,
        this.advisors);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AnalyzedMethodBase#signature() signature}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for signature, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final AnalyzedMethod withSignature(@Nullable String value) {
    if (this.signature == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new AnalyzedMethod(
        this,
        this.name,
        this.parameterTypes,
        this.returnType,
        this.modifiers,
        newValue,
        this.exceptions,
        this.advisors);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedMethodBase#exceptions() exceptions}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedMethod withExceptions(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedMethod(
        this,
        this.name,
        this.parameterTypes,
        this.returnType,
        this.modifiers,
        this.signature,
        newValue,
        this.advisors);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedMethodBase#exceptions() exceptions}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of exceptions elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedMethod withExceptions(Iterable<String> elements) {
    if (this.exceptions == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedMethod(
        this,
        this.name,
        this.parameterTypes,
        this.returnType,
        this.modifiers,
        this.signature,
        newValue,
        this.advisors);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedMethodBase#advisors() advisors}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedMethod withAdvisors(Advice... elements) {
    ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedMethod(
        this,
        this.name,
        this.parameterTypes,
        this.returnType,
        this.modifiers,
        this.signature,
        this.exceptions,
        newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedMethodBase#advisors() advisors}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of advisors elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedMethod withAdvisors(Iterable<? extends Advice> elements) {
    if (this.advisors == elements) {
      return this;
    }
    ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedMethod(
        this,
        this.name,
        this.parameterTypes,
        this.returnType,
        this.modifiers,
        this.signature,
        this.exceptions,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code AnalyzedMethod} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof AnalyzedMethod && equalTo((AnalyzedMethod) another));
  }
  
  private boolean equalTo(AnalyzedMethod another) {
    return name.equals(another.name)
        && parameterTypes.equals(another.parameterTypes)
        && returnType.equals(another.returnType)
        && modifiers == another.modifiers
        && Objects.equal(signature, another.signature)
        && exceptions.equals(another.exceptions)
        && advisors.equals(another.advisors);
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code parameterTypes}, {@code returnType}, {@code modifiers}, {@code signature}, {@code exceptions}, {@code advisors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + parameterTypes.hashCode();
    h = h * 17 + returnType.hashCode();
    h = h * 17 + modifiers;
    h = h * 17 + Objects.hashCode(signature);
    h = h * 17 + exceptions.hashCode();
    h = h * 17 + advisors.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code AnalyzedMethod{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AnalyzedMethod")
        .add("name", name)
        .add("parameterTypes", parameterTypes)
        .add("returnType", returnType)
        .add("modifiers", modifiers)
        .add("signature", signature)
        .add("exceptions", exceptions)
        .add("advisors", advisors)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link AnalyzedMethodBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable AnalyzedMethod instance
   */
  static AnalyzedMethod copyOf(AnalyzedMethodBase instance) {
    if (instance instanceof AnalyzedMethod) {
      return (AnalyzedMethod) instance;
    }
    return AnalyzedMethod.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.weaving.AnalyzedMethod}.
   * @return new AnalyzedMethod builder
   */
  static AnalyzedMethod.Builder builder() {
    return new AnalyzedMethod.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.weaving.AnalyzedMethod}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_RETURN_TYPE = 0x2L;
    private static final long INITIALIZED_BIT_MODIFIERS = 0x4L;
    private long initializedBitset;
  
    private @Nullable String name;
    private ImmutableList.Builder<String> parameterTypesBuilder = ImmutableList.builder();
    private @Nullable String returnType;
    private int modifiers;
    private @Nullable String signature;
    private ImmutableList.Builder<String> exceptionsBuilder = ImmutableList.builder();
    private ImmutableList.Builder<Advice> advisorsBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link AnalyzedMethodBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(AnalyzedMethodBase instance) {
      Preconditions.checkNotNull(instance);
      name(instance.name());
      addAllParameterTypes(instance.parameterTypes());
      returnType(instance.returnType());
      modifiers(instance.modifiers());
      @Nullable String signatureValue = instance.signature();
      if (signatureValue != null) {
        signature(signatureValue);
      }
      addAllExceptions(instance.exceptions());
      addAllAdvisors(instance.advisors());
      return this;
    }
  
    /**
     * Initializes value for {@link AnalyzedMethodBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Adds one element to {@link AnalyzedMethodBase#parameterTypes() parameterTypes} list.
     * @param element parameterTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addParameterTypes(String element) {
      parameterTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AnalyzedMethodBase#parameterTypes() parameterTypes} list.
     * @param elements array of parameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addParameterTypes(String... elements) {
      parameterTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link AnalyzedMethodBase#parameterTypes() parameterTypes} list.
     * @param elements iterable of parameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder parameterTypes(Iterable<String> elements) {
      parameterTypesBuilder = ImmutableList.builder();
      return addAllParameterTypes(elements);
    }
  
    /**
     * Adds elements to {@link AnalyzedMethodBase#parameterTypes() parameterTypes} list.
     * @param elements iterable of parameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllParameterTypes(Iterable<String> elements) {
      parameterTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link AnalyzedMethodBase#returnType() returnType}.
     * @param returnType value for returnType
     * @return {@code this} builder for chained invocation
     */
    public final Builder returnType(String returnType) {
      this.returnType = Preconditions.checkNotNull(returnType);
      initializedBitset |= INITIALIZED_BIT_RETURN_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link AnalyzedMethodBase#modifiers() modifiers}.
     * @param modifiers value for modifiers
     * @return {@code this} builder for chained invocation
     */
    public final Builder modifiers(int modifiers) {
      this.modifiers = modifiers;
      initializedBitset |= INITIALIZED_BIT_MODIFIERS;
      return this;
    }
  
    /**
     * Initializes value for {@link AnalyzedMethodBase#signature() signature}.
     * @param signature value for signature, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder signature(@Nullable String signature) {
      this.signature = signature;
      return this;
    }
  
    /**
     * Adds one element to {@link AnalyzedMethodBase#exceptions() exceptions} list.
     * @param element exceptions element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addExceptions(String element) {
      exceptionsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AnalyzedMethodBase#exceptions() exceptions} list.
     * @param elements array of exceptions elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addExceptions(String... elements) {
      exceptionsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link AnalyzedMethodBase#exceptions() exceptions} list.
     * @param elements iterable of exceptions elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder exceptions(Iterable<String> elements) {
      exceptionsBuilder = ImmutableList.builder();
      return addAllExceptions(elements);
    }
  
    /**
     * Adds elements to {@link AnalyzedMethodBase#exceptions() exceptions} list.
     * @param elements iterable of exceptions elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllExceptions(Iterable<String> elements) {
      exceptionsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link AnalyzedMethodBase#advisors() advisors} list.
     * @param element advisors element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAdvisors(Advice element) {
      advisorsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AnalyzedMethodBase#advisors() advisors} list.
     * @param elements array of advisors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAdvisors(Advice... elements) {
      advisorsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link AnalyzedMethodBase#advisors() advisors} list.
     * @param elements iterable of advisors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder advisors(Iterable<? extends Advice> elements) {
      advisorsBuilder = ImmutableList.builder();
      return addAllAdvisors(elements);
    }
  
    /**
     * Adds elements to {@link AnalyzedMethodBase#advisors() advisors} list.
     * @param elements iterable of advisors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllAdvisors(Iterable<? extends Advice> elements) {
      advisorsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.weaving.AnalyzedMethod}.
     * @return immutable instance of AnalyzedMethod
     */
    public org.glowroot.weaving.AnalyzedMethod build() {
      checkRequiredAttributes();
      return new AnalyzedMethod(this);
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean returnTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_RETURN_TYPE) != 0;
    }
  
    private boolean modifiersIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MODIFIERS) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!returnTypeIsSet()) {
        attributes.add("returnType");
      }
      if (!modifiersIsSet()) {
        attributes.add("modifiers");
      }
      return "Cannot build AnalyzedMethod, some of required attributes are not set " + attributes;
    }
  }
}
