package org.glowroot.weaving;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.objectweb.asm.Type;

/**
 * Immutable implementation of {@link ShimTypeBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ShimType.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ShimTypeBase"})
@Immutable
public final class ShimType extends ShimTypeBase {
  private final Type iface;
  private final String target;
  private final ImmutableList<Method> shimMethods;

  private ShimType(ShimType.Builder builder) {
    this.iface = builder.iface;
    this.target = builder.target;
    this.shimMethods = builder.shimMethodsBuilder.build();
  }

  private ShimType(
      ShimType original,
      Type iface,
      String target,
      ImmutableList<Method> shimMethods) {
    this.iface = iface;
    this.target = target;
    this.shimMethods = shimMethods;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code iface} attribute
   */
  @Override
  public Type iface() {
    return iface;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code target} attribute
   */
  @Override
  public String target() {
    return target;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code shimMethods} attribute
   */
  @Override
  public ImmutableList<Method> shimMethods() {
    return shimMethods;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ShimTypeBase#iface() iface}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for iface
   * @return modified copy of the {@code this} object
   */
  public final ShimType withIface(Type value) {
    if (this.iface == value) {
      return this;
    }
    Type newValue = Preconditions.checkNotNull(value);
    return new ShimType(this, newValue, this.target, this.shimMethods);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ShimTypeBase#target() target}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for target
   * @return modified copy of the {@code this} object
   */
  public final ShimType withTarget(String value) {
    if (this.target == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ShimType(this, this.iface, newValue, this.shimMethods);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ShimTypeBase#shimMethods() shimMethods}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ShimType withShimMethods(Method... elements) {
    ImmutableList<Method> newValue = ImmutableList.copyOf(elements);
    return new ShimType(this, this.iface, this.target, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ShimTypeBase#shimMethods() shimMethods}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of shimMethods elements to set
   * @return modified copy of {@code this} object
   */
  public final ShimType withShimMethods(Iterable<? extends Method> elements) {
    if (this.shimMethods == elements) {
      return this;
    }
    ImmutableList<Method> newValue = ImmutableList.copyOf(elements);
    return new ShimType(this, this.iface, this.target, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ShimType} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ShimType && equalTo((ShimType) another));
  }
  
  private boolean equalTo(ShimType another) {
    return iface.equals(another.iface)
        && target.equals(another.target)
        && shimMethods.equals(another.shimMethods);
  }
  
  /**
   * Computes hash code from attributes: {@code iface}, {@code target}, {@code shimMethods}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + iface.hashCode();
    h = h * 17 + target.hashCode();
    h = h * 17 + shimMethods.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code ShimType{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ShimType")
        .add("iface", iface)
        .add("target", target)
        .add("shimMethods", shimMethods)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link ShimTypeBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable ShimType instance
   */
  public static ShimType copyOf(ShimTypeBase instance) {
    if (instance instanceof ShimType) {
      return (ShimType) instance;
    }
    return ShimType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.weaving.ShimType}.
   * @return new ShimType builder
   */
  public static ShimType.Builder builder() {
    return new ShimType.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.weaving.ShimType}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_IFACE = 0x1L;
    private static final long INITIALIZED_BIT_TARGET = 0x2L;
    private long initializedBitset;
  
    private @Nullable Type iface;
    private @Nullable String target;
    private ImmutableList.Builder<Method> shimMethodsBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link ShimTypeBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(ShimTypeBase instance) {
      Preconditions.checkNotNull(instance);
      iface(instance.iface());
      target(instance.target());
      addAllShimMethods(instance.shimMethods());
      return this;
    }
  
    /**
     * Initializes value for {@link ShimTypeBase#iface() iface}.
     * @param iface value for iface
     * @return {@code this} builder for chained invocation
     */
    public final Builder iface(Type iface) {
      this.iface = Preconditions.checkNotNull(iface);
      initializedBitset |= INITIALIZED_BIT_IFACE;
      return this;
    }
  
    /**
     * Initializes value for {@link ShimTypeBase#target() target}.
     * @param target value for target
     * @return {@code this} builder for chained invocation
     */
    public final Builder target(String target) {
      this.target = Preconditions.checkNotNull(target);
      initializedBitset |= INITIALIZED_BIT_TARGET;
      return this;
    }
  
    /**
     * Adds one element to {@link ShimTypeBase#shimMethods() shimMethods} list.
     * @param element shimMethods element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addShimMethods(Method element) {
      shimMethodsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ShimTypeBase#shimMethods() shimMethods} list.
     * @param elements array of shimMethods elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addShimMethods(Method... elements) {
      shimMethodsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link ShimTypeBase#shimMethods() shimMethods} list.
     * @param elements iterable of shimMethods elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder shimMethods(Iterable<? extends Method> elements) {
      shimMethodsBuilder = ImmutableList.builder();
      return addAllShimMethods(elements);
    }
  
    /**
     * Adds elements to {@link ShimTypeBase#shimMethods() shimMethods} list.
     * @param elements iterable of shimMethods elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllShimMethods(Iterable<? extends Method> elements) {
      shimMethodsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.weaving.ShimType}.
     * @return immutable instance of ShimType
     */
    public ShimType build() {
      checkRequiredAttributes();
      return new ShimType(this);
    }
  
    private boolean ifaceIsSet() {
      return (initializedBitset & INITIALIZED_BIT_IFACE) != 0;
    }
  
    private boolean targetIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TARGET) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!ifaceIsSet()) {
        attributes.add("iface");
      }
      if (!targetIsSet()) {
        attributes.add("target");
      }
      return "Cannot build ShimType, some of required attributes are not set " + attributes;
    }
  }
}
