/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;

public class Agent {
    private Agent() {
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        try {
            Class<?> mainEntryPointClass;
            CodeSource codeSource = Agent.class.getProtectionDomain().getCodeSource();
            File glowrootJarFile = Agent.getGlowrootJarFile(codeSource);
            if (glowrootJarFile == null) {
                mainEntryPointClass = Class.forName("org.glowroot.MainEntryPoint", true, Agent.class.getClassLoader());
            } else {
                instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(glowrootJarFile));
                mainEntryPointClass = Class.forName("org.glowroot.MainEntryPoint", true, null);
            }
            Method premainMethod = mainEntryPointClass.getMethod("premain", Instrumentation.class, File.class);
            premainMethod.invoke(null, instrumentation, glowrootJarFile);
        }
        catch (Throwable t) {
            System.err.println("Glowroot not started: " + t.getMessage());
            t.printStackTrace();
        }
    }

    @VisibleForTesting
    static File getGlowrootJarFile(@Nullable CodeSource codeSource) throws Exception {
        if (codeSource == null) {
            if (System.getProperty("delegateJavaagent") != null) {
                return null;
            }
            throw new IOException("Could not determine glowroot jar location");
        }
        File codeSourceFile = new File(codeSource.getLocation().toURI());
        if (codeSourceFile.getName().endsWith(".jar")) {
            return codeSourceFile;
        }
        if (System.getProperty("delegateJavaagent") != null) {
            return null;
        }
        throw new IOException("Could not determine glowroot jar location");
    }
}

