/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot;

import java.io.File;
import java.net.URISyntaxException;
import java.security.CodeSource;
import javax.annotation.Nullable;
import org.glowroot.MainEntryPoint;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;

public class Viewer {
    private Viewer() {
    }

    public static void main(String ... args) throws Exception {
        CodeSource codeSource = Viewer.class.getProtectionDomain().getCodeSource();
        MainEntryPoint.runViewer(Viewer.getGlowrootJarFile(codeSource));
    }

    @Nullable
    @VisibleForTesting
    static File getGlowrootJarFile(@Nullable CodeSource codeSource) throws URISyntaxException {
        if (codeSource == null) {
            return null;
        }
        File codeSourceFile = new File(codeSource.getLocation().toURI());
        if (codeSourceFile.getName().endsWith(".jar")) {
            return codeSourceFile;
        }
        return null;
    }
}

