/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.advicegen;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.glowroot.advicegen.PathEvaluator;
import org.glowroot.markers.UsedByGeneratedBytecode;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

@UsedByGeneratedBytecode
public class MessageTemplate {
    private static final Logger logger = LoggerFactory.getLogger(MessageTemplate.class);
    private static final Pattern pattern = Pattern.compile("\\{\\{([^}]*)}}");
    private final ImmutableList<Part> allParts;
    private final ImmutableList<ValuePathPart> thisPathParts;
    private final ImmutableList<ArgPathPart> argPathParts;
    private final ImmutableList<ValuePathPart> returnPathParts;

    @UsedByGeneratedBytecode
    public static MessageTemplate create(String template, Class<?> declaringClass, Class<?> returnType, Class<?>[] parameterTypes) {
        ArrayList<Part> allParts = Lists.newArrayList();
        ArrayList<ValuePathPart> thisPathParts = Lists.newArrayList();
        ArrayList<ArgPathPart> argPathParts = Lists.newArrayList();
        ArrayList<ValuePathPart> returnPathParts = Lists.newArrayList();
        Matcher matcher = pattern.matcher(template);
        int curr = 0;
        while (matcher.find()) {
            ValuePathPart part;
            String remaining;
            String base;
            if (matcher.start() > curr) {
                allParts.add(new ConstantPart(template.substring(curr, matcher.start())));
            }
            String group = matcher.group(1);
            Preconditions.checkNotNull(group);
            String path = group.trim();
            int index = path.indexOf(46);
            if (index == -1) {
                base = path;
                remaining = "";
            } else {
                base = path.substring(0, index);
                remaining = path.substring(index + 1);
            }
            if (base.equals("this")) {
                part = new ValuePathPart(PartType.THIS_PATH, declaringClass, remaining);
                allParts.add(part);
                thisPathParts.add(part);
            } else if (base.matches("[0-9]+")) {
                int argNumber = Integer.parseInt(base);
                if (argNumber < parameterTypes.length) {
                    ArgPathPart part2 = new ArgPathPart(parameterTypes[argNumber], remaining, argNumber);
                    allParts.add(part2);
                    argPathParts.add(part2);
                } else {
                    allParts.add(new ConstantPart("<requested arg index out of bounds: " + argNumber + ">"));
                }
            } else if (base.equals("_")) {
                part = new ValuePathPart(PartType.RETURN_PATH, returnType, remaining);
                allParts.add(part);
                returnPathParts.add(part);
            } else if (base.equals("methodName")) {
                allParts.add(new Part(PartType.METHOD_NAME));
            } else {
                logger.warn("invalid template substitution: {}", (Object)path);
                allParts.add(new ConstantPart("{{" + path + "}}"));
            }
            curr = matcher.end();
        }
        if (curr < template.length()) {
            allParts.add(new ConstantPart(template.substring(curr)));
        }
        return new MessageTemplate(allParts, thisPathParts, argPathParts, returnPathParts);
    }

    private MessageTemplate(List<Part> allParts, List<ValuePathPart> thisPathParts, List<ArgPathPart> argPathParts, List<ValuePathPart> returnPathParts) {
        this.allParts = ImmutableList.copyOf(allParts);
        this.thisPathParts = ImmutableList.copyOf(thisPathParts);
        this.argPathParts = ImmutableList.copyOf(argPathParts);
        this.returnPathParts = ImmutableList.copyOf(returnPathParts);
    }

    ImmutableList<Part> getAllParts() {
        return this.allParts;
    }

    ImmutableList<ValuePathPart> getThisPathParts() {
        return this.thisPathParts;
    }

    ImmutableList<ArgPathPart> getArgPathParts() {
        return this.argPathParts;
    }

    ImmutableList<ValuePathPart> getReturnPathParts() {
        return this.returnPathParts;
    }

    static class ArgPathPart
    extends ValuePathPart {
        private final int argNumber;

        private ArgPathPart(Class<?> argClass, String propertyPath, int argNumber) {
            super(PartType.ARG_PATH, argClass, propertyPath);
            this.argNumber = argNumber;
        }

        int getArgNumber() {
            return this.argNumber;
        }
    }

    static class ValuePathPart
    extends Part {
        private final PathEvaluator pathEvaluator;

        private ValuePathPart(PartType partType, Class<?> valueClass, String propertyPath) {
            super(partType);
            this.pathEvaluator = new PathEvaluator(valueClass, propertyPath);
        }

        String evaluatePart(@Nullable Object base) {
            if (base == null) {
                return "null";
            }
            try {
                return this.valueOf(this.pathEvaluator.evaluateOnBase(base));
            }
            catch (InvocationTargetException e) {
                logger.debug(e.getMessage(), e);
                Throwable t = MoreObjects.firstNonNull(e.getCause(), e);
                return "<error evaluating: " + t.toString() + ">";
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
                return "<error evaluating: " + e.toString() + ">";
            }
        }

        private String valueOf(@Nullable Object value) {
            if (value == null || !value.getClass().isArray()) {
                return String.valueOf(value);
            }
            StringBuilder sb = new StringBuilder();
            ValuePathPart.valueOfArray(value, sb);
            return sb.toString();
        }

        private static void valueOfArray(Object array, StringBuilder sb) {
            sb.append('[');
            int len = Array.getLength(array);
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                ValuePathPart.valueOf(Array.get(array, i), sb);
            }
            sb.append(']');
        }

        private static void valueOf(Object object, StringBuilder sb) {
            if (object.getClass().isArray()) {
                ValuePathPart.valueOfArray(object, sb);
            } else {
                sb.append(String.valueOf(object));
            }
        }
    }

    static class ConstantPart
    extends Part {
        private final String constant;

        private ConstantPart(String constant) {
            super(PartType.CONSTANT);
            this.constant = constant;
        }

        String getConstant() {
            return this.constant;
        }
    }

    static class Part {
        private final PartType type;

        private Part(PartType type) {
            this.type = type;
        }

        PartType getType() {
            return this.type;
        }
    }

    static enum PartType {
        CONSTANT,
        THIS_PATH,
        ARG_PATH,
        RETURN_PATH,
        METHOD_NAME;

    }
}

