/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.api;

import javax.annotation.Nullable;
import org.glowroot.api.internal.ReadableErrorMessage;
import org.glowroot.api.internal.ThrowableInfo;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public abstract class ErrorMessage {
    private static final Logger logger = LoggerFactory.getLogger(ErrorMessage.class);

    public static ErrorMessage from(Throwable t) {
        if (t == null) {
            logger.warn("from(): argument 't' must be non-null");
            return ErrorMessage.from((String)null);
        }
        return new ErrorMessageImpl(ErrorMessage.getRootCause(t).toString(), ThrowableInfo.from(t));
    }

    public static ErrorMessage from(@Nullable String message, @Nullable Throwable t) {
        if (t == null) {
            return ErrorMessage.from(message);
        }
        return new ErrorMessageImpl(message, ThrowableInfo.from(t));
    }

    public static ErrorMessage from(@Nullable String message) {
        return new ErrorMessageImpl(message, null);
    }

    private ErrorMessage() {
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable root = t;
        Throwable cause = root.getCause();
        while (cause != null) {
            root = cause;
            cause = root.getCause();
        }
        return root;
    }

    private static class ErrorMessageImpl
    extends ErrorMessage
    implements ReadableErrorMessage {
        @Nullable
        private final String message;
        @Nullable
        private final ThrowableInfo throwableInfo;

        private ErrorMessageImpl(@Nullable String text, @Nullable ThrowableInfo throwableInfo) {
            this.message = text;
            this.throwableInfo = throwableInfo;
        }

        @Override
        public String getMessage() {
            return Strings.nullToEmpty(this.message);
        }

        @Override
        @Nullable
        public ThrowableInfo getThrowable() {
            return this.throwableInfo;
        }
    }
}

