/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.common.ObjectMappers;
import org.glowroot.markers.UsedByJsonBinding;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.transaction.model.TimerImpl;

@UsedByJsonBinding
public class AggregateTimer {
    @Nullable
    private final String name;
    private final boolean extended;
    private long totalMicros;
    private long count;
    private final List<AggregateTimer> nestedTimers;

    public static AggregateTimer createSyntheticRootTimer() {
        return new AggregateTimer(null, false, 0L, 0L, new ArrayList<AggregateTimer>());
    }

    private AggregateTimer(@Nullable String name, boolean extended, long totalMicros, long count, List<AggregateTimer> nestedTimers) {
        this.name = name;
        this.extended = extended;
        this.totalMicros = totalMicros;
        this.count = count;
        this.nestedTimers = Lists.newArrayList(nestedTimers);
    }

    public void mergeMatchedTimer(AggregateTimer aggregateTimer) {
        this.count += aggregateTimer.getCount();
        this.totalMicros += aggregateTimer.getTotalMicros();
        for (AggregateTimer toBeMergedNestedTimer : aggregateTimer.getNestedTimers()) {
            AggregateTimer foundMatchingNestedTimer = null;
            for (AggregateTimer nestedTimer : this.nestedTimers) {
                String nestedTimerName;
                String toBeMergedNestedTimerName = Preconditions.checkNotNull(toBeMergedNestedTimer.getName());
                if (!toBeMergedNestedTimerName.equals(nestedTimerName = Preconditions.checkNotNull(nestedTimer.getName())) || toBeMergedNestedTimer.isExtended() != nestedTimer.isExtended()) continue;
                foundMatchingNestedTimer = nestedTimer;
                break;
            }
            if (foundMatchingNestedTimer == null) {
                this.nestedTimers.add(toBeMergedNestedTimer);
                continue;
            }
            foundMatchingNestedTimer.mergeMatchedTimer(toBeMergedNestedTimer);
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public long getTotalMicros() {
        return this.totalMicros;
    }

    public long getCount() {
        return this.count;
    }

    public List<AggregateTimer> getNestedTimers() {
        return this.nestedTimers;
    }

    void mergeAsChildTimer(TimerImpl timer) {
        String timerName = timer.getName();
        boolean extended = timer.isExtended();
        AggregateTimer matchingAggregateTimer = null;
        for (AggregateTimer aggregateTimer : this.nestedTimers) {
            String nestedTimerName = Preconditions.checkNotNull(aggregateTimer.getName());
            if (!timerName.equals(nestedTimerName) || extended != aggregateTimer.isExtended()) continue;
            matchingAggregateTimer = aggregateTimer;
            break;
        }
        if (matchingAggregateTimer == null) {
            matchingAggregateTimer = new AggregateTimer(timerName, timer.isExtended(), 0L, 0L, new ArrayList<AggregateTimer>());
            this.nestedTimers.add(matchingAggregateTimer);
        }
        if (this.name == null) {
            this.totalMicros += TimeUnit.NANOSECONDS.toMicros(timer.getTotal());
            this.count += timer.getCount();
        }
        matchingAggregateTimer.totalMicros += TimeUnit.NANOSECONDS.toMicros(timer.getTotal());
        matchingAggregateTimer.count += timer.getCount();
        for (TimerImpl timerImpl : timer.getNestedTimers()) {
            matchingAggregateTimer.mergeAsChildTimer(timerImpl);
        }
    }

    @JsonCreator
    static AggregateTimer readValue(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="extended") @Nullable Boolean extended, @JsonProperty(value="totalMicros") @Nullable Long totalMicros, @JsonProperty(value="count") @Nullable Long count, @JsonProperty(value="nestedTimers") @Nullable List<AggregateTimer> uncheckedNestedTimers) throws JsonMappingException {
        List<AggregateTimer> nestedTimers = ObjectMappers.orEmpty(uncheckedNestedTimers, "nestedTimers");
        ObjectMappers.checkRequiredProperty(totalMicros, "totalMicros");
        ObjectMappers.checkRequiredProperty(count, "count");
        return new AggregateTimer(name, AggregateTimer.orFalse(extended), totalMicros, count, nestedTimers);
    }

    private static boolean orFalse(@Nullable Boolean value) {
        return value != null && value != false;
    }
}

