/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.GaugePointBase;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class GaugePoint
extends GaugePointBase {
    private final String gaugeName;
    @Nullable
    private final Boolean everIncreasing;
    private final long captureTime;
    private final double value;

    private GaugePoint(Builder builder) {
        this.gaugeName = builder.gaugeName;
        this.everIncreasing = builder.everIncreasing;
        this.captureTime = builder.captureTime;
        this.value = builder.value;
    }

    private GaugePoint(GaugePoint original, String gaugeName, @Nullable Boolean everIncreasing, long captureTime, double value) {
        this.gaugeName = gaugeName;
        this.everIncreasing = everIncreasing;
        this.captureTime = captureTime;
        this.value = value;
    }

    @Override
    public String gaugeName() {
        return this.gaugeName;
    }

    @Override
    @Nullable
    public Boolean everIncreasing() {
        return this.everIncreasing;
    }

    @Override
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    public double value() {
        return this.value;
    }

    public final GaugePoint withGaugeName(String value) {
        if (this.gaugeName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new GaugePoint(this, newValue, this.everIncreasing, this.captureTime, this.value);
    }

    public final GaugePoint withEverIncreasing(@Nullable Boolean value) {
        if (this.everIncreasing == value) {
            return this;
        }
        Boolean newValue = value;
        return new GaugePoint(this, this.gaugeName, newValue, this.captureTime, this.value);
    }

    public final GaugePoint withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        long newValue = value;
        return new GaugePoint(this, this.gaugeName, this.everIncreasing, newValue, this.value);
    }

    public final GaugePoint withValue(double value) {
        double newValue = value;
        return new GaugePoint(this, this.gaugeName, this.everIncreasing, this.captureTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GaugePoint && this.equalTo((GaugePoint)another);
    }

    private boolean equalTo(GaugePoint another) {
        return this.gaugeName.equals(another.gaugeName) && Objects.equal(this.everIncreasing, another.everIncreasing) && this.captureTime == another.captureTime && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(another.value);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.gaugeName.hashCode();
        h = h * 17 + Objects.hashCode(this.everIncreasing);
        h = h * 17 + Longs.hashCode(this.captureTime);
        h = h * 17 + Doubles.hashCode(this.value);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GaugePoint").add("gaugeName", this.gaugeName).add("everIncreasing", this.everIncreasing).add("captureTime", this.captureTime).add("value", this.value).toString();
    }

    public static GaugePoint copyOf(GaugePointBase instance) {
        if (instance instanceof GaugePoint) {
            return (GaugePoint)instance;
        }
        return GaugePoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_GAUGE_NAME = 1L;
        private static final long INITIALIZED_BIT_CAPTURE_TIME = 2L;
        private static final long INITIALIZED_BIT_VALUE = 4L;
        private long initializedBitset;
        @Nullable
        private String gaugeName;
        @Nullable
        private Boolean everIncreasing;
        private long captureTime;
        private double value;

        private Builder() {
        }

        public final Builder from(GaugePointBase instance) {
            Preconditions.checkNotNull(instance);
            this.gaugeName(instance.gaugeName());
            Boolean everIncreasingValue = instance.everIncreasing();
            if (everIncreasingValue != null) {
                this.everIncreasing(everIncreasingValue);
            }
            this.captureTime(instance.captureTime());
            this.value(instance.value());
            return this;
        }

        public final Builder gaugeName(String gaugeName) {
            this.gaugeName = Preconditions.checkNotNull(gaugeName);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder everIncreasing(@Nullable Boolean everIncreasing) {
            this.everIncreasing = everIncreasing;
            return this;
        }

        public final Builder captureTime(long captureTime) {
            this.captureTime = captureTime;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder value(double value) {
            this.value = value;
            this.initializedBitset |= 4L;
            return this;
        }

        public GaugePoint build() {
            this.checkRequiredAttributes();
            return new GaugePoint(this);
        }

        private boolean gaugeNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean captureTimeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean valueIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.gaugeNameIsSet()) {
                attributes.add("gaugeName");
            }
            if (!this.captureTimeIsSet()) {
                attributes.add("captureTime");
            }
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            return "Cannot build GaugePoint, some of required attributes are not set " + attributes;
        }
    }
}

