/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.shaded.HdrHistogram.Histogram;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class LazyHistogram {
    private static final Logger logger = LoggerFactory.getLogger(LazyHistogram.class);
    private static final int HISTOGRAM_SIGNIFICANT_DIGITS = 2;
    private static final int MAX_VALUES = 1024;
    @Nullable
    private static final Field hdrHistogramInternalField;
    private long[] values = new long[8];
    private int size;
    private boolean sorted;
    @MonotonicNonNull
    private Histogram histogram;

    public void decodeFromByteBuffer(ByteBuffer buffer) throws DataFormatException {
        if (buffer.getInt() == 0) {
            int numNewValues = buffer.getInt();
            this.ensureCapacity(this.size + numNewValues);
            if (this.histogram == null) {
                boolean bl = this.sorted = this.size == 0;
                while (buffer.remaining() > 0) {
                    this.values[this.size++] = buffer.getLong();
                }
            } else {
                while (buffer.remaining() > 0) {
                    this.histogram.recordValue(buffer.getLong());
                }
            }
        } else {
            if (this.histogram == null) {
                this.convertValuesToHistogram();
            }
            this.histogram.add(Histogram.decodeFromCompressedByteBuffer(buffer, 0L));
        }
    }

    public long getValueAtPercentile(double percentile) {
        if (this.histogram == null) {
            if (this.size == 0) {
                return 0L;
            }
            if (!this.sorted) {
                this.sortValues();
            }
            return this.values[(int)Math.ceil((double)this.size * percentile / 100.0) - 1];
        }
        return this.histogram.getValueAtPercentile(percentile);
    }

    public int getNeededByteBufferCapacity() {
        if (this.histogram == null) {
            return 8 + this.size * 8;
        }
        return 4 + this.histogram.getNeededByteBufferCapacity();
    }

    public byte[] encodeUsingTempByteBuffer(ByteBuffer tempBuffer) {
        if (this.histogram == null) {
            tempBuffer.putInt(0);
            tempBuffer.putInt(this.size);
            if (!this.sorted) {
                this.sortValues();
            }
            for (int i = 0; i < this.size; ++i) {
                tempBuffer.putLong(this.values[i]);
            }
        } else {
            tempBuffer.putInt(1);
            if (hdrHistogramInternalField != null) {
                try {
                    hdrHistogramInternalField.set(this.histogram, null);
                }
                catch (IllegalArgumentException e) {
                    logger.error(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            this.histogram.encodeIntoCompressedByteBuffer(tempBuffer);
        }
        int size = tempBuffer.position();
        tempBuffer.flip();
        byte[] histogramBytes = new byte[size];
        tempBuffer.get(histogramBytes, 0, size);
        return histogramBytes;
    }

    @VisibleForTesting
    public void add(long value) {
        this.ensureCapacity(this.size + 1);
        if (this.histogram != null) {
            this.histogram.recordValue(value);
        } else {
            this.values[this.size++] = value;
            this.sorted = false;
        }
    }

    private void ensureCapacity(int capacity) {
        if (this.histogram != null) {
            return;
        }
        if (capacity > 1024) {
            this.convertValuesToHistogram();
            return;
        }
        if (capacity > this.values.length) {
            long[] temp = new long[Math.max(this.size * 2, capacity)];
            System.arraycopy(this.values, 0, temp, 0, this.size);
            this.values = temp;
        }
    }

    @EnsuresNonNull(value={"histogram"})
    private void convertValuesToHistogram() {
        this.histogram = new Histogram(2);
        for (int i = 0; i < this.size; ++i) {
            this.histogram.recordValue(this.values[i]);
        }
        this.values = new long[0];
    }

    private void sortValues() {
        Arrays.sort(this.values, 0, this.size);
        this.sorted = true;
    }

    static {
        Field field = null;
        try {
            Class<?> clazz = Class.forName("org.glowroot.shaded.HdrHistogram.AbstractHistogramBase");
            field = clazz.getDeclaredField("intermediateUncompressedByteBuffer");
            field.setAccessible(true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        hdrHistogramInternalField = field;
    }
}

