/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.common;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.common.SpyingLogbackFilter;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class ExpectedMessage
extends SpyingLogbackFilter.ExpectedMessageBase {
    private final String loggerName;
    private final String partialMessage;

    private ExpectedMessage(String loggerName, String partialMessage) {
        this.loggerName = Preconditions.checkNotNull(loggerName);
        this.partialMessage = Preconditions.checkNotNull(partialMessage);
    }

    private ExpectedMessage(Builder builder) {
        this.loggerName = builder.loggerName;
        this.partialMessage = builder.partialMessage;
    }

    private ExpectedMessage(ExpectedMessage original, String loggerName, String partialMessage) {
        this.loggerName = loggerName;
        this.partialMessage = partialMessage;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    @Override
    public String partialMessage() {
        return this.partialMessage;
    }

    public final ExpectedMessage withLoggerName(String value) {
        if (this.loggerName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ExpectedMessage(this, newValue, this.partialMessage);
    }

    public final ExpectedMessage withPartialMessage(String value) {
        if (this.partialMessage == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ExpectedMessage(this, this.loggerName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ExpectedMessage && this.equalTo((ExpectedMessage)another);
    }

    private boolean equalTo(ExpectedMessage another) {
        return this.loggerName.equals(another.loggerName) && this.partialMessage.equals(another.partialMessage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.loggerName.hashCode();
        h = h * 17 + this.partialMessage.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ExpectedMessage").add("loggerName", this.loggerName).add("partialMessage", this.partialMessage).toString();
    }

    public static ExpectedMessage of(String loggerName, String partialMessage) {
        return new ExpectedMessage(loggerName, partialMessage);
    }

    static ExpectedMessage copyOf(SpyingLogbackFilter.ExpectedMessageBase instance) {
        if (instance instanceof ExpectedMessage) {
            return (ExpectedMessage)instance;
        }
        return ExpectedMessage.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_LOGGER_NAME = 1L;
        private static final long INITIALIZED_BIT_PARTIAL_MESSAGE = 2L;
        private long initializedBitset;
        @Nullable
        private String loggerName;
        @Nullable
        private String partialMessage;

        private Builder() {
        }

        public final Builder from(SpyingLogbackFilter.ExpectedMessageBase instance) {
            Preconditions.checkNotNull(instance);
            this.loggerName(instance.loggerName());
            this.partialMessage(instance.partialMessage());
            return this;
        }

        public final Builder loggerName(String loggerName) {
            this.loggerName = Preconditions.checkNotNull(loggerName);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder partialMessage(String partialMessage) {
            this.partialMessage = Preconditions.checkNotNull(partialMessage);
            this.initializedBitset |= 2L;
            return this;
        }

        public ExpectedMessage build() {
            this.checkRequiredAttributes();
            return new ExpectedMessage(this);
        }

        private boolean loggerNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean partialMessageIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.loggerNameIsSet()) {
                attributes.add("loggerName");
            }
            if (!this.partialMessageIsSet()) {
                attributes.add("partialMessage");
            }
            return "Cannot build ExpectedMessage, some of required attributes are not set " + attributes;
        }
    }
}

