/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import org.glowroot.shaded.google.common.io.Closer;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class Manifests {
    private static final Logger logger = LoggerFactory.getLogger(Manifests.class);

    private Manifests() {
    }

    @Nullable
    public static Manifest getManifest(Class<?> clazz) throws IOException {
        URL classURL = clazz.getResource(clazz.getSimpleName() + ".class");
        if (classURL == null) {
            logger.warn("url for class is unexpectedly null: {}", (Object)clazz);
            return null;
        }
        String externalForm = classURL.toExternalForm();
        if (!externalForm.startsWith("jar:")) {
            return null;
        }
        URL manifestURL = new URL(externalForm.substring(0, externalForm.lastIndexOf(33)) + "!/META-INF/MANIFEST.MF");
        Closer closer = Closer.create();
        InputStream manifestIn = closer.register(manifestURL.openStream());
        try {
            Manifest manifest = new Manifest(manifestIn);
            return manifest;
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }
}

