/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.AdvancedConfigBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
public final class AdvancedConfig
extends AdvancedConfigBase {
    private final boolean timerWrapperMethods;
    private final boolean weavingTimer;
    private final int immediatePartialStoreThresholdSeconds;
    private final int maxAggregateQueriesPerQueryType;
    private final int maxTraceEntriesPerTransaction;
    private final int maxStackTraceSamplesPerTransaction;
    private final boolean captureThreadInfo;
    private final boolean captureGcInfo;
    private final int mbeanGaugeNotFoundDelaySeconds;
    private final int internalQueryTimeoutSeconds;
    private final String version;

    private AdvancedConfig(Builder builder) {
        this.timerWrapperMethods = builder.timerWrapperMethodsIsSet() ? builder.timerWrapperMethods : super.timerWrapperMethods();
        this.weavingTimer = builder.weavingTimerIsSet() ? builder.weavingTimer : super.weavingTimer();
        this.immediatePartialStoreThresholdSeconds = builder.immediatePartialStoreThresholdSecondsIsSet() ? builder.immediatePartialStoreThresholdSeconds : super.immediatePartialStoreThresholdSeconds();
        this.maxAggregateQueriesPerQueryType = builder.maxAggregateQueriesPerQueryTypeIsSet() ? builder.maxAggregateQueriesPerQueryType : super.maxAggregateQueriesPerQueryType();
        this.maxTraceEntriesPerTransaction = builder.maxTraceEntriesPerTransactionIsSet() ? builder.maxTraceEntriesPerTransaction : super.maxTraceEntriesPerTransaction();
        this.maxStackTraceSamplesPerTransaction = builder.maxStackTraceSamplesPerTransactionIsSet() ? builder.maxStackTraceSamplesPerTransaction : super.maxStackTraceSamplesPerTransaction();
        this.captureThreadInfo = builder.captureThreadInfoIsSet() ? builder.captureThreadInfo : super.captureThreadInfo();
        this.captureGcInfo = builder.captureGcInfoIsSet() ? builder.captureGcInfo : super.captureGcInfo();
        this.mbeanGaugeNotFoundDelaySeconds = builder.mbeanGaugeNotFoundDelaySecondsIsSet() ? builder.mbeanGaugeNotFoundDelaySeconds : super.mbeanGaugeNotFoundDelaySeconds();
        this.internalQueryTimeoutSeconds = builder.internalQueryTimeoutSecondsIsSet() ? builder.internalQueryTimeoutSeconds : super.internalQueryTimeoutSeconds();
        this.version = Preconditions.checkNotNull(super.version());
    }

    private AdvancedConfig(AdvancedConfig original, boolean timerWrapperMethods, boolean weavingTimer, int immediatePartialStoreThresholdSeconds, int maxAggregateQueriesPerQueryType, int maxTraceEntriesPerTransaction, int maxStackTraceSamplesPerTransaction, boolean captureThreadInfo, boolean captureGcInfo, int mbeanGaugeNotFoundDelaySeconds, int internalQueryTimeoutSeconds) {
        this.timerWrapperMethods = timerWrapperMethods;
        this.weavingTimer = weavingTimer;
        this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
        this.maxAggregateQueriesPerQueryType = maxAggregateQueriesPerQueryType;
        this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
        this.maxStackTraceSamplesPerTransaction = maxStackTraceSamplesPerTransaction;
        this.captureThreadInfo = captureThreadInfo;
        this.captureGcInfo = captureGcInfo;
        this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
        this.internalQueryTimeoutSeconds = internalQueryTimeoutSeconds;
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="timerWrapperMethods")
    public boolean timerWrapperMethods() {
        return this.timerWrapperMethods;
    }

    @Override
    @JsonProperty(value="weavingTimer")
    public boolean weavingTimer() {
        return this.weavingTimer;
    }

    @Override
    @JsonProperty(value="immediatePartialStoreThresholdSeconds")
    public int immediatePartialStoreThresholdSeconds() {
        return this.immediatePartialStoreThresholdSeconds;
    }

    @Override
    @JsonProperty(value="maxAggregateQueriesPerQueryType")
    public int maxAggregateQueriesPerQueryType() {
        return this.maxAggregateQueriesPerQueryType;
    }

    @Override
    @JsonProperty(value="maxTraceEntriesPerTransaction")
    public int maxTraceEntriesPerTransaction() {
        return this.maxTraceEntriesPerTransaction;
    }

    @Override
    @JsonProperty(value="maxStackTraceSamplesPerTransaction")
    public int maxStackTraceSamplesPerTransaction() {
        return this.maxStackTraceSamplesPerTransaction;
    }

    @Override
    @JsonProperty(value="captureThreadInfo")
    public boolean captureThreadInfo() {
        return this.captureThreadInfo;
    }

    @Override
    @JsonProperty(value="captureGcInfo")
    public boolean captureGcInfo() {
        return this.captureGcInfo;
    }

    @Override
    @JsonProperty(value="mbeanGaugeNotFoundDelaySeconds")
    public int mbeanGaugeNotFoundDelaySeconds() {
        return this.mbeanGaugeNotFoundDelaySeconds;
    }

    @Override
    @JsonProperty(value="internalQueryTimeoutSeconds")
    public int internalQueryTimeoutSeconds() {
        return this.internalQueryTimeoutSeconds;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final AdvancedConfig withTimerWrapperMethods(boolean value) {
        if (this.timerWrapperMethods == value) {
            return this;
        }
        boolean newValue = value;
        return new AdvancedConfig(this, newValue, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds);
    }

    public final AdvancedConfig withWeavingTimer(boolean value) {
        if (this.weavingTimer == value) {
            return this;
        }
        boolean newValue = value;
        return new AdvancedConfig(this, this.timerWrapperMethods, newValue, this.immediatePartialStoreThresholdSeconds, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds);
    }

    public final AdvancedConfig withImmediatePartialStoreThresholdSeconds(int value) {
        if (this.immediatePartialStoreThresholdSeconds == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfig(this, this.timerWrapperMethods, this.weavingTimer, newValue, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds);
    }

    public final AdvancedConfig withMaxAggregateQueriesPerQueryType(int value) {
        if (this.maxAggregateQueriesPerQueryType == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfig(this, this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, newValue, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds);
    }

    public final AdvancedConfig withMaxTraceEntriesPerTransaction(int value) {
        if (this.maxTraceEntriesPerTransaction == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfig(this, this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateQueriesPerQueryType, newValue, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds);
    }

    public final AdvancedConfig withMaxStackTraceSamplesPerTransaction(int value) {
        if (this.maxStackTraceSamplesPerTransaction == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfig(this, this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, newValue, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds);
    }

    public final AdvancedConfig withCaptureThreadInfo(boolean value) {
        if (this.captureThreadInfo == value) {
            return this;
        }
        boolean newValue = value;
        return new AdvancedConfig(this, this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, newValue, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds);
    }

    public final AdvancedConfig withCaptureGcInfo(boolean value) {
        if (this.captureGcInfo == value) {
            return this;
        }
        boolean newValue = value;
        return new AdvancedConfig(this, this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, newValue, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds);
    }

    public final AdvancedConfig withMbeanGaugeNotFoundDelaySeconds(int value) {
        if (this.mbeanGaugeNotFoundDelaySeconds == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfig(this, this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, newValue, this.internalQueryTimeoutSeconds);
    }

    public final AdvancedConfig withInternalQueryTimeoutSeconds(int value) {
        if (this.internalQueryTimeoutSeconds == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfig(this, this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof AdvancedConfig && this.equalTo((AdvancedConfig)another);
    }

    private boolean equalTo(AdvancedConfig another) {
        return this.timerWrapperMethods == another.timerWrapperMethods && this.weavingTimer == another.weavingTimer && this.immediatePartialStoreThresholdSeconds == another.immediatePartialStoreThresholdSeconds && this.maxAggregateQueriesPerQueryType == another.maxAggregateQueriesPerQueryType && this.maxTraceEntriesPerTransaction == another.maxTraceEntriesPerTransaction && this.maxStackTraceSamplesPerTransaction == another.maxStackTraceSamplesPerTransaction && this.captureThreadInfo == another.captureThreadInfo && this.captureGcInfo == another.captureGcInfo && this.mbeanGaugeNotFoundDelaySeconds == another.mbeanGaugeNotFoundDelaySeconds && this.internalQueryTimeoutSeconds == another.internalQueryTimeoutSeconds && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.timerWrapperMethods);
        h = h * 17 + Booleans.hashCode(this.weavingTimer);
        h = h * 17 + this.immediatePartialStoreThresholdSeconds;
        h = h * 17 + this.maxAggregateQueriesPerQueryType;
        h = h * 17 + this.maxTraceEntriesPerTransaction;
        h = h * 17 + this.maxStackTraceSamplesPerTransaction;
        h = h * 17 + Booleans.hashCode(this.captureThreadInfo);
        h = h * 17 + Booleans.hashCode(this.captureGcInfo);
        h = h * 17 + this.mbeanGaugeNotFoundDelaySeconds;
        h = h * 17 + this.internalQueryTimeoutSeconds;
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AdvancedConfig").add("timerWrapperMethods", this.timerWrapperMethods).add("weavingTimer", this.weavingTimer).add("immediatePartialStoreThresholdSeconds", this.immediatePartialStoreThresholdSeconds).add("maxAggregateQueriesPerQueryType", this.maxAggregateQueriesPerQueryType).add("maxTraceEntriesPerTransaction", this.maxTraceEntriesPerTransaction).add("maxStackTraceSamplesPerTransaction", this.maxStackTraceSamplesPerTransaction).add("captureThreadInfo", this.captureThreadInfo).add("captureGcInfo", this.captureGcInfo).add("mbeanGaugeNotFoundDelaySeconds", this.mbeanGaugeNotFoundDelaySeconds).add("internalQueryTimeoutSeconds", this.internalQueryTimeoutSeconds).add("version", this.version).toString();
    }

    @JsonCreator
    public static AdvancedConfig fromAllAttributes(@JsonProperty(value="timerWrapperMethods") @Nullable Boolean timerWrapperMethods, @JsonProperty(value="weavingTimer") @Nullable Boolean weavingTimer, @JsonProperty(value="immediatePartialStoreThresholdSeconds") @Nullable Integer immediatePartialStoreThresholdSeconds, @JsonProperty(value="maxAggregateQueriesPerQueryType") @Nullable Integer maxAggregateQueriesPerQueryType, @JsonProperty(value="maxTraceEntriesPerTransaction") @Nullable Integer maxTraceEntriesPerTransaction, @JsonProperty(value="maxStackTraceSamplesPerTransaction") @Nullable Integer maxStackTraceSamplesPerTransaction, @JsonProperty(value="captureThreadInfo") @Nullable Boolean captureThreadInfo, @JsonProperty(value="captureGcInfo") @Nullable Boolean captureGcInfo, @JsonProperty(value="mbeanGaugeNotFoundDelaySeconds") @Nullable Integer mbeanGaugeNotFoundDelaySeconds, @JsonProperty(value="internalQueryTimeoutSeconds") @Nullable Integer internalQueryTimeoutSeconds) {
        Builder builder = AdvancedConfig.builder();
        if (timerWrapperMethods != null) {
            builder.timerWrapperMethods(timerWrapperMethods);
        }
        if (weavingTimer != null) {
            builder.weavingTimer(weavingTimer);
        }
        if (immediatePartialStoreThresholdSeconds != null) {
            builder.immediatePartialStoreThresholdSeconds(immediatePartialStoreThresholdSeconds);
        }
        if (maxAggregateQueriesPerQueryType != null) {
            builder.maxAggregateQueriesPerQueryType(maxAggregateQueriesPerQueryType);
        }
        if (maxTraceEntriesPerTransaction != null) {
            builder.maxTraceEntriesPerTransaction(maxTraceEntriesPerTransaction);
        }
        if (maxStackTraceSamplesPerTransaction != null) {
            builder.maxStackTraceSamplesPerTransaction(maxStackTraceSamplesPerTransaction);
        }
        if (captureThreadInfo != null) {
            builder.captureThreadInfo(captureThreadInfo);
        }
        if (captureGcInfo != null) {
            builder.captureGcInfo(captureGcInfo);
        }
        if (mbeanGaugeNotFoundDelaySeconds != null) {
            builder.mbeanGaugeNotFoundDelaySeconds(mbeanGaugeNotFoundDelaySeconds);
        }
        if (internalQueryTimeoutSeconds != null) {
            builder.internalQueryTimeoutSeconds(internalQueryTimeoutSeconds);
        }
        return builder.build();
    }

    public static AdvancedConfig copyOf(AdvancedConfigBase instance) {
        if (instance instanceof AdvancedConfig) {
            return (AdvancedConfig)instance;
        }
        return AdvancedConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long NONDEFAULT_BIT_TIMER_WRAPPER_METHODS = 1L;
        private static final long NONDEFAULT_BIT_WEAVING_TIMER = 2L;
        private static final long NONDEFAULT_BIT_IMMEDIATE_PARTIAL_STORE_THRESHOLD_SECONDS = 4L;
        private static final long NONDEFAULT_BIT_MAX_AGGREGATE_QUERIES_PER_QUERY_TYPE = 8L;
        private static final long NONDEFAULT_BIT_MAX_TRACE_ENTRIES_PER_TRANSACTION = 16L;
        private static final long NONDEFAULT_BIT_MAX_STACK_TRACE_SAMPLES_PER_TRANSACTION = 32L;
        private static final long NONDEFAULT_BIT_CAPTURE_THREAD_INFO = 64L;
        private static final long NONDEFAULT_BIT_CAPTURE_GC_INFO = 128L;
        private static final long NONDEFAULT_BIT_MBEAN_GAUGE_NOT_FOUND_DELAY_SECONDS = 256L;
        private static final long NONDEFAULT_BIT_INTERNAL_QUERY_TIMEOUT_SECONDS = 512L;
        private long nondefaultBitset;
        private boolean timerWrapperMethods;
        private boolean weavingTimer;
        private int immediatePartialStoreThresholdSeconds;
        private int maxAggregateQueriesPerQueryType;
        private int maxTraceEntriesPerTransaction;
        private int maxStackTraceSamplesPerTransaction;
        private boolean captureThreadInfo;
        private boolean captureGcInfo;
        private int mbeanGaugeNotFoundDelaySeconds;
        private int internalQueryTimeoutSeconds;

        private Builder() {
        }

        public final Builder from(AdvancedConfigBase instance) {
            Preconditions.checkNotNull(instance);
            this.timerWrapperMethods(instance.timerWrapperMethods());
            this.weavingTimer(instance.weavingTimer());
            this.immediatePartialStoreThresholdSeconds(instance.immediatePartialStoreThresholdSeconds());
            this.maxAggregateQueriesPerQueryType(instance.maxAggregateQueriesPerQueryType());
            this.maxTraceEntriesPerTransaction(instance.maxTraceEntriesPerTransaction());
            this.maxStackTraceSamplesPerTransaction(instance.maxStackTraceSamplesPerTransaction());
            this.captureThreadInfo(instance.captureThreadInfo());
            this.captureGcInfo(instance.captureGcInfo());
            this.mbeanGaugeNotFoundDelaySeconds(instance.mbeanGaugeNotFoundDelaySeconds());
            this.internalQueryTimeoutSeconds(instance.internalQueryTimeoutSeconds());
            return this;
        }

        public final Builder timerWrapperMethods(boolean timerWrapperMethods) {
            this.timerWrapperMethods = timerWrapperMethods;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder weavingTimer(boolean weavingTimer) {
            this.weavingTimer = weavingTimer;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder immediatePartialStoreThresholdSeconds(int immediatePartialStoreThresholdSeconds) {
            this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder maxAggregateQueriesPerQueryType(int maxAggregateQueriesPerQueryType) {
            this.maxAggregateQueriesPerQueryType = maxAggregateQueriesPerQueryType;
            this.nondefaultBitset |= 8L;
            return this;
        }

        public final Builder maxTraceEntriesPerTransaction(int maxTraceEntriesPerTransaction) {
            this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
            this.nondefaultBitset |= 0x10L;
            return this;
        }

        public final Builder maxStackTraceSamplesPerTransaction(int maxStackTraceSamplesPerTransaction) {
            this.maxStackTraceSamplesPerTransaction = maxStackTraceSamplesPerTransaction;
            this.nondefaultBitset |= 0x20L;
            return this;
        }

        public final Builder captureThreadInfo(boolean captureThreadInfo) {
            this.captureThreadInfo = captureThreadInfo;
            this.nondefaultBitset |= 0x40L;
            return this;
        }

        public final Builder captureGcInfo(boolean captureGcInfo) {
            this.captureGcInfo = captureGcInfo;
            this.nondefaultBitset |= 0x80L;
            return this;
        }

        public final Builder mbeanGaugeNotFoundDelaySeconds(int mbeanGaugeNotFoundDelaySeconds) {
            this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
            this.nondefaultBitset |= 0x100L;
            return this;
        }

        public final Builder internalQueryTimeoutSeconds(int internalQueryTimeoutSeconds) {
            this.internalQueryTimeoutSeconds = internalQueryTimeoutSeconds;
            this.nondefaultBitset |= 0x200L;
            return this;
        }

        public AdvancedConfig build() {
            return new AdvancedConfig(this);
        }

        private boolean timerWrapperMethodsIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean weavingTimerIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean immediatePartialStoreThresholdSecondsIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean maxAggregateQueriesPerQueryTypeIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }

        private boolean maxTraceEntriesPerTransactionIsSet() {
            return (this.nondefaultBitset & 0x10L) != 0L;
        }

        private boolean maxStackTraceSamplesPerTransactionIsSet() {
            return (this.nondefaultBitset & 0x20L) != 0L;
        }

        private boolean captureThreadInfoIsSet() {
            return (this.nondefaultBitset & 0x40L) != 0L;
        }

        private boolean captureGcInfoIsSet() {
            return (this.nondefaultBitset & 0x80L) != 0L;
        }

        private boolean mbeanGaugeNotFoundDelaySecondsIsSet() {
            return (this.nondefaultBitset & 0x100L) != 0L;
        }

        private boolean internalQueryTimeoutSecondsIsSet() {
            return (this.nondefaultBitset & 0x200L) != 0L;
        }
    }
}

