/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.glowroot.common.JavaVersion;
import org.glowroot.common.ObjectMappers;
import org.glowroot.config.Config;
import org.glowroot.config.GaugeConfig;
import org.glowroot.config.GeneralConfig;
import org.glowroot.config.InstrumentationConfig;
import org.glowroot.config.MBeanAttribute;
import org.glowroot.config.PluginConfig;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.config.PropertyDescriptor;
import org.glowroot.config.PropertyValue;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.fasterxml.jackson.core.util.DefaultIndenter;
import org.glowroot.shaded.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.google.common.base.Charsets;
import org.glowroot.shaded.google.common.base.StandardSystemProperty;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.io.CharStreams;
import org.glowroot.shaded.google.common.io.Files;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class ConfigFile {
    private static final Logger logger = LoggerFactory.getLogger(ConfigFile.class);
    private static final String NEWLINE;
    private static final ObjectMapper mapper;
    private final File file;
    private final ImmutableList<PluginDescriptor> pluginDescriptors;

    ConfigFile(File file, List<PluginDescriptor> pluginDescriptors) {
        this.file = file;
        this.pluginDescriptors = PluginDescriptor.orderingById.immutableSortedCopy(pluginDescriptors);
    }

    private Config readValue(String content) throws IOException {
        Config config = mapper.readValue(content, Config.class);
        GeneralConfig generalConfig = config.generalConfig();
        if (generalConfig.defaultDisplayedTransactionType().isEmpty()) {
            generalConfig = generalConfig.withDefaultDisplayedTransactionType(this.getDefaultDisplayedTransactionType(config.instrumentationConfigs()));
            config = config.withGeneralConfig(generalConfig);
        }
        if (!mapper.readTree(content).has("gauges")) {
            List<GaugeConfig> defaultGauges = ConfigFile.getDefaultGaugeConfigs();
            config = config.withGaugeConfigs(defaultGauges);
        }
        HashMap<String, PluginConfig> filePluginConfigs = Maps.newHashMap();
        for (PluginConfig pluginConfig : config.pluginConfigs()) {
            filePluginConfigs.put(pluginConfig.id(), pluginConfig);
        }
        ArrayList<PluginConfig> pluginConfigs = Lists.newArrayList();
        for (PluginDescriptor pluginDescriptor : this.pluginDescriptors) {
            PluginConfig filePluginConfig = (PluginConfig)filePluginConfigs.get(pluginDescriptor.id());
            PluginConfig.Builder builder = PluginConfig.builder().id(pluginDescriptor.id());
            if (filePluginConfig != null) {
                builder.enabled(filePluginConfig.enabled());
            }
            for (PropertyDescriptor propertyDescriptor : pluginDescriptor.properties()) {
                String propertyName = propertyDescriptor.name();
                PropertyValue filePropertyValue = null;
                if (filePluginConfig != null) {
                    filePropertyValue = filePluginConfig.getValidatedPropertyValue(propertyName, propertyDescriptor.type());
                }
                if (filePropertyValue == null) {
                    builder.putProperties(propertyName, propertyDescriptor.getValidatedNonNullDefaultValue());
                    continue;
                }
                builder.putProperties(propertyName, filePropertyValue);
            }
            pluginConfigs.add(builder.build());
        }
        return config.withPluginConfigs(pluginConfigs);
    }

    Config loadConfig() throws IOException {
        Config config;
        if (!this.file.exists()) {
            Config config2 = this.getDefaultConfig();
            this.write(config2);
            return config2;
        }
        String content = Files.toString(this.file, Charsets.UTF_8);
        String warningMessage = null;
        try {
            content = content.replace("\"defaultTransactionType\"", "\"defaultDisplayedTransactionType\"");
            config = this.readValue(content);
        }
        catch (Exception e) {
            logger.warn("error processing config file: {}", (Object)this.file.getAbsolutePath(), (Object)e);
            File backupFile = new File(this.file.getParentFile(), this.file.getName() + ".invalid-orig");
            config = this.getDefaultConfig();
            try {
                Files.copy(this.file, backupFile);
                warningMessage = "due to an error in the config file, it has been backed up to extension '.invalid-orig' and overwritten with the default config";
            }
            catch (IOException f) {
                logger.warn("error making a copy of the invalid config file before overwriting it", f);
                warningMessage = "due to an error in the config file, it has been overwritten with the default config";
            }
        }
        this.writeToFileIfNeeded(config, content);
        if (warningMessage != null) {
            logger.warn(warningMessage);
        }
        return config;
    }

    String getDefaultDisplayedTransactionType(List<InstrumentationConfig> configs) {
        for (PluginDescriptor descriptor : this.pluginDescriptors) {
            if (descriptor.transactionTypes().isEmpty()) continue;
            return (String)descriptor.transactionTypes().get(0);
        }
        for (InstrumentationConfig config : configs) {
            if (config.transactionType().isEmpty()) continue;
            return config.transactionType();
        }
        return "";
    }

    private void writeToFileIfNeeded(Config config, String existingContent) throws IOException {
        String content = ConfigFile.writeValueAsString(config);
        if (content.equals(existingContent)) {
            return;
        }
        Files.write(content, this.file, Charsets.UTF_8);
    }

    Config getDefaultConfig() {
        return Config.builder().addAllPluginConfigs(ConfigFile.getDefaultPluginConfigs(this.pluginDescriptors)).addAllGaugeConfigs(ConfigFile.getDefaultGaugeConfigs()).build();
    }

    void write(Config config) throws IOException {
        Files.write(ConfigFile.writeValueAsString(config), this.file, Charsets.UTF_8);
    }

    private static List<GaugeConfig> getDefaultGaugeConfigs() {
        ArrayList<GaugeConfig> defaultGaugeConfigs = Lists.newArrayList();
        defaultGaugeConfigs.add(GaugeConfig.builder().mbeanObjectName("java.lang:type=Memory").addMbeanAttributes(MBeanAttribute.of("HeapMemoryUsage/used", false)).build());
        defaultGaugeConfigs.add(GaugeConfig.builder().mbeanObjectName("java.lang:type=GarbageCollector,name=*").addMbeanAttributes(MBeanAttribute.of("CollectionCount", true)).addMbeanAttributes(MBeanAttribute.of("CollectionTime", true)).build());
        defaultGaugeConfigs.add(GaugeConfig.builder().mbeanObjectName("java.lang:type=MemoryPool,name=*").addMbeanAttributes(MBeanAttribute.of("Usage/used", false)).build());
        GaugeConfig.Builder operatingSystemMBean = GaugeConfig.builder().mbeanObjectName("java.lang:type=OperatingSystem").addMbeanAttributes(MBeanAttribute.of("FreePhysicalMemorySize", false));
        if (!JavaVersion.isJava6()) {
            operatingSystemMBean.addMbeanAttributes(MBeanAttribute.of("ProcessCpuLoad", false));
            operatingSystemMBean.addMbeanAttributes(MBeanAttribute.of("SystemCpuLoad", false));
        }
        defaultGaugeConfigs.add(operatingSystemMBean.build());
        return defaultGaugeConfigs;
    }

    private static String writeValueAsString(Config config) throws IOException {
        CustomPrettyPrinter prettyPrinter = new CustomPrettyPrinter();
        prettyPrinter.indentArraysWith(DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb)).setPrettyPrinter(prettyPrinter);
        jg.writeObject(config);
        jg.close();
        return sb.toString() + NEWLINE;
    }

    private static List<PluginConfig> getDefaultPluginConfigs(List<PluginDescriptor> pluginDescriptors) {
        ArrayList<PluginConfig> pluginConfigs = Lists.newArrayList();
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            PluginConfig.Builder builder = PluginConfig.builder().id(pluginDescriptor.id()).enabled(true);
            for (PropertyDescriptor propertyDescriptor : pluginDescriptor.properties()) {
                PropertyValue defaultValue = propertyDescriptor.getValidatedNonNullDefaultValue();
                builder.putProperties(propertyDescriptor.name(), defaultValue);
            }
            pluginConfigs.add(builder.build());
        }
        return pluginConfigs;
    }

    @OnlyUsedByTests
    void delete() throws IOException {
        if (!this.file.delete()) {
            throw new IOException("Could not delete file: " + this.file.getCanonicalPath());
        }
    }

    static {
        mapper = ObjectMappers.create();
        String newline = StandardSystemProperty.LINE_SEPARATOR.value();
        NEWLINE = newline == null ? "\n" : newline;
    }

    private static class CustomPrettyPrinter
    extends DefaultPrettyPrinter {
        private CustomPrettyPrinter() {
        }

        @Override
        public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(": ");
        }
    }
}

