/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.common.ObjectMappers;
import org.glowroot.config.PluginCache;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.shaded.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.google.common.base.Charsets;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Iterators;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.io.Resources;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.immutables.value.Value;

@Value.Immutable
abstract class PluginCacheBase {
    private static final Logger logger = LoggerFactory.getLogger(PluginCache.class);
    private static final ObjectMapper mapper = ObjectMappers.create();

    PluginCacheBase() {
    }

    abstract ImmutableList<File> pluginJars();

    abstract ImmutableList<PluginDescriptor> pluginDescriptors();

    static PluginCache create(@Nullable File glowrootJarFile, boolean viewerModeEnabled) throws URISyntaxException, IOException {
        PluginCache.Builder builder = PluginCache.builder();
        ArrayList<URL> descriptorURLs = Lists.newArrayList();
        if (glowrootJarFile != null) {
            ImmutableList<File> pluginJars = PluginCacheBase.getPluginJars(glowrootJarFile);
            builder.addAllPluginJars(pluginJars);
            for (File pluginJar : pluginJars) {
                descriptorURLs.add(new URL("jar:" + pluginJar.toURI() + "!/META-INF/glowroot.plugin.json"));
            }
            for (File file : PluginCacheBase.getStandaloneDescriptors(glowrootJarFile)) {
                descriptorURLs.add(file.toURI().toURL());
            }
        }
        descriptorURLs.addAll(PluginCacheBase.getResources("META-INF/glowroot.plugin.json"));
        if (viewerModeEnabled) {
            builder.addAllPluginDescriptors(PluginCacheBase.createInViewerMode(descriptorURLs));
        } else {
            builder.addAllPluginDescriptors(PluginCacheBase.readPluginDescriptors(descriptorURLs));
        }
        return builder.build();
    }

    private static ImmutableList<File> getPluginJars(File glowrootJarFile) throws URISyntaxException, IOException {
        File pluginsDir = PluginCacheBase.getPluginsDir(glowrootJarFile);
        if (pluginsDir == null) {
            return ImmutableList.of();
        }
        File[] pluginJars = pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (pluginJars == null) {
            logger.warn("listFiles() returned null on directory: {}", (Object)pluginsDir.getAbsolutePath());
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(pluginJars);
    }

    private static ImmutableList<File> getStandaloneDescriptors(File glowrootJarFile) throws IOException, URISyntaxException {
        File pluginsDir = PluginCacheBase.getPluginsDir(glowrootJarFile);
        if (pluginsDir == null) {
            return ImmutableList.of();
        }
        File[] pluginDescriptorFiles = pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".json");
            }
        });
        if (pluginDescriptorFiles == null) {
            logger.warn("listFiles() returned null on directory: {}", (Object)pluginsDir.getAbsolutePath());
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(pluginDescriptorFiles);
    }

    @Nullable
    private static File getPluginsDir(File glowrootJarFile) throws IOException, URISyntaxException {
        File pluginsDir = new File(glowrootJarFile.getParentFile(), "plugins");
        if (!pluginsDir.exists()) {
            return null;
        }
        return pluginsDir;
    }

    private static ImmutableList<URL> getResources(String resourceName) throws IOException {
        ClassLoader loader = PluginCache.class.getClassLoader();
        if (loader == null) {
            return ImmutableList.copyOf(Iterators.forEnumeration(ClassLoader.getSystemResources(resourceName)));
        }
        return ImmutableList.copyOf(Iterators.forEnumeration(loader.getResources(resourceName)));
    }

    private static List<PluginDescriptor> createInViewerMode(List<URL> descriptorURLs) throws IOException, URISyntaxException {
        List<PluginDescriptor> pluginDescriptors = PluginCacheBase.readPluginDescriptors(descriptorURLs);
        ArrayList<PluginDescriptor> pluginDescriptorsWithoutAdvice = Lists.newArrayList();
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            pluginDescriptorsWithoutAdvice.add(pluginDescriptor.withAspects(new String[0]));
        }
        return PluginCacheBase.sorted(pluginDescriptorsWithoutAdvice);
    }

    private static List<PluginDescriptor> readPluginDescriptors(List<URL> descriptorURLs) throws IOException, URISyntaxException {
        ArrayList<PluginDescriptor> pluginDescriptors = Lists.newArrayList();
        for (URL url : descriptorURLs) {
            try {
                String content = Resources.toString(url, Charsets.UTF_8);
                PluginDescriptor pluginDescriptor = mapper.readValue(content, PluginDescriptor.class);
                pluginDescriptors.add(pluginDescriptor);
            }
            catch (JsonProcessingException e) {
                logger.error("error parsing plugin descriptor: {}", (Object)url.toExternalForm(), (Object)e);
            }
        }
        return PluginCacheBase.sorted(pluginDescriptors);
    }

    private static List<PluginDescriptor> sorted(List<PluginDescriptor> pluginDescriptors) {
        return PluginDescriptor.specialOrderingByName.immutableSortedCopy(pluginDescriptors);
    }
}

