/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.SmtpConfigBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
public final class SmtpConfig
extends SmtpConfigBase {
    private final String fromEmailAddress;
    private final String fromDisplayName;
    private final String host;
    @Nullable
    private final Integer port;
    private final boolean ssl;
    private final String username;
    private final String encryptedPassword;
    private final ImmutableMap<String, String> additionalProperties;
    private final String version;

    private SmtpConfig(Builder builder) {
        this.port = builder.port;
        this.additionalProperties = builder.additionalPropertiesBuilder.build();
        this.fromEmailAddress = builder.fromEmailAddress != null ? builder.fromEmailAddress : Preconditions.checkNotNull(super.fromEmailAddress());
        this.fromDisplayName = builder.fromDisplayName != null ? builder.fromDisplayName : Preconditions.checkNotNull(super.fromDisplayName());
        this.host = builder.host != null ? builder.host : Preconditions.checkNotNull(super.host());
        this.ssl = builder.sslIsSet() ? builder.ssl : super.ssl();
        this.username = builder.username != null ? builder.username : Preconditions.checkNotNull(super.username());
        this.encryptedPassword = builder.encryptedPassword != null ? builder.encryptedPassword : Preconditions.checkNotNull(super.encryptedPassword());
        this.version = Preconditions.checkNotNull(super.version());
    }

    private SmtpConfig(SmtpConfig original, String fromEmailAddress, String fromDisplayName, String host, @Nullable Integer port, boolean ssl, String username, String encryptedPassword, ImmutableMap<String, String> additionalProperties) {
        this.fromEmailAddress = fromEmailAddress;
        this.fromDisplayName = fromDisplayName;
        this.host = host;
        this.port = port;
        this.ssl = ssl;
        this.username = username;
        this.encryptedPassword = encryptedPassword;
        this.additionalProperties = additionalProperties;
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="fromEmailAddress")
    public String fromEmailAddress() {
        return this.fromEmailAddress;
    }

    @Override
    @JsonProperty(value="fromDisplayName")
    public String fromDisplayName() {
        return this.fromDisplayName;
    }

    @Override
    @JsonProperty(value="host")
    public String host() {
        return this.host;
    }

    @Override
    @Nullable
    @JsonProperty(value="port")
    public Integer port() {
        return this.port;
    }

    @Override
    @JsonProperty(value="ssl")
    public boolean ssl() {
        return this.ssl;
    }

    @Override
    @JsonProperty(value="username")
    public String username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="encryptedPassword")
    public String encryptedPassword() {
        return this.encryptedPassword;
    }

    @JsonProperty(value="additionalProperties")
    public ImmutableMap<String, String> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final SmtpConfig withFromEmailAddress(String value) {
        if (this.fromEmailAddress == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new SmtpConfig(this, newValue, this.fromDisplayName, this.host, this.port, this.ssl, this.username, this.encryptedPassword, this.additionalProperties);
    }

    public final SmtpConfig withFromDisplayName(String value) {
        if (this.fromDisplayName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new SmtpConfig(this, this.fromEmailAddress, newValue, this.host, this.port, this.ssl, this.username, this.encryptedPassword, this.additionalProperties);
    }

    public final SmtpConfig withHost(String value) {
        if (this.host == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new SmtpConfig(this, this.fromEmailAddress, this.fromDisplayName, newValue, this.port, this.ssl, this.username, this.encryptedPassword, this.additionalProperties);
    }

    public final SmtpConfig withPort(@Nullable Integer value) {
        if (this.port == value) {
            return this;
        }
        Integer newValue = value;
        return new SmtpConfig(this, this.fromEmailAddress, this.fromDisplayName, this.host, newValue, this.ssl, this.username, this.encryptedPassword, this.additionalProperties);
    }

    public final SmtpConfig withSsl(boolean value) {
        if (this.ssl == value) {
            return this;
        }
        boolean newValue = value;
        return new SmtpConfig(this, this.fromEmailAddress, this.fromDisplayName, this.host, this.port, newValue, this.username, this.encryptedPassword, this.additionalProperties);
    }

    public final SmtpConfig withUsername(String value) {
        if (this.username == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new SmtpConfig(this, this.fromEmailAddress, this.fromDisplayName, this.host, this.port, this.ssl, newValue, this.encryptedPassword, this.additionalProperties);
    }

    public final SmtpConfig withEncryptedPassword(String value) {
        if (this.encryptedPassword == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new SmtpConfig(this, this.fromEmailAddress, this.fromDisplayName, this.host, this.port, this.ssl, this.username, newValue, this.additionalProperties);
    }

    public final SmtpConfig withAdditionalProperties(Map<String, ? extends String> entries) {
        if (this.additionalProperties == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new SmtpConfig(this, this.fromEmailAddress, this.fromDisplayName, this.host, this.port, this.ssl, this.username, this.encryptedPassword, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof SmtpConfig && this.equalTo((SmtpConfig)another);
    }

    private boolean equalTo(SmtpConfig another) {
        return this.fromEmailAddress.equals(another.fromEmailAddress) && this.fromDisplayName.equals(another.fromDisplayName) && this.host.equals(another.host) && Objects.equal(this.port, another.port) && this.ssl == another.ssl && this.username.equals(another.username) && this.encryptedPassword.equals(another.encryptedPassword) && this.additionalProperties.equals(another.additionalProperties) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.fromEmailAddress.hashCode();
        h = h * 17 + this.fromDisplayName.hashCode();
        h = h * 17 + this.host.hashCode();
        h = h * 17 + Objects.hashCode(this.port);
        h = h * 17 + Booleans.hashCode(this.ssl);
        h = h * 17 + this.username.hashCode();
        h = h * 17 + this.encryptedPassword.hashCode();
        h = h * 17 + this.additionalProperties.hashCode();
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SmtpConfig").add("fromEmailAddress", this.fromEmailAddress).add("fromDisplayName", this.fromDisplayName).add("host", this.host).add("port", this.port).add("ssl", this.ssl).add("username", this.username).add("encryptedPassword", this.encryptedPassword).add("additionalProperties", this.additionalProperties).add("version", this.version).toString();
    }

    @JsonCreator
    public static SmtpConfig fromAllAttributes(@JsonProperty(value="fromEmailAddress") @Nullable String fromEmailAddress, @JsonProperty(value="fromDisplayName") @Nullable String fromDisplayName, @JsonProperty(value="host") @Nullable String host, @JsonProperty(value="port") @Nullable Integer port, @JsonProperty(value="ssl") @Nullable Boolean ssl, @JsonProperty(value="username") @Nullable String username, @JsonProperty(value="encryptedPassword") @Nullable String encryptedPassword, @JsonProperty(value="additionalProperties") @Nullable Map<String, String> additionalProperties) {
        Builder builder = SmtpConfig.builder();
        if (fromEmailAddress != null) {
            builder.fromEmailAddress(fromEmailAddress);
        }
        if (fromDisplayName != null) {
            builder.fromDisplayName(fromDisplayName);
        }
        if (host != null) {
            builder.host(host);
        }
        if (port != null) {
            builder.port(port);
        }
        if (ssl != null) {
            builder.ssl(ssl);
        }
        if (username != null) {
            builder.username(username);
        }
        if (encryptedPassword != null) {
            builder.encryptedPassword(encryptedPassword);
        }
        if (additionalProperties != null) {
            builder.putAllAdditionalProperties(additionalProperties);
        }
        return builder.build();
    }

    public static SmtpConfig copyOf(SmtpConfigBase instance) {
        if (instance instanceof SmtpConfig) {
            return (SmtpConfig)instance;
        }
        return SmtpConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long NONDEFAULT_BIT_SSL = 1L;
        private long nondefaultBitset;
        @Nullable
        private String fromEmailAddress;
        @Nullable
        private String fromDisplayName;
        @Nullable
        private String host;
        @Nullable
        private Integer port;
        private boolean ssl;
        @Nullable
        private String username;
        @Nullable
        private String encryptedPassword;
        private ImmutableMap.Builder<String, String> additionalPropertiesBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder from(SmtpConfigBase instance) {
            Preconditions.checkNotNull(instance);
            this.fromEmailAddress(instance.fromEmailAddress());
            this.fromDisplayName(instance.fromDisplayName());
            this.host(instance.host());
            Integer portValue = instance.port();
            if (portValue != null) {
                this.port(portValue);
            }
            this.ssl(instance.ssl());
            this.username(instance.username());
            this.encryptedPassword(instance.encryptedPassword());
            this.putAllAdditionalProperties(instance.additionalProperties());
            return this;
        }

        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = Preconditions.checkNotNull(fromEmailAddress);
            return this;
        }

        public final Builder fromDisplayName(String fromDisplayName) {
            this.fromDisplayName = Preconditions.checkNotNull(fromDisplayName);
            return this;
        }

        public final Builder host(String host) {
            this.host = Preconditions.checkNotNull(host);
            return this;
        }

        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public final Builder ssl(boolean ssl) {
            this.ssl = ssl;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder username(String username) {
            this.username = Preconditions.checkNotNull(username);
            return this;
        }

        public final Builder encryptedPassword(String encryptedPassword) {
            this.encryptedPassword = Preconditions.checkNotNull(encryptedPassword);
            return this;
        }

        public final Builder putAdditionalProperties(String key, String value) {
            this.additionalPropertiesBuilder.put(key, value);
            return this;
        }

        public final Builder putAdditionalProperties(Map.Entry<String, ? extends String> entry) {
            this.additionalPropertiesBuilder.put(entry);
            return this;
        }

        public final Builder additionalProperties(Map<String, ? extends String> entries) {
            this.additionalPropertiesBuilder = ImmutableMap.builder();
            return this.putAllAdditionalProperties(entries);
        }

        public final Builder putAllAdditionalProperties(Map<String, ? extends String> entries) {
            this.additionalPropertiesBuilder.putAll(entries);
            return this;
        }

        public SmtpConfig build() {
            return new SmtpConfig(this);
        }

        private boolean sslIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }
    }
}

