/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container;

import com.google.common.base.MoreObjects;
import com.google.common.base.StandardSystemProperty;
import java.io.File;
import java.io.IOException;

public class TempDirs {
    private TempDirs() {
    }

    public static File createTempDir(String prefix) throws IOException {
        int tempDirAttempts = 10000;
        String javaTempDir = (String)MoreObjects.firstNonNull((Object)StandardSystemProperty.JAVA_IO_TMPDIR.value(), (Object)".");
        File baseDir = new File(javaTempDir);
        String baseName = prefix + "-" + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IOException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    public static void deleteRecursively(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("Could not find file to delete: " + file.getCanonicalPath());
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                throw new IOException();
            }
            for (File f : files) {
                TempDirs.deleteRecursively(f);
            }
            if (!file.delete()) {
                throw new IOException("Could not delete directory: " + file.getCanonicalPath());
            }
        } else if (!file.delete()) {
            throw new IOException("Could not delete file: " + file.getCanonicalPath());
        }
    }
}

