/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container;

import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Threads {
    private static final Logger logger = LoggerFactory.getLogger(Threads.class);

    private Threads() {
    }

    public static List<Thread> currentThreads() {
        ArrayList threads = Lists.newArrayList();
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (thread.getState() == Thread.State.TERMINATED || thread.getName().equals("DestroyJavaVM") || thread.getName().equals("AWT-AppKit") || thread.getName().equals("process reaper")) continue;
            threads.add(thread);
        }
        return threads;
    }

    public static void preShutdownCheck(Collection<Thread> preExistingThreads) throws InterruptedException {
        ArrayList rogueThreads;
        List<Thread> nonPreExistingThreads;
        Stopwatch stopwatch = Stopwatch.createStarted();
        do {
            nonPreExistingThreads = Threads.getNonPreExistingThreads(preExistingThreads);
            rogueThreads = Lists.newArrayList();
            for (Thread thread : nonPreExistingThreads) {
                if (!Threads.isRogueThread(thread)) continue;
                rogueThreads.add(thread);
            }
            if (rogueThreads.isEmpty() && nonPreExistingThreads.size() <= 7) {
                return;
            }
            Thread.sleep(10L);
        } while (stopwatch.elapsed(TimeUnit.SECONDS) < 5L);
        if (!rogueThreads.isEmpty()) {
            throw new RogueThreadsException(rogueThreads);
        }
        throw new TooManyThreadsException(nonPreExistingThreads);
    }

    public static void postShutdownCheck(Collection<Thread> preExistingThreads) throws InterruptedException {
        List<Thread> rogueThreads;
        Stopwatch stopwatch = Stopwatch.createStarted();
        do {
            if ((rogueThreads = Threads.getNonPreExistingThreads(preExistingThreads)).isEmpty()) {
                return;
            }
            if (rogueThreads.size() == 1 && rogueThreads.get(0).getName().equals(Threads.getGenerateSeedThreadName())) {
                return;
            }
            Thread.sleep(10L);
        } while (stopwatch.elapsed(TimeUnit.SECONDS) < 5L);
        throw new RogueThreadsException(rogueThreads);
    }

    public static void moreAccurateSleep(int millis) throws InterruptedException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (millis > 10) {
            Thread.sleep(millis - 10);
        }
        while (stopwatch.elapsed(TimeUnit.MILLISECONDS) < (long)millis) {
            Thread.sleep(1L);
        }
    }

    private static List<Thread> getNonPreExistingThreads(Collection<Thread> preExistingThreads) {
        List<Thread> currentThreads = Threads.currentThreads();
        currentThreads.removeAll(preExistingThreads);
        currentThreads.remove(Thread.currentThread());
        return currentThreads;
    }

    private static boolean isRogueThread(Thread thread) {
        if (!thread.isDaemon()) {
            return true;
        }
        if (Threads.isShaded() && !thread.getName().startsWith("Glowroot-")) {
            return true;
        }
        return !Threads.isShaded() && !thread.getName().startsWith("Glowroot-") && !thread.getName().startsWith("H2 File Lock Watchdog ") && !thread.getName().startsWith("H2 Log Writer ") && !thread.getName().equals("Generate Seed");
    }

    private static String getGenerateSeedThreadName() {
        if (Threads.isShaded()) {
            return "Glowroot-H2 Generate Seed";
        }
        return "Generate Seed";
    }

    private static boolean isShaded() {
        try {
            Class.forName("org.glowroot.shaded.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static class ThreadsException
    extends RuntimeException {
        private final Collection<Thread> threads;

        private ThreadsException(Collection<Thread> threads) {
            this.threads = threads;
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            for (Thread thread : this.threads) {
                sb.append(ThreadsException.threadToString(thread));
                sb.append("\n");
            }
            return sb.toString();
        }

        private static String threadToString(Thread thread) {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)thread).add("name", (Object)thread.getName()).add("class", (Object)thread.getClass().getName()).add("state", (Object)thread.getState());
            for (int i = 0; i < Math.min(30, thread.getStackTrace().length); ++i) {
                toStringHelper.add("stackTrace." + i, (Object)thread.getStackTrace()[i].toString());
            }
            return toStringHelper.toString();
        }
    }

    private static class TooManyThreadsException
    extends ThreadsException {
        private TooManyThreadsException(Collection<Thread> threads) {
            super(threads);
        }
    }

    private static class RogueThreadsException
    extends ThreadsException {
        private RogueThreadsException(Collection<Thread> threads) {
            super(threads);
        }
    }
}

