/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.aggregate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.glowroot.container.aggregate.Query;
import org.glowroot.container.common.HttpClient;
import org.glowroot.container.common.ObjectMappers;

public class AggregateService {
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final HttpClient httpClient;

    public AggregateService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public List<Query> getQueries() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (stopwatch.elapsed(TimeUnit.SECONDS) < 5L) {
            List<Query> queries = this.getQueriesInternal();
            if (queries.isEmpty()) continue;
            return queries;
        }
        throw new AssertionError((Object)"No queries found");
    }

    private List<Query> getQueriesInternal() throws Exception {
        String content = this.httpClient.get("/backend/transaction/queries?from=0&to=9223372036854775807&transaction-type=Test+harness");
        return (List)mapper.readValue(content, (TypeReference)new TypeReference<List<Query>>(){});
    }
}

