/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMappers {
    private static final Logger logger = LoggerFactory.getLogger(ObjectMappers.class);

    private ObjectMappers() {
    }

    public static ObjectMapper create() {
        return new ObjectMapper().registerModule((Module)EnumModule.create());
    }

    public static <T> T readRequiredValue(ObjectMapper mapper, String content, Class<T> valueType) throws IOException {
        Object value = mapper.readValue(content, valueType);
        if (value == null) {
            throw new JsonMappingException("Content is json null");
        }
        return (T)value;
    }

    public static JsonNode getRequiredChildNode(JsonNode parentNode, String fieldName) throws IOException {
        JsonNode node = parentNode.get(fieldName);
        if (node == null) {
            throw new JsonMappingException("Missing required field: " + fieldName);
        }
        if (node.isNull()) {
            throw new JsonMappingException("Required field is json null: " + fieldName);
        }
        return node;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> void checkRequiredProperty(T reference, String fieldName) throws JsonMappingException {
        if (reference == null) {
            throw new JsonMappingException("Null value not allowed for field: " + fieldName);
        }
    }

    public static <T> List<T> orEmpty(@Nullable List<T> list, String fieldName) throws JsonMappingException {
        if (list == null) {
            return ImmutableList.of();
        }
        for (T item : list) {
            if (item != null) continue;
            throw new JsonMappingException("Null items are not allowed in array field: " + fieldName);
        }
        return list;
    }

    @PolyNull
    public static <T> List<T> checkNotNullItems(@PolyNull List<T> list, String fieldName) throws JsonMappingException {
        if (list == null) {
            return null;
        }
        for (T item : list) {
            if (item != null) continue;
            throw new JsonMappingException("Null items are not allowed in array field: " + fieldName);
        }
        return list;
    }

    @PolyNull
    public static <K, V> Map<K, V> checkNotNullValuesForProperty(@PolyNull Map<K, V> map, String fieldName) throws JsonMappingException {
        if (map == null) {
            return null;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getValue() != null) continue;
            throw new JsonMappingException("Null values are not allowed in object: " + fieldName);
        }
        return map;
    }

    public static <T> List<T> nullToEmpty(@Nullable List<T> list) {
        if (list == null) {
            return Lists.newArrayList();
        }
        return list;
    }

    public static <K, V> Map<K, V> nullToEmpty(@Nullable Map<K, V> map) {
        if (map == null) {
            return Maps.newHashMap();
        }
        return map;
    }

    public static boolean nullToFalse(@Nullable Boolean value) {
        return value == null ? false : value;
    }

    private static class EnumDeserializer
    extends JsonDeserializer<Enum<?>> {
        private final Class<?> enumClass;
        private final ImmutableMap<String, Enum<?>> enumMap;

        public EnumDeserializer(Class<?> enumClass) {
            this.enumClass = enumClass;
            if (enumClass.isEnum()) {
                ImmutableMap.Builder theEnumMap = ImmutableMap.builder();
                ?[] enumConstants = enumClass.getEnumConstants();
                if (enumConstants != null) {
                    for (Object enumConstant : enumConstants) {
                        if (enumConstant instanceof Enum) {
                            Enum constant = (Enum)enumConstant;
                            theEnumMap.put((Object)constant.name().replace('_', '-').toLowerCase(Locale.ENGLISH), (Object)constant);
                            continue;
                        }
                        logger.error("unexpected constant class: {}", enumConstant.getClass());
                    }
                }
                this.enumMap = theEnumMap.build();
            } else {
                logger.error("unexpected class: {}", enumClass);
                this.enumMap = ImmutableMap.of();
            }
        }

        @Nullable
        public Enum<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String text = jp.getText();
            Enum constant = (Enum)this.enumMap.get((Object)text);
            if (constant == null) {
                logger.warn("enum constant {} not found in enum type {}", (Object)text, (Object)this.enumClass.getName());
            }
            return constant;
        }
    }

    private static class EnumSerializer
    extends JsonSerializer<Object> {
        private EnumSerializer() {
        }

        public void serialize(@Nullable Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                jgen.writeNull();
            } else if (value instanceof Enum) {
                jgen.writeString(((Enum)value).name().replace('_', '-').toLowerCase(Locale.ENGLISH));
            } else {
                logger.error("unexpected value class: {}", value.getClass());
            }
        }
    }

    private static class EnumModule
    extends SimpleModule {
        private EnumModule() {
        }

        private static EnumModule create() {
            EnumModule module = new EnumModule();
            module.addSerializer(Enum.class, new EnumSerializer());
            return module;
        }

        public void setupModule(Module.SetupContext context) {
            super.setupModule(context);
            context.addDeserializers((Deserializers)new Deserializers.Base(){

                public EnumDeserializer findEnumDeserializer(Class<?> enumClass, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
                    return new EnumDeserializer(enumClass);
                }
            });
        }
    }
}

