/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class AdvancedConfig {
    private boolean timerWrapperMethods;
    private boolean weavingTimer;
    private int immediatePartialStoreThresholdSeconds;
    private int maxAggregateQueriesPerQueryType;
    private int maxTraceEntriesPerTransaction;
    private int maxStackTraceSamplesPerTransaction;
    private boolean captureThreadInfo;
    private boolean captureGcInfo;
    private int mbeanGaugeNotFoundDelaySeconds;
    private int internalQueryTimeoutSeconds;
    private final String version;

    private AdvancedConfig(String version) {
        this.version = version;
    }

    public boolean isTimerWrapperMethods() {
        return this.timerWrapperMethods;
    }

    public void setTimerWrapperMethods(boolean timerWrapperMethods) {
        this.timerWrapperMethods = timerWrapperMethods;
    }

    public boolean isWeavingTimer() {
        return this.weavingTimer;
    }

    public void setWeavingTimer(boolean weavingTimer) {
        this.weavingTimer = weavingTimer;
    }

    public int getImmediatePartialStoreThresholdSeconds() {
        return this.immediatePartialStoreThresholdSeconds;
    }

    public void setImmediatePartialStoreThresholdSeconds(int immediatePartialStoreThresholdSeconds) {
        this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
    }

    public int getMaxAggregateQueriesPerQueryType() {
        return this.maxAggregateQueriesPerQueryType;
    }

    public void setMaxAggregateQueriesPerQueryType(int maxAggregateQueriesPerQueryType) {
        this.maxAggregateQueriesPerQueryType = maxAggregateQueriesPerQueryType;
    }

    public int getMaxTraceEntriesPerTransaction() {
        return this.maxTraceEntriesPerTransaction;
    }

    public void setMaxTraceEntriesPerTransaction(int maxTraceEntriesPerTransaction) {
        this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
    }

    public int getMaxStackTraceSamplesPerTransaction() {
        return this.maxStackTraceSamplesPerTransaction;
    }

    public void setMaxStackTraceSamplesPerTransaction(int maxStackTraceSamplesPerTransaction) {
        this.maxStackTraceSamplesPerTransaction = maxStackTraceSamplesPerTransaction;
    }

    public boolean isCaptureThreadInfo() {
        return this.captureThreadInfo;
    }

    public void setCaptureThreadInfo(boolean captureThreadInfo) {
        this.captureThreadInfo = captureThreadInfo;
    }

    public boolean isCaptureGcInfo() {
        return this.captureGcInfo;
    }

    public void setCaptureGcInfo(boolean captureGcInfo) {
        this.captureGcInfo = captureGcInfo;
    }

    public int getMBeanGaugeNotFoundDelaySeconds() {
        return this.mbeanGaugeNotFoundDelaySeconds;
    }

    public void setMBeanGaugeNotFoundDelaySeconds(int mbeanGaugeNotFoundDelaySeconds) {
        this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
    }

    public int getInternalQueryTimeoutSeconds() {
        return this.internalQueryTimeoutSeconds;
    }

    public void setInternalQueryTimeoutSeconds(int internalQueryTimeoutSeconds) {
        this.internalQueryTimeoutSeconds = internalQueryTimeoutSeconds;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof AdvancedConfig) {
            AdvancedConfig that = (AdvancedConfig)obj;
            return Objects.equal((Object)this.timerWrapperMethods, (Object)that.timerWrapperMethods) && Objects.equal((Object)this.weavingTimer, (Object)that.weavingTimer) && Objects.equal((Object)this.immediatePartialStoreThresholdSeconds, (Object)that.immediatePartialStoreThresholdSeconds) && Objects.equal((Object)this.maxAggregateQueriesPerQueryType, (Object)that.maxAggregateQueriesPerQueryType) && Objects.equal((Object)this.maxTraceEntriesPerTransaction, (Object)that.maxTraceEntriesPerTransaction) && Objects.equal((Object)this.maxStackTraceSamplesPerTransaction, (Object)that.maxStackTraceSamplesPerTransaction) && Objects.equal((Object)this.captureThreadInfo, (Object)that.captureThreadInfo) && Objects.equal((Object)this.captureGcInfo, (Object)that.captureGcInfo) && Objects.equal((Object)this.mbeanGaugeNotFoundDelaySeconds, (Object)that.mbeanGaugeNotFoundDelaySeconds) && Objects.equal((Object)this.internalQueryTimeoutSeconds, (Object)that.internalQueryTimeoutSeconds);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timerWrapperMethods", this.timerWrapperMethods).add("weavingTimer", this.weavingTimer).add("immediatePartialStoreThresholdSeconds", this.immediatePartialStoreThresholdSeconds).add("maxAggregateQueriesPerQueryType", this.maxAggregateQueriesPerQueryType).add("maxTraceEntriesPerTransaction", this.maxTraceEntriesPerTransaction).add("maxStackTraceSamplesPerTransaction", this.maxStackTraceSamplesPerTransaction).add("captureThreadInfo", this.captureThreadInfo).add("captureGcInfo", this.captureGcInfo).add("mbeanGaugeNotFoundDelaySeconds", this.mbeanGaugeNotFoundDelaySeconds).add("internalQueryTimeoutSeconds", this.internalQueryTimeoutSeconds).add("version", (Object)this.version).toString();
    }

    @JsonCreator
    static AdvancedConfig readValue(@JsonProperty(value="timerWrapperMethods") @Nullable Boolean timerWrapperMethods, @JsonProperty(value="weavingTimer") @Nullable Boolean weavingTimer, @JsonProperty(value="immediatePartialStoreThresholdSeconds") @Nullable Integer immediatePartialStoreThresholdSeconds, @JsonProperty(value="maxAggregateQueriesPerQueryType") @Nullable Integer maxAggregateQueriesPerQueryType, @JsonProperty(value="maxTraceEntriesPerTransaction") @Nullable Integer maxTraceEntriesPerTransaction, @JsonProperty(value="maxStackTraceSamplesPerTransaction") @Nullable Integer maxStackTraceSamplesPerTransaction, @JsonProperty(value="captureThreadInfo") @Nullable Boolean captureThreadInfo, @JsonProperty(value="captureGcInfo") @Nullable Boolean captureGcInfo, @JsonProperty(value="mbeanGaugeNotFoundDelaySeconds") @Nullable Integer mbeanGaugeNotFoundDelaySeconds, @JsonProperty(value="internalQueryTimeoutSeconds") @Nullable Integer internalQueryTimeoutSeconds, @JsonProperty(value="version") @Nullable String version) throws JsonMappingException {
        ObjectMappers.checkRequiredProperty(timerWrapperMethods, "timerWrapperMethods");
        ObjectMappers.checkRequiredProperty(weavingTimer, "weavingTimer");
        ObjectMappers.checkRequiredProperty(immediatePartialStoreThresholdSeconds, "immediatePartialStoreThresholdSeconds");
        ObjectMappers.checkRequiredProperty(maxAggregateQueriesPerQueryType, "maxAggregateQueriesPerQueryType");
        ObjectMappers.checkRequiredProperty(maxTraceEntriesPerTransaction, "maxTraceEntriesPerTransaction");
        ObjectMappers.checkRequiredProperty(maxStackTraceSamplesPerTransaction, "maxStackTraceSamplesPerTransaction");
        ObjectMappers.checkRequiredProperty(captureThreadInfo, "captureThreadInfo");
        ObjectMappers.checkRequiredProperty(captureGcInfo, "captureGcInfo");
        ObjectMappers.checkRequiredProperty(mbeanGaugeNotFoundDelaySeconds, "mbeanGaugeNotFoundDelaySeconds");
        ObjectMappers.checkRequiredProperty(internalQueryTimeoutSeconds, "internalQueryTimeoutSeconds");
        ObjectMappers.checkRequiredProperty(version, "version");
        AdvancedConfig config = new AdvancedConfig(version);
        config.setTimerWrapperMethods(timerWrapperMethods);
        config.setWeavingTimer(weavingTimer);
        config.setImmediatePartialStoreThresholdSeconds(immediatePartialStoreThresholdSeconds);
        config.setMaxAggregateQueriesPerQueryType(maxAggregateQueriesPerQueryType);
        config.setMaxTraceEntriesPerTransaction(maxTraceEntriesPerTransaction);
        config.setMaxStackTraceSamplesPerTransaction(maxStackTraceSamplesPerTransaction);
        config.setCaptureThreadInfo(captureThreadInfo);
        config.setCaptureGcInfo(captureGcInfo);
        config.setMBeanGaugeNotFoundDelaySeconds(mbeanGaugeNotFoundDelaySeconds);
        config.setInternalQueryTimeoutSeconds(internalQueryTimeoutSeconds);
        return config;
    }
}

