/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class InstrumentationConfig {
    @Nullable
    private String className;
    @Nullable
    private String methodName;
    private ImmutableList<String> methodParameterTypes = ImmutableList.of();
    @Nullable
    private String methodReturnType;
    private ImmutableList<MethodModifier> methodModifiers = ImmutableList.of();
    @Nullable
    private CaptureKind captureKind;
    @Nullable
    private String timerName;
    @Nullable
    private String traceEntryTemplate;
    @Nullable
    private Long traceEntryStackThresholdMillis;
    private boolean traceEntryCaptureSelfNested;
    @Nullable
    private String transactionType;
    @Nullable
    private String transactionNameTemplate;
    @Nullable
    private String transactionUserTemplate;
    @Nullable
    private Map<String, String> transactionCustomAttributeTemplates = ImmutableMap.of();
    @Nullable
    private Long traceStoreThresholdMillis;
    @Nullable
    private String enabledProperty;
    @Nullable
    private String traceEntryEnabledProperty;
    @Nullable
    private final String version;

    public InstrumentationConfig() {
        this.version = null;
    }

    private InstrumentationConfig(String version) {
        this.version = version;
    }

    @Nullable
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Nullable
    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public ImmutableList<String> getMethodParameterTypes() {
        return this.methodParameterTypes;
    }

    public void setMethodParameterTypes(List<String> methodParameterTypes) {
        this.methodParameterTypes = ImmutableList.copyOf(methodParameterTypes);
    }

    @Nullable
    public String getMethodReturnType() {
        return this.methodReturnType;
    }

    public void setMethodReturnType(String methodReturnType) {
        this.methodReturnType = methodReturnType;
    }

    public ImmutableList<MethodModifier> getMethodModifiers() {
        return this.methodModifiers;
    }

    public void setMethodModifiers(List<MethodModifier> methodModifiers) {
        this.methodModifiers = ImmutableList.copyOf(methodModifiers);
    }

    @Nullable
    public CaptureKind getCaptureKind() {
        return this.captureKind;
    }

    public void setCaptureKind(CaptureKind captureKind) {
        this.captureKind = captureKind;
    }

    @Nullable
    public String getTimerName() {
        return this.timerName;
    }

    public void setTimerName(String timerName) {
        this.timerName = timerName;
    }

    @Nullable
    public String getTraceEntryTemplate() {
        return this.traceEntryTemplate;
    }

    public void setTraceEntryTemplate(String traceEntryTemplate) {
        this.traceEntryTemplate = traceEntryTemplate;
    }

    @Nullable
    public Long getTraceEntryStackThresholdMillis() {
        return this.traceEntryStackThresholdMillis;
    }

    public void setTraceEntryStackThresholdMillis(@Nullable Long traceEntryStackThresholdMillis) {
        this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
    }

    public boolean isTraceEntryCaptureSelfNested() {
        return this.traceEntryCaptureSelfNested;
    }

    public void setTraceEntryCaptureSelfNested(boolean traceEntryCaptureSelfNested) {
        this.traceEntryCaptureSelfNested = traceEntryCaptureSelfNested;
    }

    @Nullable
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    @Nullable
    public String getTransactionNameTemplate() {
        return this.transactionNameTemplate;
    }

    public void setTransactionNameTemplate(String transactionNameTemplate) {
        this.transactionNameTemplate = transactionNameTemplate;
    }

    @Nullable
    public String getTransactionUserTemplate() {
        return this.transactionUserTemplate;
    }

    public void setTransactionUserTemplate(String transactionUserTemplate) {
        this.transactionUserTemplate = transactionUserTemplate;
    }

    @Nullable
    public Map<String, String> getTransactionCustomAttributeTemplates() {
        return this.transactionCustomAttributeTemplates;
    }

    public void setTransactionCustomAttributeTemplates(Map<String, String> transactionCustomAttributeTemplates) {
        this.transactionCustomAttributeTemplates = transactionCustomAttributeTemplates;
    }

    @Nullable
    public Long getTraceStoreThresholdMillis() {
        return this.traceStoreThresholdMillis;
    }

    public void setTraceStoreThresholdMillis(@Nullable Long traceStoreThresholdMillis) {
        this.traceStoreThresholdMillis = traceStoreThresholdMillis;
    }

    @Nullable
    public String getEnabledProperty() {
        return this.enabledProperty;
    }

    public void setEnabledProperty(String enabledProperty) {
        this.enabledProperty = enabledProperty;
    }

    @Nullable
    public String getTraceEntryEnabledProperty() {
        return this.traceEntryEnabledProperty;
    }

    public void setTraceEntryEnabledProperty(String traceEntryEnabledProperty) {
        this.traceEntryEnabledProperty = traceEntryEnabledProperty;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof InstrumentationConfig) {
            InstrumentationConfig that = (InstrumentationConfig)obj;
            return Objects.equal((Object)this.className, (Object)that.className) && Objects.equal((Object)this.methodName, (Object)that.methodName) && Objects.equal(this.methodParameterTypes, that.methodParameterTypes) && Objects.equal((Object)this.methodReturnType, (Object)that.methodReturnType) && Objects.equal(this.methodModifiers, that.methodModifiers) && Objects.equal((Object)((Object)this.captureKind), (Object)((Object)that.captureKind)) && Objects.equal((Object)this.timerName, (Object)that.timerName) && Objects.equal((Object)this.traceEntryTemplate, (Object)that.traceEntryTemplate) && Objects.equal((Object)this.traceEntryStackThresholdMillis, (Object)that.traceEntryStackThresholdMillis) && Objects.equal((Object)this.traceEntryCaptureSelfNested, (Object)that.traceEntryCaptureSelfNested) && Objects.equal((Object)this.transactionType, (Object)that.transactionType) && Objects.equal((Object)this.transactionNameTemplate, (Object)that.transactionNameTemplate) && Objects.equal((Object)this.transactionUserTemplate, (Object)that.transactionUserTemplate) && Objects.equal(this.transactionCustomAttributeTemplates, that.transactionCustomAttributeTemplates) && Objects.equal((Object)this.traceStoreThresholdMillis, (Object)that.traceStoreThresholdMillis) && Objects.equal((Object)this.enabledProperty, (Object)that.enabledProperty) && Objects.equal((Object)this.traceEntryEnabledProperty, (Object)that.traceEntryEnabledProperty);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("className", (Object)this.className).add("methodName", (Object)this.methodName).add("methodParameterTypes", this.methodParameterTypes).add("methodReturnType", (Object)this.methodReturnType).add("methodModifiers", this.methodModifiers).add("captureKind", (Object)this.captureKind).add("timerName", (Object)this.timerName).add("traceEntryTemplate", (Object)this.traceEntryTemplate).add("traceEntryStackThresholdMillis", (Object)this.traceEntryStackThresholdMillis).add("traceEntryCaptureSelfNested", this.traceEntryCaptureSelfNested).add("transactionType", (Object)this.transactionType).add("transactionNameTemplate", (Object)this.transactionNameTemplate).add("transactionUserTemplate", (Object)this.transactionUserTemplate).add("transactionCustomAttributeTemplates", this.transactionCustomAttributeTemplates).add("traceStoreThresholdMillis", (Object)this.traceStoreThresholdMillis).add("enabledProperty", (Object)this.enabledProperty).add("traceEntryEnabledProperty", (Object)this.traceEntryEnabledProperty).add("version", (Object)this.version).toString();
    }

    @JsonCreator
    static InstrumentationConfig readValue(@JsonProperty(value="className") @Nullable String className, @JsonProperty(value="methodName") @Nullable String methodName, @JsonProperty(value="methodParameterTypes") @Nullable List<String> uncheckedMethodParameterTypes, @JsonProperty(value="methodReturnType") @Nullable String methodReturnType, @JsonProperty(value="methodModifiers") @Nullable List<MethodModifier> uncheckedMethodModifiers, @JsonProperty(value="captureKind") @Nullable CaptureKind captureKind, @JsonProperty(value="timerName") @Nullable String timerName, @JsonProperty(value="traceEntryTemplate") @Nullable String traceEntryTemplate, @JsonProperty(value="traceEntryStackThresholdMillis") @Nullable Long traceEntryStackThresholdMillis, @JsonProperty(value="traceEntryCaptureSelfNested") @Nullable Boolean traceEntryCaptureSelfNested, @JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="transactionNameTemplate") @Nullable String transactionNameTemplate, @JsonProperty(value="transactionUserTemplate") @Nullable String transactionUserTemplate, @JsonProperty(value="transactionCustomAttributeTemplates") @Nullable Map<String, String> uncheckedTransactionCustomAttributeTemplates, @JsonProperty(value="traceStoreThresholdMillis") @Nullable Long traceStoreThresholdMillis, @JsonProperty(value="enabledProperty") @Nullable String enabledProperty, @JsonProperty(value="traceEntryEnabledProperty") @Nullable String traceEntryEnabledProperty, @JsonProperty(value="version") @Nullable String version) throws JsonMappingException {
        ObjectMappers.checkRequiredProperty(uncheckedMethodParameterTypes, "methodParameterTypes");
        List<String> methodParameterTypes = ObjectMappers.orEmpty(uncheckedMethodParameterTypes, "methodParameterTypes");
        List<MethodModifier> methodModifiers = ObjectMappers.orEmpty(uncheckedMethodModifiers, "methodModifiers");
        Map<String, String> transactionCustomAttributeTemplates = ObjectMappers.checkNotNullValuesForProperty(uncheckedTransactionCustomAttributeTemplates, "transactionCustomAttributeTemplates");
        ObjectMappers.checkRequiredProperty(className, "className");
        ObjectMappers.checkRequiredProperty(methodName, "methodName");
        ObjectMappers.checkRequiredProperty(methodReturnType, "methodReturnType");
        ObjectMappers.checkRequiredProperty(captureKind, "captureKind");
        ObjectMappers.checkRequiredProperty(timerName, "timerName");
        ObjectMappers.checkRequiredProperty(traceEntryTemplate, "traceEntryTemplate");
        ObjectMappers.checkRequiredProperty(traceEntryCaptureSelfNested, "traceEntryCaptureSelfNested");
        ObjectMappers.checkRequiredProperty(transactionType, "transactionType");
        ObjectMappers.checkRequiredProperty(transactionNameTemplate, "transactionNameTemplate");
        ObjectMappers.checkRequiredProperty(transactionUserTemplate, "transactionUserTemplate");
        ObjectMappers.checkRequiredProperty(transactionCustomAttributeTemplates, "transactionCustomAttributeTemplates");
        ObjectMappers.checkRequiredProperty(enabledProperty, "enabledProperty");
        ObjectMappers.checkRequiredProperty(traceEntryEnabledProperty, "traceEntryEnabledProperty");
        ObjectMappers.checkRequiredProperty(version, "version");
        InstrumentationConfig config = new InstrumentationConfig(version);
        config.setClassName(className);
        config.setMethodName(methodName);
        config.setMethodParameterTypes(methodParameterTypes);
        config.setMethodReturnType(methodReturnType);
        config.setMethodModifiers(methodModifiers);
        config.setCaptureKind(captureKind);
        config.setTimerName(timerName);
        config.setTraceEntryTemplate(traceEntryTemplate);
        config.setTraceEntryStackThresholdMillis(traceEntryStackThresholdMillis);
        config.setTraceEntryCaptureSelfNested(traceEntryCaptureSelfNested);
        config.setTransactionType(transactionType);
        config.setTransactionNameTemplate(transactionNameTemplate);
        config.setTransactionUserTemplate(transactionUserTemplate);
        config.setTransactionCustomAttributeTemplates(transactionCustomAttributeTemplates);
        config.setTraceStoreThresholdMillis(traceStoreThresholdMillis);
        config.setEnabledProperty(enabledProperty);
        config.setTraceEntryEnabledProperty(traceEntryEnabledProperty);
        return config;
    }

    public static enum CaptureKind {
        TIMER,
        TRACE_ENTRY,
        TRANSACTION,
        OTHER;

    }

    public static enum MethodModifier {
        PUBLIC,
        PRIVATE,
        PROTECTED,
        PACKAGE_PRIVATE,
        STATIC,
        NOT_STATIC,
        ABSTRACT;

    }
}

