/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class PluginConfig {
    private boolean enabled;
    private final Map<String, Object> properties = Maps.newHashMap();
    private final String version;

    private PluginConfig(String version) {
        this.version = version;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Nullable
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, @Nullable Object value) {
        this.properties.put(name, value);
    }

    @JsonProperty
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PluginConfig) {
            PluginConfig that = (PluginConfig)obj;
            return Objects.equal((Object)this.enabled, (Object)that.enabled) && Objects.equal(this.properties, that.properties);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enabled, this.properties});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enabled", this.enabled).add("properties", this.properties).add("version", (Object)this.version).toString();
    }

    @JsonCreator
    static PluginConfig readValue(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="properties") @Nullable Map<String, Object> properties, @JsonProperty(value="version") @Nullable String version) throws JsonMappingException {
        ObjectMappers.checkRequiredProperty(enabled, "enabled");
        ObjectMappers.checkRequiredProperty(properties, "properties");
        ObjectMappers.checkRequiredProperty(version, "version");
        PluginConfig config = new PluginConfig(version);
        config.setEnabled(enabled);
        config.properties.putAll(properties);
        return config;
    }
}

