/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.impl;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.glowroot.common.ClassNames;

public class DelegatingJavaagent {
    private static final String DELEGATE_JAVA_AGENT_PROPERTY = "delegateJavaagent";

    private DelegatingJavaagent() {
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) throws Exception {
        String delegateJavaagent = System.getProperty(DELEGATE_JAVA_AGENT_PROPERTY);
        if (delegateJavaagent == null) {
            throw new IllegalStateException("System property 'delegateJavaagent' is not set");
        }
        Class<?> delegateClass = Class.forName(delegateJavaagent);
        Method delegateMethod = delegateClass.getMethod("premain", String.class, Instrumentation.class);
        delegateMethod.invoke(null, agentArgs, instrumentation);
    }

    static File createDelegatingJavaagentJarFile(File dir) throws Exception {
        File jarFile = File.createTempFile("glowroot-", ".jar", dir);
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(new Attributes.Name("Premain-Class"), DelegatingJavaagent.class.getName());
        manifest.getMainAttributes().put(new Attributes.Name("Can-Redefine-Classes"), "true");
        manifest.getMainAttributes().put(new Attributes.Name("Can-Retransform-Classes"), "true");
        JarOutputStream out = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
        String resourceName = ClassNames.toInternalName(DelegatingJavaagent.class.getName()) + ".class";
        out.putNextEntry(new JarEntry(resourceName));
        Resources.asByteSource((URL)Resources.getResource((String)resourceName)).copyTo((OutputStream)out);
        out.closeEntry();
        out.close();
        return jarFile;
    }
}

