/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.GlowrootModule;
import org.glowroot.MainEntryPoint;
import org.glowroot.common.MessageCount;
import org.glowroot.common.SpyingLogbackFilter;
import org.glowroot.container.AppUnderTest;
import org.glowroot.container.AppUnderTestServices;
import org.glowroot.container.Container;
import org.glowroot.container.TempDirs;
import org.glowroot.container.admin.AdminService;
import org.glowroot.container.aggregate.AggregateService;
import org.glowroot.container.common.HttpClient;
import org.glowroot.container.config.ConfigService;
import org.glowroot.container.impl.JavaagentMain;
import org.glowroot.container.trace.TraceService;
import org.glowroot.transaction.AdviceCache;
import org.glowroot.weaving.IsolatedWeavingClassLoader;

public class LocalContainer
implements Container {
    private final File dataDir;
    private final boolean deleteDataDirOnClose;
    private final boolean shared;
    private final IsolatedWeavingClassLoader isolatedWeavingClassLoader;
    private final HttpClient httpClient;
    private final ConfigService configService;
    private final TraceService traceService;
    private final AggregateService aggregateService;
    private final AdminService adminService;
    private final List<Thread> executingAppThreads = Lists.newCopyOnWriteArrayList();
    private final GlowrootModule glowrootModule;

    public static Container createWithFileDb(File dataDir) throws Exception {
        return new LocalContainer(dataDir, true, 0, false, (Map<String, String>)ImmutableMap.of());
    }

    public LocalContainer(@Nullable File dataDir, boolean useFileDb, int port, boolean shared, Map<String, String> extraProperties) throws Exception {
        if (dataDir == null) {
            this.dataDir = TempDirs.createTempDir("glowroot-test-datadir");
            this.deleteDataDirOnClose = true;
        } else {
            this.dataDir = dataDir;
            this.deleteDataDirOnClose = false;
        }
        this.shared = shared;
        File configFile = new File(this.dataDir, "config.json");
        if (!configFile.exists()) {
            Files.write((CharSequence)("{\"ui\":{\"port\":" + port + "}}"), (File)configFile, (Charset)Charsets.UTF_8);
        }
        HashMap properties = Maps.newHashMap();
        properties.put("data.dir", this.dataDir.getAbsolutePath());
        properties.put("internal.logging.spy", "true");
        if (!useFileDb) {
            properties.put("internal.h2.memdb", "true");
        }
        properties.putAll(extraProperties);
        try {
            MainEntryPoint.start(properties);
        }
        catch (GlowrootModule.StartupFailedException e) {
            throw new Container.StartupFailedException(e);
        }
        JavaagentMain.setTraceStoreThresholdMillisToZero();
        final GlowrootModule glowrootModule = MainEntryPoint.getGlowrootModule();
        Preconditions.checkNotNull((Object)glowrootModule);
        IsolatedWeavingClassLoader.Builder loader = IsolatedWeavingClassLoader.builder();
        AdviceCache adviceCache = glowrootModule.getTransactionModule().getAdviceCache();
        loader.setShimTypes(adviceCache.getShimTypes());
        loader.setMixinTypes(adviceCache.getMixinTypes());
        ArrayList advisors = Lists.newArrayList();
        advisors.addAll(adviceCache.getAdvisors());
        loader.setAdvisors(advisors);
        loader.setWeavingTimerService(glowrootModule.getTransactionModule().getWeavingTimerService());
        loader.setTimerWrapperMethods(glowrootModule.getConfigModule().getConfigService().getAdvancedConfig().timerWrapperMethods());
        loader.addBridgeClasses(AppUnderTest.class, AppUnderTestServices.class);
        loader.addExcludePackages("org.glowroot.api", "org.glowroot.advicegen", "org.glowroot.collector", "org.glowroot.common", "org.glowroot.config", "org.glowroot.jvm", "org.glowroot.local", "org.glowroot.shaded", "org.glowroot.transaction", "org.glowroot.weaving", "com.google.common");
        this.isolatedWeavingClassLoader = loader.build();
        this.httpClient = new HttpClient(glowrootModule.getUiModule().getPort());
        this.configService = new ConfigService(this.httpClient, new ConfigService.GetUiPortCommand(){

            @Override
            public int getUiPort() throws Exception {
                Preconditions.checkNotNull((Object)glowrootModule);
                return glowrootModule.getUiModule().getPort();
            }
        });
        this.traceService = new TraceService(this.httpClient);
        this.aggregateService = new AggregateService(this.httpClient);
        this.adminService = new AdminService(this.httpClient);
        this.glowrootModule = glowrootModule;
    }

    @Override
    public ConfigService getConfigService() {
        return this.configService;
    }

    @Override
    public void addExpectedLogMessage(String loggerName, String partialMessage) {
        SpyingLogbackFilter.addExpectedMessage(loggerName, partialMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAppUnderTest(Class<? extends AppUnderTest> appClass) throws Exception {
        ClassLoader previousContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.isolatedWeavingClassLoader);
        this.executingAppThreads.add(Thread.currentThread());
        try {
            AppUnderTest app = this.isolatedWeavingClassLoader.newInstance(appClass, AppUnderTest.class);
            app.executeApp();
        }
        finally {
            this.executingAppThreads.remove(Thread.currentThread());
            Thread.currentThread().setContextClassLoader(previousContextClassLoader);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (this.adminService.getNumPendingCompleteTransactions() > 0 && stopwatch.elapsed(TimeUnit.SECONDS) < 5L) {
            Thread.sleep(10L);
        }
    }

    @Override
    public void interruptAppUnderTest() throws Exception {
        for (Thread thread : this.executingAppThreads) {
            thread.interrupt();
        }
    }

    @Override
    public TraceService getTraceService() {
        return this.traceService;
    }

    @Override
    public AggregateService getAggregateService() {
        return this.aggregateService;
    }

    @Override
    public AdminService getAdminService() {
        return this.adminService;
    }

    @Override
    public int getUiPort() throws InterruptedException {
        return this.glowrootModule.getUiModule().getPort();
    }

    @Override
    public void checkAndReset() throws Exception {
        this.traceService.assertNoActiveTransactions();
        this.adminService.deleteAllData();
        this.checkAndResetConfigOnly();
    }

    @Override
    public void checkAndResetConfigOnly() throws Exception {
        this.configService.resetAllConfig();
        this.configService.setTraceStoreThresholdMillis(0);
        MessageCount logMessageCount = SpyingLogbackFilter.clearMessages();
        if (logMessageCount.expectedCount() > 0) {
            throw new AssertionError((Object)"One or more expected messages were not logged");
        }
        if (logMessageCount.unexpectedCount() > 0) {
            throw new AssertionError((Object)"One or more unexpected messages were logged");
        }
    }

    @Override
    public void close() throws Exception {
        this.close(false);
    }

    @Override
    public void close(boolean evenIfShared) throws Exception {
        if (this.shared && !evenIfShared) {
            return;
        }
        this.httpClient.close();
        this.glowrootModule.close();
        if (this.deleteDataDirOnClose) {
            TempDirs.deleteRecursively(this.dataDir);
        }
    }

    public void reopen() {
        MainEntryPoint.reopen(this.glowrootModule);
    }
}

