/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.trace;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.container.common.HttpClient;
import org.glowroot.container.common.ObjectMappers;
import org.glowroot.container.trace.ProfileNode;
import org.glowroot.container.trace.Trace;
import org.glowroot.container.trace.TraceEntry;
import org.glowroot.container.trace.TracePointResponse;
import org.glowroot.container.trace.TraceQuery;

public class TraceService {
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final HttpClient httpClient;

    public TraceService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public InputStream getTraceExport(String traceId) throws Exception {
        return this.httpClient.getAsStream("/export/trace/" + traceId);
    }

    @Nullable
    public Trace getLastTrace() throws Exception {
        String content = this.httpClient.get("/backend/trace/points?from=0&to=9223372036854775807&duration-low=0&limit=1000");
        TracePointResponse response = ObjectMappers.readRequiredValue(mapper, content, TracePointResponse.class);
        ArrayList points = Lists.newArrayList();
        points.addAll(response.getNormalPoints());
        points.addAll(response.getErrorPoints());
        if (points.isEmpty()) {
            return null;
        }
        TracePointResponse.RawPoint mostRecentCapturedPoint = (TracePointResponse.RawPoint)TracePointResponse.RawPoint.orderingByCaptureTime.max((Iterable)points);
        return this.getTrace(mostRecentCapturedPoint.getId());
    }

    @Nullable
    public Trace getActiveTrace(int timeout, TimeUnit unit) throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Trace trace = null;
        boolean first = true;
        while ((first || stopwatch.elapsed(unit) < (long)timeout) && (trace = this.getActiveTrace()) == null) {
            Thread.sleep(20L);
            first = false;
        }
        return trace;
    }

    public List<Trace> getTraces(TraceQuery query) throws Exception {
        String transactionType;
        StringBuilder sb = new StringBuilder();
        sb.append("from=");
        sb.append(query.from());
        sb.append("&to=");
        sb.append(query.to());
        sb.append("&duration-low=");
        sb.append(query.durationLow());
        Long durationHigh = query.durationHigh();
        if (durationHigh != null) {
            sb.append("&duration-high=");
            sb.append(durationHigh);
        }
        if ((transactionType = query.transactionType()) != null) {
            sb.append("&transaction-type=");
            sb.append(transactionType);
        }
        if (query.transactionName() != null) {
            sb.append("&transaction-name-comparator=");
            sb.append((Object)query.transactionNameComparator());
            sb.append("&transaction-name=");
            sb.append(query.transactionName());
        }
        if (query.headline() != null) {
            sb.append("&headline-comparator=");
            sb.append((Object)query.headlineComparator());
            sb.append("&headline=");
            sb.append(query.headline());
        }
        if (query.error() != null) {
            sb.append("&error-comparator=");
            sb.append((Object)query.errorComparator());
            sb.append("&error=");
            sb.append(query.error());
        }
        if (query.user() != null) {
            sb.append("&user-comparator=");
            sb.append((Object)query.userComparator());
            sb.append("&user=");
            sb.append(query.user());
        }
        if (query.customAttributeName() != null) {
            sb.append("&custom-attribute-name=");
            sb.append(query.customAttributeName());
            if (query.customAttributeValue() != null) {
                sb.append("&custom-attribute-value-comparator=");
                sb.append((Object)query.customAttributeValueComparator());
                sb.append("&custom-attribute-value=");
                sb.append(query.customAttributeValue());
            }
        }
        sb.append("&error-only=");
        sb.append(query.errorOnly());
        sb.append("&limit=");
        sb.append(query.limit());
        String content = this.httpClient.get("/backend/trace/points?" + sb.toString());
        TracePointResponse response = ObjectMappers.readRequiredValue(mapper, content, TracePointResponse.class);
        ArrayList traces = Lists.newArrayList();
        for (TracePointResponse.RawPoint point : response.getNormalPoints()) {
            traces.add(this.getTrace(point.getId()));
        }
        for (TracePointResponse.RawPoint point : response.getErrorPoints()) {
            traces.add(this.getTrace(point.getId()));
        }
        for (TracePointResponse.RawPoint point : response.getActivePoints()) {
            traces.add(this.getTrace(point.getId()));
        }
        return traces;
    }

    public List<TraceEntry> getEntries(String traceId) throws Exception {
        String content = this.httpClient.get("/backend/trace/entries?trace-id=" + traceId);
        return (List)mapper.readValue(content, (TypeReference)new TypeReference<List<TraceEntry>>(){});
    }

    public ProfileNode getProfile(String traceId) throws Exception {
        String content = this.httpClient.get("/backend/trace/profile?trace-id=" + traceId);
        return (ProfileNode)mapper.readValue(content, ProfileNode.class);
    }

    public void assertNoActiveTransactions() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (stopwatch.elapsed(TimeUnit.SECONDS) < 2L) {
            int numActiveTransactions = Integer.parseInt(this.httpClient.get("/backend/admin/num-active-transactions"));
            if (numActiveTransactions != 0) continue;
            return;
        }
        throw new AssertionError((Object)"There are still active transactions");
    }

    @Nullable
    private Trace getActiveTrace() throws Exception {
        String content = this.httpClient.get("/backend/trace/points?from=0&to=9223372036854775807&duration-low=0&limit=1000");
        TracePointResponse response = ObjectMappers.readRequiredValue(mapper, content, TracePointResponse.class);
        if (response.getActivePoints().isEmpty()) {
            return null;
        }
        if (response.getActivePoints().size() > 1) {
            throw new IllegalStateException("Unexpected number of active traces");
        }
        TracePointResponse.RawPoint point = response.getActivePoints().get(0);
        return this.getTrace(point.getId());
    }

    private Trace getTrace(String traceId) throws Exception {
        String traceContent = this.httpClient.get("/backend/trace/header/" + traceId);
        return ObjectMappers.readRequiredValue(mapper, traceContent, Trace.class);
    }
}

