/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.glowroot.common.ChunkSource;
import org.glowroot.local.store.CappedDatabaseOutputStream;
import org.glowroot.local.store.CappedDatabaseStatsMXBean;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.base.Charsets;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.io.CharSource;
import org.glowroot.shaded.google.common.io.CountingOutputStream;
import org.glowroot.shaded.google.common.primitives.Longs;
import org.glowroot.shaded.ning.compress.lzf.LZFInputStream;
import org.glowroot.shaded.ning.compress.lzf.LZFOutputStream;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class CappedDatabase {
    private static final Logger logger = LoggerFactory.getLogger(CappedDatabase.class);
    private final File file;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final CappedDatabaseOutputStream out;
    private final Thread shutdownHookThread;
    @GuardedBy(value="lock")
    private RandomAccessFile inFile;
    private volatile boolean closing = false;
    private final Ticker ticker;
    private final Map<String, CappedDatabaseStatsMXBean.Stats> statsByType = Maps.newHashMap();

    CappedDatabase(File file, int requestedSizeKb, Ticker ticker) throws IOException {
        this.file = file;
        this.ticker = ticker;
        this.out = new CappedDatabaseOutputStream(file, requestedSizeKb);
        this.inFile = new RandomAccessFile(file, "r");
        this.shutdownHookThread = new ShutdownHookThread();
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
    }

    long write(final CharSource charSource, String type) throws IOException {
        return this.write(type, new Copier(){

            @Override
            public void copyTo(Writer writer) throws IOException {
                charSource.copyTo(writer);
            }
        });
    }

    long write(final ChunkSource charSource, String type) throws IOException {
        return this.write(type, new Copier(){

            @Override
            public void copyTo(Writer writer) throws IOException {
                charSource.copyTo(writer);
            }
        });
    }

    CappedDatabaseStatsMXBean.Stats getStats(String type) {
        CappedDatabaseStatsMXBean.Stats stats = this.statsByType.get(type);
        if (stats == null) {
            return new CappedDatabaseStatsMXBean.Stats();
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long write(String type, Copier copier) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return -1L;
            }
            long startTick = this.ticker.read();
            this.out.startBlock();
            NonClosingCountingOutputStream countingStreamAfterCompression = new NonClosingCountingOutputStream(this.out);
            CountingOutputStream countingStreamBeforeCompression = new CountingOutputStream(new LZFOutputStream(countingStreamAfterCompression));
            OutputStreamWriter compressedWriter = new OutputStreamWriter((OutputStream)countingStreamBeforeCompression, Charsets.UTF_8);
            copier.copyTo(compressedWriter);
            ((Writer)compressedWriter).close();
            long endTick = this.ticker.read();
            CappedDatabaseStatsMXBean.Stats stats = this.statsByType.get(type);
            if (stats == null) {
                stats = new CappedDatabaseStatsMXBean.Stats();
                this.statsByType.put(type, stats);
            }
            stats.record(countingStreamBeforeCompression.getCount(), countingStreamAfterCompression.getCount(), TimeUnit.NANOSECONDS.toMicros(endTick - startTick));
            return this.out.endBlock();
        }
    }

    CharSource read(long cappedId, String overwrittenResponse) {
        if (cappedId >= this.out.getCurrIndex()) {
            return CharSource.wrap(overwrittenResponse);
        }
        return new CappedBlockCharSource(cappedId, overwrittenResponse);
    }

    boolean isExpired(long cappedId) {
        return this.out.isOverwritten(cappedId);
    }

    long getSmallestNonExpiredId() {
        return this.out.getSmallestNonOverwrittenId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int newSizeKb) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closing) {
                return;
            }
            this.inFile.close();
            this.out.resize(newSizeKb);
            this.inFile = new RandomAccessFile(this.file, "r");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyUsedByTests
    void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.closing = true;
            this.out.close();
            this.inFile.close();
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
    }

    private static class NonClosingCountingOutputStream
    extends FilterOutputStream {
        private long count;

        private NonClosingCountingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.count += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.count;
        }

        @Override
        public void close() {
        }

        private long getCount() {
            return this.count;
        }
    }

    private static interface Copier {
        public void copyTo(Writer var1) throws IOException;
    }

    private class ShutdownHookThread
    extends Thread {
        private ShutdownHookThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CappedDatabase.this.closing = true;
                Object object = CappedDatabase.this.lock;
                synchronized (object) {
                    CappedDatabase.this.out.close();
                    CappedDatabase.this.inFile.close();
                }
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), e);
            }
        }
    }

    private class CappedBlockInputStream
    extends InputStream {
        private final long cappedId;
        private long blockLength = -1L;
        private long blockIndex;

        private CappedBlockInputStream(long cappedId) {
            this.cappedId = cappedId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (this.blockIndex == this.blockLength) {
                return -1;
            }
            Object object = CappedDatabase.this.lock;
            synchronized (object) {
                long filePosition;
                if (CappedDatabase.this.out.isOverwritten(this.cappedId)) {
                    throw new IOException("Block rolled over mid-read");
                }
                if (this.blockLength == -1L) {
                    filePosition = CappedDatabase.this.out.convertToFilePosition(this.cappedId);
                    CappedDatabase.this.inFile.seek(20L + filePosition);
                    this.blockLength = CappedDatabase.this.inFile.readLong();
                }
                filePosition = CappedDatabase.this.out.convertToFilePosition(this.cappedId + 8L + this.blockIndex);
                CappedDatabase.this.inFile.seek(20L + filePosition);
                long blockRemaining = this.blockLength - this.blockIndex;
                long fileRemaining = (long)CappedDatabase.this.out.getSizeKb() * 1024L - filePosition;
                int numToRead = (int)Longs.min(len, blockRemaining, fileRemaining);
                CappedDatabase.this.inFile.readFully(bytes, off, numToRead);
                this.blockIndex += (long)numToRead;
                return numToRead;
            }
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("CappedBlockInputStream should always be wrapped in a BufferedInputStream");
        }
    }

    private class CappedBlockCharSource
    extends CharSource {
        private final long cappedId;
        private final String overwrittenResponse;

        private CappedBlockCharSource(long cappedId, String overwrittenResponse) {
            this.cappedId = cappedId;
            this.overwrittenResponse = overwrittenResponse;
        }

        @Override
        public Reader openStream() throws IOException {
            if (CappedDatabase.this.out.isOverwritten(this.cappedId)) {
                return CharSource.wrap(this.overwrittenResponse).openStream();
            }
            int bufferSize = 32768;
            return new InputStreamReader((InputStream)new LZFInputStream(new BufferedInputStream(new CappedBlockInputStream(this.cappedId), 32768)), Charsets.UTF_8);
        }
    }
}

