/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.glowroot.markers.OnlyUsedByTests;

class CappedDatabaseOutputStream
extends OutputStream {
    static final int HEADER_SKIP_BYTES = 20;
    static final int BLOCK_HEADER_SKIP_BYTES = 8;
    private static final int HEADER_CURR_INDEX_POS = 0;
    private final File file;
    private RandomAccessFile out;
    private long currIndex;
    private long lastResizeBaseIndex;
    private volatile int sizeKb;
    private long sizeBytes;
    private long blockStartIndex;
    private long blockStartPosition;

    CappedDatabaseOutputStream(File file, int requestedSizeKb) throws IOException {
        this.file = file;
        boolean newFile = !file.exists() || file.length() == 0L;
        this.out = new RandomAccessFile(file, "rw");
        if (newFile) {
            this.currIndex = 0L;
            this.sizeKb = requestedSizeKb;
            this.sizeBytes = (long)this.sizeKb * 1024L;
            this.lastResizeBaseIndex = 0L;
            this.out.writeLong(this.currIndex);
            this.out.writeInt(this.sizeKb);
            this.out.writeLong(this.lastResizeBaseIndex);
        } else {
            this.currIndex = this.out.readLong();
            this.sizeKb = this.out.readInt();
            this.sizeBytes = (long)this.sizeKb * 1024L;
            this.lastResizeBaseIndex = this.out.readLong();
        }
    }

    void startBlock() {
        long currPosition = (this.currIndex - this.lastResizeBaseIndex) % this.sizeBytes;
        long remainingBytes = this.sizeBytes - currPosition;
        if (remainingBytes < 8L) {
            this.currIndex += remainingBytes;
        }
        this.blockStartIndex = this.currIndex;
        this.blockStartPosition = (this.currIndex - this.lastResizeBaseIndex) % this.sizeBytes;
        this.currIndex += 8L;
    }

    long endBlock() throws IOException {
        this.out.seek(20L + this.blockStartPosition);
        this.out.writeLong(this.currIndex - this.blockStartIndex - 8L);
        this.out.getFD().sync();
        return this.blockStartIndex;
    }

    boolean isOverwritten(long cappedId) {
        return cappedId < this.getSmallestNonOverwrittenId();
    }

    long getSmallestNonOverwrittenId() {
        return Math.max(this.lastResizeBaseIndex, this.currIndex - this.sizeBytes);
    }

    long getCurrIndex() {
        return this.currIndex;
    }

    int getSizeKb() {
        return this.sizeKb;
    }

    long convertToFilePosition(long index) {
        return (index - this.lastResizeBaseIndex) % this.sizeBytes;
    }

    void resize(int newSizeKb) throws IOException {
        if (this.performEasyResize(newSizeKb)) {
            return;
        }
        long newSizeBytes = (long)newSizeKb * 1024L;
        int numKeepKb = Math.min(this.sizeKb, newSizeKb);
        long numKeepBytes = (long)numKeepKb * 1024L;
        long startPosition = this.convertToFilePosition(this.currIndex - numKeepBytes);
        this.lastResizeBaseIndex = this.currIndex - numKeepBytes;
        File tmpCappedFile = new File(this.file.getPath() + ".resizing.tmp");
        RandomAccessFile tmpOut = new RandomAccessFile(tmpCappedFile, "rw");
        tmpOut.writeLong(this.currIndex);
        tmpOut.writeInt(newSizeKb);
        tmpOut.writeLong(this.lastResizeBaseIndex);
        long remaining = this.sizeBytes - startPosition;
        this.out.seek(20L + startPosition);
        if (numKeepBytes > remaining) {
            CappedDatabaseOutputStream.copy(this.out, tmpOut, remaining);
            this.out.seek(20L);
            CappedDatabaseOutputStream.copy(this.out, tmpOut, numKeepBytes - remaining);
        } else {
            CappedDatabaseOutputStream.copy(this.out, tmpOut, numKeepBytes);
        }
        this.out.close();
        tmpOut.close();
        if (!this.file.delete()) {
            throw new IOException("Unable to delete existing capped database during resize");
        }
        if (!tmpCappedFile.renameTo(this.file)) {
            throw new IOException("Unable to rename new capped database during resize");
        }
        this.sizeKb = newSizeKb;
        this.sizeBytes = newSizeBytes;
        this.out = new RandomAccessFile(this.file, "rw");
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.currIndex + (long)len - this.blockStartIndex > this.sizeBytes) {
            throw new IOException("A single block cannot have more bytes than size of the capped database");
        }
        long currPosition = (this.currIndex - this.lastResizeBaseIndex) % this.sizeBytes;
        this.out.seek(20L + currPosition);
        long remaining = this.sizeBytes - currPosition;
        if ((long)len >= remaining) {
            this.out.write(b, off, (int)remaining);
            this.out.seek(20L);
            this.out.write(b, (int)remaining, (int)((long)len - remaining));
        } else {
            this.out.write(b, off, len);
        }
        this.currIndex += (long)len;
        this.out.seek(0L);
        this.out.writeLong(this.currIndex);
    }

    private boolean performEasyResize(int newSizeKb) throws IOException {
        if (newSizeKb == this.sizeKb) {
            return true;
        }
        long newSizeBytes = (long)newSizeKb * 1024L;
        if (newSizeKb < this.sizeKb && this.currIndex - this.lastResizeBaseIndex < newSizeBytes) {
            this.out.seek(8L);
            this.out.writeInt(newSizeKb);
            this.sizeKb = newSizeKb;
            this.sizeBytes = newSizeBytes;
            return true;
        }
        if (newSizeKb > this.sizeKb && this.currIndex - this.lastResizeBaseIndex < this.sizeBytes) {
            this.out.seek(8L);
            this.out.writeInt(newSizeKb);
            this.sizeKb = newSizeKb;
            this.sizeBytes = newSizeBytes;
            return true;
        }
        return false;
    }

    @OnlyUsedByTests
    void sync() throws IOException {
        this.out.getFD().sync();
    }

    private static void copy(RandomAccessFile in, RandomAccessFile out, long numBytes) throws IOException {
        int n;
        byte[] block = new byte[1024];
        for (long total = 0L; total < numBytes; total += (long)n) {
            n = in.read(block, 0, (int)Math.min(1024L, numBytes - total));
            out.write(block, 0, n);
        }
    }
}

