/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.store.ErrorMessageCountBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class ErrorMessageCount
extends ErrorMessageCountBase {
    private final String message;
    private final long count;

    private ErrorMessageCount(Builder builder) {
        this.message = builder.message;
        this.count = builder.count;
    }

    private ErrorMessageCount(ErrorMessageCount original, String message, long count) {
        this.message = message;
        this.count = count;
    }

    @Override
    @JsonProperty(value="message")
    public String message() {
        return this.message;
    }

    @Override
    @JsonProperty(value="count")
    public long count() {
        return this.count;
    }

    public final ErrorMessageCount withMessage(String value) {
        if (this.message == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ErrorMessageCount(this, newValue, this.count);
    }

    public final ErrorMessageCount withCount(long value) {
        if (this.count == value) {
            return this;
        }
        long newValue = value;
        return new ErrorMessageCount(this, this.message, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ErrorMessageCount && this.equalTo((ErrorMessageCount)another);
    }

    private boolean equalTo(ErrorMessageCount another) {
        return this.message.equals(another.message) && this.count == another.count;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.message.hashCode();
        h = h * 17 + Longs.hashCode(this.count);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ErrorMessageCount").add("message", this.message).add("count", this.count).toString();
    }

    @JsonCreator
    public static ErrorMessageCount fromAllAttributes(@JsonProperty(value="message") @Nullable String message, @JsonProperty(value="count") @Nullable Long count) {
        Builder builder = ErrorMessageCount.builder();
        if (message != null) {
            builder.message(message);
        }
        if (count != null) {
            builder.count(count);
        }
        return builder.build();
    }

    public static ErrorMessageCount copyOf(ErrorMessageCountBase instance) {
        if (instance instanceof ErrorMessageCount) {
            return (ErrorMessageCount)instance;
        }
        return ErrorMessageCount.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_MESSAGE = 1L;
        private static final long INITIALIZED_BIT_COUNT = 2L;
        private long initializedBitset;
        @Nullable
        private String message;
        private long count;

        private Builder() {
        }

        public final Builder from(ErrorMessageCountBase instance) {
            Preconditions.checkNotNull(instance);
            this.message(instance.message());
            this.count(instance.count());
            return this;
        }

        public final Builder message(String message) {
            this.message = Preconditions.checkNotNull(message);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder count(long count) {
            this.count = count;
            this.initializedBitset |= 2L;
            return this;
        }

        public ErrorMessageCount build() {
            this.checkRequiredAttributes();
            return new ErrorMessageCount(this);
        }

        private boolean messageIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean countIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.messageIsSet()) {
                attributes.add("message");
            }
            if (!this.countIsSet()) {
                attributes.add("count");
            }
            return "Cannot build ErrorMessageCount, some of required attributes are not set " + attributes;
        }
    }
}

