/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glowroot.api.PluginServices;
import org.glowroot.collector.AggregateRepository;
import org.glowroot.collector.TraceRepository;
import org.glowroot.common.Clock;
import org.glowroot.config.ConfigModule;
import org.glowroot.config.ConfigService;
import org.glowroot.jvm.LazyPlatformMBeanServer;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.store.AggregateRepositoryImpl;
import org.glowroot.local.store.AlertingService;
import org.glowroot.local.store.CappedDatabase;
import org.glowroot.local.store.CappedDatabaseStats;
import org.glowroot.local.store.DataSource;
import org.glowroot.local.store.GaugePointDao;
import org.glowroot.local.store.H2DatabaseStats;
import org.glowroot.local.store.MailService;
import org.glowroot.local.store.ReaperRunnable;
import org.glowroot.local.store.TraceDao;
import org.glowroot.local.store.TriggeredAlertDao;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.weaving.PreInitializeStorageShutdownClasses;

public class StorageModule {
    private static final long SNAPSHOT_REAPER_PERIOD_MINUTES = 5L;
    private static final long FIXED_GAUGE_ROLLUP_SECONDS = Long.getLong("glowroot.internal.gaugeRollup1", 60L);
    private static final long FIXED_AGGREGATE_ROLLUP_SECONDS = Long.getLong("glowroot.internal.aggregateRollup1", 300L);
    private static final Logger logger = LoggerFactory.getLogger(StorageModule.class);
    private final DataSource dataSource;
    private final CappedDatabase cappedDatabase;
    private final AggregateDao aggregateDao;
    private final AggregateRepositoryImpl aggregateRepositoryImpl;
    private final TraceDao traceDao;
    private final GaugePointDao gaugePointDao;
    @Nullable
    private final ReaperRunnable reaperRunnable;
    private final LazyPlatformMBeanServer lazyPlatformMBeanServer;
    @OnlyUsedByTests
    private volatile boolean unregisterMBeans;

    public StorageModule(File dataDir, Map<String, String> properties, Clock clock, Ticker ticker, ConfigModule configModule, ScheduledExecutorService scheduledExecutor, LazyPlatformMBeanServer lazyPlatformMBeanServer, boolean viewerModeEnabled) throws Exception {
        String h2MemDb = properties.get("internal.h2.memdb");
        final DataSource dataSource = Boolean.parseBoolean(h2MemDb) ? new DataSource() : new DataSource(new File(dataDir, "glowroot.h2.db"));
        final ConfigService configService = configModule.getConfigService();
        dataSource.setQueryTimeoutSeconds(configService.getAdvancedConfig().internalQueryTimeoutSeconds());
        configService.addConfigListener(new PluginServices.ConfigListener(){

            @Override
            public void onChange() {
                dataSource.setQueryTimeoutSeconds(configService.getAdvancedConfig().internalQueryTimeoutSeconds());
            }
        });
        this.dataSource = dataSource;
        int cappedDatabaseSizeMb = configService.getStorageConfig().cappedDatabaseSizeMb();
        this.cappedDatabase = new CappedDatabase(new File(dataDir, "glowroot.capped.db"), cappedDatabaseSizeMb * 1024, ticker);
        this.lazyPlatformMBeanServer = lazyPlatformMBeanServer;
        lazyPlatformMBeanServer.possiblyDelayedCall(new LazyPlatformMBeanServer.MBeanServerCallback(){

            @Override
            public void call(MBeanServer mbeanServer) throws Exception {
                try {
                    Preconditions.checkNotNull(StorageModule.this.cappedDatabase);
                    mbeanServer.registerMBean(new CappedDatabaseStats(StorageModule.this.cappedDatabase), new ObjectName("org.glowroot:type=CappedDatabaseStats"));
                    mbeanServer.registerMBean(new H2DatabaseStats(dataSource), new ObjectName("org.glowroot:type=H2DatabaseStats"));
                    StorageModule.this.unregisterMBeans = true;
                }
                catch (InstanceAlreadyExistsException e) {
                    logger.debug(e.getMessage(), e);
                }
            }
        });
        this.aggregateDao = new AggregateDao(dataSource, this.cappedDatabase, configModule.getConfigService(), FIXED_AGGREGATE_ROLLUP_SECONDS);
        TriggeredAlertDao triggeredAlertDao = new TriggeredAlertDao(dataSource);
        AlertingService alertingService = new AlertingService(configService, triggeredAlertDao, this.aggregateDao, new MailService());
        this.aggregateRepositoryImpl = new AggregateRepositoryImpl(this.aggregateDao, alertingService);
        this.traceDao = new TraceDao(dataSource, this.cappedDatabase);
        this.gaugePointDao = new GaugePointDao(dataSource, clock, FIXED_GAUGE_ROLLUP_SECONDS);
        PreInitializeStorageShutdownClasses.preInitializeClasses();
        if (viewerModeEnabled) {
            this.reaperRunnable = null;
        } else {
            this.reaperRunnable = new ReaperRunnable(configService, this.aggregateDao, this.traceDao, this.gaugePointDao, clock);
            this.reaperRunnable.scheduleWithFixedDelay(scheduledExecutor, 0L, 5L, TimeUnit.MINUTES);
        }
    }

    public AggregateRepository getAggregateRepository() {
        return this.aggregateRepositoryImpl;
    }

    public TraceRepository getTraceRepository() {
        return this.traceDao;
    }

    public GaugePointDao getGaugePointDao() {
        return this.gaugePointDao;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public AggregateDao getAggregateDao() {
        return this.aggregateDao;
    }

    public TraceDao getTraceDao() {
        return this.traceDao;
    }

    public CappedDatabase getCappedDatabase() {
        return this.cappedDatabase;
    }

    public long getFixedAggregateRollupSeconds() {
        return FIXED_AGGREGATE_ROLLUP_SECONDS;
    }

    public long getFixedGaugeRollupSeconds() {
        return FIXED_GAUGE_ROLLUP_SECONDS;
    }

    @OnlyUsedByTests
    public void close() throws Exception {
        if (this.unregisterMBeans) {
            this.lazyPlatformMBeanServer.unregisterMBean(new ObjectName("org.glowroot:type=CappedDatabaseStats"));
            this.lazyPlatformMBeanServer.unregisterMBean(new ObjectName("org.glowroot:type=H2DatabaseStats"));
        }
        if (this.reaperRunnable != null) {
            this.reaperRunnable.cancel();
        }
        this.cappedDatabase.close();
        this.dataSource.close();
    }
}

