/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.store.StringComparator;
import org.glowroot.local.store.TracePointQueryBase;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class TracePointQuery
extends TracePointQueryBase {
    private final long from;
    private final long to;
    private final long durationLow;
    @Nullable
    private final Long durationHigh;
    @Nullable
    private final String transactionType;
    @Nullable
    private final StringComparator transactionNameComparator;
    @Nullable
    private final String transactionName;
    @Nullable
    private final StringComparator headlineComparator;
    @Nullable
    private final String headline;
    @Nullable
    private final StringComparator errorComparator;
    @Nullable
    private final String error;
    @Nullable
    private final StringComparator userComparator;
    @Nullable
    private final String user;
    @Nullable
    private final String customAttributeName;
    @Nullable
    private final StringComparator customAttributeValueComparator;
    @Nullable
    private final String customAttributeValue;
    private final boolean errorOnly;
    private final int limit;

    private TracePointQuery(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.durationLow = builder.durationLow;
        this.durationHigh = builder.durationHigh;
        this.transactionType = builder.transactionType;
        this.transactionNameComparator = builder.transactionNameComparator;
        this.transactionName = builder.transactionName;
        this.headlineComparator = builder.headlineComparator;
        this.headline = builder.headline;
        this.errorComparator = builder.errorComparator;
        this.error = builder.error;
        this.userComparator = builder.userComparator;
        this.user = builder.user;
        this.customAttributeName = builder.customAttributeName;
        this.customAttributeValueComparator = builder.customAttributeValueComparator;
        this.customAttributeValue = builder.customAttributeValue;
        this.limit = builder.limit;
        this.errorOnly = builder.errorOnlyIsSet() ? builder.errorOnly : super.errorOnly();
    }

    private TracePointQuery(TracePointQuery original, long from, long to, long durationLow, @Nullable Long durationHigh, @Nullable String transactionType, @Nullable StringComparator transactionNameComparator, @Nullable String transactionName, @Nullable StringComparator headlineComparator, @Nullable String headline, @Nullable StringComparator errorComparator, @Nullable String error, @Nullable StringComparator userComparator, @Nullable String user, @Nullable String customAttributeName, @Nullable StringComparator customAttributeValueComparator, @Nullable String customAttributeValue, boolean errorOnly, int limit) {
        this.from = from;
        this.to = to;
        this.durationLow = durationLow;
        this.durationHigh = durationHigh;
        this.transactionType = transactionType;
        this.transactionNameComparator = transactionNameComparator;
        this.transactionName = transactionName;
        this.headlineComparator = headlineComparator;
        this.headline = headline;
        this.errorComparator = errorComparator;
        this.error = error;
        this.userComparator = userComparator;
        this.user = user;
        this.customAttributeName = customAttributeName;
        this.customAttributeValueComparator = customAttributeValueComparator;
        this.customAttributeValue = customAttributeValue;
        this.errorOnly = errorOnly;
        this.limit = limit;
    }

    @Override
    public long from() {
        return this.from;
    }

    @Override
    public long to() {
        return this.to;
    }

    @Override
    public long durationLow() {
        return this.durationLow;
    }

    @Override
    @Nullable
    public Long durationHigh() {
        return this.durationHigh;
    }

    @Override
    @Nullable
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @Nullable
    public StringComparator transactionNameComparator() {
        return this.transactionNameComparator;
    }

    @Override
    @Nullable
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    @Nullable
    public StringComparator headlineComparator() {
        return this.headlineComparator;
    }

    @Override
    @Nullable
    public String headline() {
        return this.headline;
    }

    @Override
    @Nullable
    public StringComparator errorComparator() {
        return this.errorComparator;
    }

    @Override
    @Nullable
    public String error() {
        return this.error;
    }

    @Override
    @Nullable
    public StringComparator userComparator() {
        return this.userComparator;
    }

    @Override
    @Nullable
    public String user() {
        return this.user;
    }

    @Override
    @Nullable
    public String customAttributeName() {
        return this.customAttributeName;
    }

    @Override
    @Nullable
    public StringComparator customAttributeValueComparator() {
        return this.customAttributeValueComparator;
    }

    @Override
    @Nullable
    public String customAttributeValue() {
        return this.customAttributeValue;
    }

    @Override
    public boolean errorOnly() {
        return this.errorOnly;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final TracePointQuery withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        long newValue = value;
        return new TracePointQuery(this, newValue, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withTo(long value) {
        if (this.to == value) {
            return this;
        }
        long newValue = value;
        return new TracePointQuery(this, this.from, newValue, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withDurationLow(long value) {
        if (this.durationLow == value) {
            return this;
        }
        long newValue = value;
        return new TracePointQuery(this, this.from, this.to, newValue, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withDurationHigh(@Nullable Long value) {
        if (this.durationHigh == value) {
            return this;
        }
        Long newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, newValue, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withTransactionType(@Nullable String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, newValue, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withTransactionNameComparator(@Nullable StringComparator value) {
        if (this.transactionNameComparator == value) {
            return this;
        }
        StringComparator newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, newValue, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withTransactionName(@Nullable String value) {
        if (this.transactionName == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, newValue, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withHeadlineComparator(@Nullable StringComparator value) {
        if (this.headlineComparator == value) {
            return this;
        }
        StringComparator newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, newValue, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withHeadline(@Nullable String value) {
        if (this.headline == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, newValue, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withErrorComparator(@Nullable StringComparator value) {
        if (this.errorComparator == value) {
            return this;
        }
        StringComparator newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, newValue, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withError(@Nullable String value) {
        if (this.error == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, newValue, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withUserComparator(@Nullable StringComparator value) {
        if (this.userComparator == value) {
            return this;
        }
        StringComparator newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, newValue, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withUser(@Nullable String value) {
        if (this.user == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, newValue, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withCustomAttributeName(@Nullable String value) {
        if (this.customAttributeName == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, newValue, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withCustomAttributeValueComparator(@Nullable StringComparator value) {
        if (this.customAttributeValueComparator == value) {
            return this;
        }
        StringComparator newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, newValue, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withCustomAttributeValue(@Nullable String value) {
        if (this.customAttributeValue == value) {
            return this;
        }
        String newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, newValue, this.errorOnly, this.limit);
    }

    public final TracePointQuery withErrorOnly(boolean value) {
        if (this.errorOnly == value) {
            return this;
        }
        boolean newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, newValue, this.limit);
    }

    public final TracePointQuery withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        int newValue = value;
        return new TracePointQuery(this, this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TracePointQuery && this.equalTo((TracePointQuery)another);
    }

    private boolean equalTo(TracePointQuery another) {
        return this.from == another.from && this.to == another.to && this.durationLow == another.durationLow && Objects.equal(this.durationHigh, another.durationHigh) && Objects.equal(this.transactionType, another.transactionType) && Objects.equal((Object)this.transactionNameComparator, (Object)another.transactionNameComparator) && Objects.equal(this.transactionName, another.transactionName) && Objects.equal((Object)this.headlineComparator, (Object)another.headlineComparator) && Objects.equal(this.headline, another.headline) && Objects.equal((Object)this.errorComparator, (Object)another.errorComparator) && Objects.equal(this.error, another.error) && Objects.equal((Object)this.userComparator, (Object)another.userComparator) && Objects.equal(this.user, another.user) && Objects.equal(this.customAttributeName, another.customAttributeName) && Objects.equal((Object)this.customAttributeValueComparator, (Object)another.customAttributeValueComparator) && Objects.equal(this.customAttributeValue, another.customAttributeValue) && this.errorOnly == another.errorOnly && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.from);
        h = h * 17 + Longs.hashCode(this.to);
        h = h * 17 + Longs.hashCode(this.durationLow);
        h = h * 17 + Objects.hashCode(this.durationHigh);
        h = h * 17 + Objects.hashCode(this.transactionType);
        h = h * 17 + Objects.hashCode(new Object[]{this.transactionNameComparator});
        h = h * 17 + Objects.hashCode(this.transactionName);
        h = h * 17 + Objects.hashCode(new Object[]{this.headlineComparator});
        h = h * 17 + Objects.hashCode(this.headline);
        h = h * 17 + Objects.hashCode(new Object[]{this.errorComparator});
        h = h * 17 + Objects.hashCode(this.error);
        h = h * 17 + Objects.hashCode(new Object[]{this.userComparator});
        h = h * 17 + Objects.hashCode(this.user);
        h = h * 17 + Objects.hashCode(this.customAttributeName);
        h = h * 17 + Objects.hashCode(new Object[]{this.customAttributeValueComparator});
        h = h * 17 + Objects.hashCode(this.customAttributeValue);
        h = h * 17 + Booleans.hashCode(this.errorOnly);
        h = h * 17 + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TracePointQuery").add("from", this.from).add("to", this.to).add("durationLow", this.durationLow).add("durationHigh", this.durationHigh).add("transactionType", this.transactionType).add("transactionNameComparator", (Object)this.transactionNameComparator).add("transactionName", this.transactionName).add("headlineComparator", (Object)this.headlineComparator).add("headline", this.headline).add("errorComparator", (Object)this.errorComparator).add("error", this.error).add("userComparator", (Object)this.userComparator).add("user", this.user).add("customAttributeName", this.customAttributeName).add("customAttributeValueComparator", (Object)this.customAttributeValueComparator).add("customAttributeValue", this.customAttributeValue).add("errorOnly", this.errorOnly).add("limit", this.limit).toString();
    }

    public static TracePointQuery copyOf(TracePointQueryBase instance) {
        if (instance instanceof TracePointQuery) {
            return (TracePointQuery)instance;
        }
        return TracePointQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 15L;
        private static final long INITIALIZED_BIT_FROM = 1L;
        private static final long INITIALIZED_BIT_TO = 2L;
        private static final long INITIALIZED_BIT_DURATION_LOW = 4L;
        private static final long INITIALIZED_BIT_LIMIT = 8L;
        private static final long NONDEFAULT_BIT_ERROR_ONLY = 1L;
        private long initializedBitset;
        private long nondefaultBitset;
        private long from;
        private long to;
        private long durationLow;
        @Nullable
        private Long durationHigh;
        @Nullable
        private String transactionType;
        @Nullable
        private StringComparator transactionNameComparator;
        @Nullable
        private String transactionName;
        @Nullable
        private StringComparator headlineComparator;
        @Nullable
        private String headline;
        @Nullable
        private StringComparator errorComparator;
        @Nullable
        private String error;
        @Nullable
        private StringComparator userComparator;
        @Nullable
        private String user;
        @Nullable
        private String customAttributeName;
        @Nullable
        private StringComparator customAttributeValueComparator;
        @Nullable
        private String customAttributeValue;
        private boolean errorOnly;
        private int limit;

        private Builder() {
        }

        public final Builder from(TracePointQueryBase instance) {
            String customAttributeValueValue;
            StringComparator customAttributeValueComparatorValue;
            String customAttributeNameValue;
            String userValue;
            StringComparator userComparatorValue;
            String errorValue;
            StringComparator errorComparatorValue;
            String headlineValue;
            StringComparator headlineComparatorValue;
            String transactionNameValue;
            StringComparator transactionNameComparatorValue;
            String transactionTypeValue;
            Preconditions.checkNotNull(instance);
            this.from(instance.from());
            this.to(instance.to());
            this.durationLow(instance.durationLow());
            Long durationHighValue = instance.durationHigh();
            if (durationHighValue != null) {
                this.durationHigh(durationHighValue);
            }
            if ((transactionTypeValue = instance.transactionType()) != null) {
                this.transactionType(transactionTypeValue);
            }
            if ((transactionNameComparatorValue = instance.transactionNameComparator()) != null) {
                this.transactionNameComparator(transactionNameComparatorValue);
            }
            if ((transactionNameValue = instance.transactionName()) != null) {
                this.transactionName(transactionNameValue);
            }
            if ((headlineComparatorValue = instance.headlineComparator()) != null) {
                this.headlineComparator(headlineComparatorValue);
            }
            if ((headlineValue = instance.headline()) != null) {
                this.headline(headlineValue);
            }
            if ((errorComparatorValue = instance.errorComparator()) != null) {
                this.errorComparator(errorComparatorValue);
            }
            if ((errorValue = instance.error()) != null) {
                this.error(errorValue);
            }
            if ((userComparatorValue = instance.userComparator()) != null) {
                this.userComparator(userComparatorValue);
            }
            if ((userValue = instance.user()) != null) {
                this.user(userValue);
            }
            if ((customAttributeNameValue = instance.customAttributeName()) != null) {
                this.customAttributeName(customAttributeNameValue);
            }
            if ((customAttributeValueComparatorValue = instance.customAttributeValueComparator()) != null) {
                this.customAttributeValueComparator(customAttributeValueComparatorValue);
            }
            if ((customAttributeValueValue = instance.customAttributeValue()) != null) {
                this.customAttributeValue(customAttributeValueValue);
            }
            this.errorOnly(instance.errorOnly());
            this.limit(instance.limit());
            return this;
        }

        public final Builder from(long from) {
            this.from = from;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder to(long to) {
            this.to = to;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder durationLow(long durationLow) {
            this.durationLow = durationLow;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder durationHigh(@Nullable Long durationHigh) {
            this.durationHigh = durationHigh;
            return this;
        }

        public final Builder transactionType(@Nullable String transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public final Builder transactionNameComparator(@Nullable StringComparator transactionNameComparator) {
            this.transactionNameComparator = transactionNameComparator;
            return this;
        }

        public final Builder transactionName(@Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        public final Builder headlineComparator(@Nullable StringComparator headlineComparator) {
            this.headlineComparator = headlineComparator;
            return this;
        }

        public final Builder headline(@Nullable String headline) {
            this.headline = headline;
            return this;
        }

        public final Builder errorComparator(@Nullable StringComparator errorComparator) {
            this.errorComparator = errorComparator;
            return this;
        }

        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        public final Builder userComparator(@Nullable StringComparator userComparator) {
            this.userComparator = userComparator;
            return this;
        }

        public final Builder user(@Nullable String user) {
            this.user = user;
            return this;
        }

        public final Builder customAttributeName(@Nullable String customAttributeName) {
            this.customAttributeName = customAttributeName;
            return this;
        }

        public final Builder customAttributeValueComparator(@Nullable StringComparator customAttributeValueComparator) {
            this.customAttributeValueComparator = customAttributeValueComparator;
            return this;
        }

        public final Builder customAttributeValue(@Nullable String customAttributeValue) {
            this.customAttributeValue = customAttributeValue;
            return this;
        }

        public final Builder errorOnly(boolean errorOnly) {
            this.errorOnly = errorOnly;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initializedBitset |= 8L;
            return this;
        }

        public TracePointQuery build() {
            this.checkRequiredAttributes();
            return new TracePointQuery(this);
        }

        private boolean errorOnlyIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean fromIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean toIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean durationLowIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean limitIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 15L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.fromIsSet()) {
                attributes.add("from");
            }
            if (!this.toIsSet()) {
                attributes.add("to");
            }
            if (!this.durationLowIsSet()) {
                attributes.add("durationLow");
            }
            if (!this.limitIsSet()) {
                attributes.add("limit");
            }
            return "Cannot build TracePointQuery, some of required attributes are not set " + attributes;
        }
    }
}

