/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.collector.Aggregate;
import org.glowroot.collector.AggregateTimer;
import org.glowroot.collector.LazyHistogram;
import org.glowroot.collector.ProfileAggregate;
import org.glowroot.collector.QueryAggregate;
import org.glowroot.collector.QueryComponent;
import org.glowroot.common.ObjectMappers;
import org.glowroot.local.store.AlertingService;
import org.glowroot.local.ui.PercentileMergedAggregate;
import org.glowroot.local.ui.PercentileValue;
import org.glowroot.local.ui.ThreadInfoAggregate;
import org.glowroot.local.ui.TimerMergedAggregate;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.transaction.model.ProfileNode;
import org.immutables.value.Value;

public class AggregateMerging {
    private static final ObjectMapper mapper = ObjectMappers.create();

    private AggregateMerging() {
    }

    public static TimerMergedAggregate getTimerMergedAggregate(List<Aggregate> aggregates) throws Exception {
        long transactionCount = 0L;
        AggregateTimer syntheticRootTimer = AggregateTimer.createSyntheticRootTimer();
        for (Aggregate aggregate : aggregates) {
            transactionCount += aggregate.transactionCount();
            AggregateTimer toBeMergedSyntheticRootTimer = mapper.readValue(aggregate.timers(), AggregateTimer.class);
            syntheticRootTimer.mergeMatchedTimer(toBeMergedSyntheticRootTimer);
        }
        TimerMergedAggregate.Builder timerMergedAggregate = TimerMergedAggregate.builder();
        timerMergedAggregate.syntheticRootTimer(syntheticRootTimer);
        timerMergedAggregate.transactionCount(transactionCount);
        return timerMergedAggregate.build();
    }

    public static PercentileMergedAggregate getPercentileMergedAggregate(List<Aggregate> aggregates, List<Double> percentiles) throws Exception {
        long transactionCount = 0L;
        long totalMicros = 0L;
        LazyHistogram histogram = new LazyHistogram();
        for (Aggregate aggregate : aggregates) {
            transactionCount += aggregate.transactionCount();
            totalMicros += aggregate.totalMicros();
            histogram.decodeFromByteBuffer(ByteBuffer.wrap(aggregate.histogram()));
        }
        ArrayList<PercentileValue> percentileValues = Lists.newArrayList();
        for (double percentile : percentiles) {
            percentileValues.add(PercentileValue.of(AlertingService.getPercentileWithSuffix(percentile) + " percentile", histogram.getValueAtPercentile(percentile)));
        }
        return PercentileMergedAggregate.builder().totalMicros(totalMicros).transactionCount(transactionCount).percentileValues(percentileValues).build();
    }

    public static ThreadInfoAggregate getThreadInfoAggregate(List<Aggregate> aggregates) {
        Long totalCpuMicros = null;
        Long totalBlockedMicros = null;
        Long totalWaitedMicros = null;
        Long totalAllocatedKBytes = null;
        for (Aggregate aggregate : aggregates) {
            totalCpuMicros = AggregateMerging.nullAwareAdd(totalCpuMicros, aggregate.totalCpuMicros());
            totalBlockedMicros = AggregateMerging.nullAwareAdd(totalBlockedMicros, aggregate.totalBlockedMicros());
            totalWaitedMicros = AggregateMerging.nullAwareAdd(totalWaitedMicros, aggregate.totalWaitedMicros());
            totalAllocatedKBytes = AggregateMerging.nullAwareAdd(totalAllocatedKBytes, aggregate.totalAllocatedKBytes());
        }
        return ThreadInfoAggregate.builder().totalCpuMicros(totalCpuMicros).totalBlockedMicros(totalBlockedMicros).totalWaitedMicros(totalWaitedMicros).totalAllocatedKBytes(totalAllocatedKBytes).build();
    }

    public static Map<String, List<QueryComponent.AggregateQuery>> getOrderedAndTruncatedQueries(List<QueryAggregate> queryAggregates, int maxAggregateQueriesPerQueryType) throws IOException {
        QueryComponent queryComponent = new QueryComponent(maxAggregateQueriesPerQueryType, 0);
        for (QueryAggregate queryAggregate : queryAggregates) {
            String queries = queryAggregate.queries().read();
            if (queries.equals("{\"overwritten\":true}")) continue;
            queryComponent.mergeQueries(queries);
        }
        return queryComponent.getOrderedAndTruncatedQueries();
    }

    public static ProfileNode getMergedProfile(List<ProfileAggregate> profileAggregates) throws IOException {
        ProfileNode syntheticRootNode = ProfileNode.createSyntheticRoot();
        for (ProfileAggregate profileAggregate : profileAggregates) {
            String profile = profileAggregate.profile().read();
            if (profile.equals("{\"overwritten\":true}")) continue;
            ProfileNode toBeMergedRootNode = ObjectMappers.readRequiredValue(mapper, profile, ProfileNode.class);
            syntheticRootNode.mergeMatchedNode(toBeMergedRootNode);
        }
        return syntheticRootNode;
    }

    @Nullable
    private static Long nullAwareAdd(@Nullable Long x, @Nullable Long y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        return x + y;
    }

    @JsonSerialize
    @Value.Immutable
    public static abstract class ThreadInfoAggregateBase {
        @Nullable
        abstract Long totalCpuMicros();

        @Nullable
        abstract Long totalBlockedMicros();

        @Nullable
        abstract Long totalWaitedMicros();

        @Nullable
        abstract Long totalAllocatedKBytes();

        public boolean isEmpty() {
            return this.totalCpuMicros() == null && this.totalBlockedMicros() == null && this.totalWaitedMicros() == null && this.totalAllocatedKBytes() == null;
        }
    }

    @JsonSerialize
    @Value.Immutable
    public static abstract class PercentileValueBase {
        public abstract String dataSeriesName();

        public abstract long value();
    }

    @JsonSerialize
    @Value.Immutable
    public static abstract class PercentileMergedAggregateBase {
        public abstract long totalMicros();

        public abstract long transactionCount();

        public abstract ImmutableList<PercentileValue> percentileValues();
    }

    @JsonSerialize
    @Value.Immutable
    public static abstract class TimerMergedAggregateBase {
        @JsonProperty(value="timers")
        public abstract AggregateTimer syntheticRootTimer();

        public abstract long transactionCount();
    }
}

