/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import org.glowroot.common.ChunkSource;
import org.glowroot.shaded.google.common.base.Charsets;
import org.glowroot.shaded.netty.buffer.ByteBuf;
import org.glowroot.shaded.netty.buffer.ByteBufOutputStream;
import org.glowroot.shaded.netty.buffer.Unpooled;
import org.glowroot.shaded.netty.channel.ChannelHandlerContext;
import org.glowroot.shaded.netty.handler.codec.http.DefaultHttpContent;
import org.glowroot.shaded.netty.handler.codec.http.HttpContent;
import org.glowroot.shaded.netty.handler.codec.http.LastHttpContent;
import org.glowroot.shaded.netty.handler.stream.ChunkedInput;

class ChunkedInputs {
    static ChunkedInput<HttpContent> from(ChunkSource chunkSource) throws IOException {
        return new ChunkSourceChunkedInput(chunkSource);
    }

    static ChunkedInput<HttpContent> fromChunkSourceToZipFileDownload(ChunkSource chunkSource, String filename) throws IOException {
        return new ZipFileChunkedInput(chunkSource, filename);
    }

    private ChunkedInputs() {
    }

    private static class ZipFileChunkedInput
    extends BaseChunkedInput {
        private final ByteBuf byteBuf = Unpooled.buffer();
        private final ByteBufOutputStream bbos = new ByteBufOutputStream(this.byteBuf);
        private final Writer zipWriter;
        private final ChunkSource.ChunkCopier chunkCopier;
        private boolean firstChunk = true;
        private boolean closed;

        private ZipFileChunkedInput(ChunkSource chunkSource, String filename) throws IOException {
            ZipOutputStream zipOut = new ZipOutputStream(this.bbos);
            zipOut.putNextEntry(new ZipEntry(filename + ".html"));
            this.zipWriter = new OutputStreamWriter((OutputStream)zipOut, Charsets.UTF_8);
            this.chunkCopier = chunkSource.getCopier(this.zipWriter);
        }

        @Override
        @Nullable
        protected ByteBuf readNextChunk() throws IOException {
            if (this.closed) {
                return null;
            }
            if (!this.firstChunk) {
                this.byteBuf.clear();
            }
            this.firstChunk = false;
            do {
                if (this.chunkCopier.copyNext()) continue;
                this.zipWriter.close();
                this.closed = true;
                return this.byteBuf;
            } while (this.byteBuf.writerIndex() <= 0);
            this.zipWriter.flush();
            this.byteBuf.retain();
            return this.byteBuf;
        }
    }

    private static class ChunkSourceChunkedInput
    extends BaseChunkedInput {
        private final ByteBuf byteBuf = Unpooled.buffer();
        private final Writer writer = new OutputStreamWriter((OutputStream)new ByteBufOutputStream(this.byteBuf), Charsets.UTF_8);
        private final ChunkSource.ChunkCopier chunkCopier;
        private boolean closed;

        private ChunkSourceChunkedInput(ChunkSource chunkSource) throws IOException {
            this.chunkCopier = chunkSource.getCopier(this.writer);
        }

        @Override
        @Nullable
        public ByteBuf readNextChunk() throws IOException {
            if (this.closed) {
                return null;
            }
            if (this.byteBuf.refCnt() > 1) {
                throw new IOException("ByteBuf is still in use by another");
            }
            this.byteBuf.clear();
            if (this.chunkCopier.copyNext()) {
                this.writer.flush();
                while (this.byteBuf.writerIndex() == 0) {
                    this.chunkCopier.copyNext();
                    this.writer.flush();
                }
                this.byteBuf.retain();
                return this.byteBuf;
            }
            this.closed = true;
            return null;
        }
    }

    private static abstract class BaseChunkedInput
    implements ChunkedInput<HttpContent> {
        private boolean hasSentTerminatingChunk;

        private BaseChunkedInput() {
        }

        @Override
        @Nullable
        public HttpContent readChunk(ChannelHandlerContext ctx) throws IOException {
            if (this.hasSentTerminatingChunk) {
                return null;
            }
            ByteBuf nextChunk = this.readNextChunk();
            if (nextChunk != null) {
                return new DefaultHttpContent(nextChunk);
            }
            this.hasSentTerminatingChunk = true;
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }

        @Override
        public boolean isEndOfInput() {
            return this.hasSentTerminatingChunk;
        }

        @Override
        public void close() throws IOException {
        }

        @Nullable
        protected abstract ByteBuf readNextChunk() throws IOException;
    }
}

