/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.glowroot.common.ClassNames;
import org.glowroot.common.Reflections;
import org.glowroot.local.ui.UiAnalyzedMethod;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Splitter;
import org.glowroot.shaded.google.common.base.StandardSystemProperty;
import org.glowroot.shaded.google.common.collect.HashMultimap;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableMultimap;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.Iterables;
import org.glowroot.shaded.google.common.collect.Iterators;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Multimap;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.google.common.collect.TreeMultimap;
import org.glowroot.shaded.google.common.io.Closer;
import org.glowroot.shaded.google.common.io.Resources;
import org.glowroot.shaded.objectweb.asm.ClassReader;
import org.glowroot.shaded.objectweb.asm.ClassVisitor;
import org.glowroot.shaded.objectweb.asm.MethodVisitor;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.weaving.AnalyzedWorld;

class ClasspathCache {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathCache.class);
    private final AnalyzedWorld analyzedWorld;
    @Nullable
    private final Instrumentation instrumentation;
    @GuardedBy(value="this")
    private final Set<File> classpathLocations = Sets.newHashSet();
    @GuardedBy(value="this")
    private ImmutableMultimap<String, File> classNameLocations = ImmutableMultimap.of();

    ClasspathCache(AnalyzedWorld analyzedWorld, @Nullable Instrumentation instrumentation) {
        this.analyzedWorld = analyzedWorld;
        this.instrumentation = instrumentation;
    }

    synchronized ImmutableList<String> getMatchingClassNames(String partialClassName, int limit) {
        this.updateCache();
        PartialClassNameMatcher matcher = new PartialClassNameMatcher(partialClassName);
        LinkedHashSet<String> fullMatchingClassNames = Sets.newLinkedHashSet();
        LinkedHashSet<String> matchingClassNames = Sets.newLinkedHashSet();
        Iterator i = ((ImmutableSet)this.classNameLocations.keySet()).iterator();
        if (this.instrumentation != null) {
            ArrayList<String> loadedClassNames = Lists.newArrayList();
            for (Class clazz : this.instrumentation.getAllLoadedClasses()) {
                if (clazz.getName().startsWith("[")) continue;
                loadedClassNames.add(clazz.getName());
            }
            i = Iterators.concat(i, loadedClassNames.iterator());
        }
        while (i.hasNext()) {
            String className = (String)i.next();
            String classNameUpper = className.toUpperCase(Locale.ENGLISH);
            boolean potentialFullMatch = matcher.isPotentialFullMatch(classNameUpper);
            if (matchingClassNames.size() == limit && !potentialFullMatch) continue;
            if (fullMatchingClassNames.size() == limit) break;
            if (!matcher.isPotentialMatch(classNameUpper)) continue;
            if (potentialFullMatch) {
                fullMatchingClassNames.add(className);
                continue;
            }
            matchingClassNames.add(className);
        }
        return this.combineClassNamesWithLimit(fullMatchingClassNames, matchingClassNames, limit);
    }

    synchronized ImmutableList<UiAnalyzedMethod> getAnalyzedMethods(String className) {
        this.updateCache();
        HashSet<UiAnalyzedMethod> analyzedMethods = Sets.newHashSet();
        Collection locations = this.classNameLocations.get((Object)className);
        for (File location : locations) {
            try {
                analyzedMethods.addAll(this.getAnalyzedMethods(location, className));
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), e);
            }
        }
        if (this.instrumentation != null) {
            for (Class clazz : this.instrumentation.getAllLoadedClasses()) {
                if (!clazz.getName().equals(className)) continue;
                analyzedMethods.addAll(this.getAnalyzedMethods(clazz));
            }
        }
        return ImmutableList.copyOf(analyzedMethods);
    }

    synchronized void updateCache() {
        HashMultimap<String, File> newClassNameLocations = HashMultimap.create();
        for (ClassLoader loader : this.getKnownClassLoaders()) {
            this.updateCache(loader, newClassNameLocations);
        }
        this.updateCacheWithClasspathClasses(newClassNameLocations);
        this.updateCacheWithBootstrapClasses(newClassNameLocations);
        if (!newClassNameLocations.isEmpty()) {
            TreeMultimap newMap = TreeMultimap.create(String.CASE_INSENSITIVE_ORDER, Ordering.natural());
            newMap.putAll(this.classNameLocations);
            newMap.putAll(newClassNameLocations);
            this.classNameLocations = ImmutableMultimap.copyOf(newMap);
        }
    }

    private ImmutableList<String> combineClassNamesWithLimit(Set<String> fullMatchingClassNames, Set<String> matchingClassNames, int limit) {
        if (fullMatchingClassNames.size() < limit) {
            int space = limit - fullMatchingClassNames.size();
            int numToAdd = Math.min(space, matchingClassNames.size());
            fullMatchingClassNames.addAll(ImmutableList.copyOf(Iterables.limit(matchingClassNames, numToAdd)));
        }
        return ImmutableList.copyOf(fullMatchingClassNames);
    }

    private void updateCacheWithClasspathClasses(Multimap<String, File> newClassNameLocations) {
        String javaClassPath = StandardSystemProperty.JAVA_CLASS_PATH.value();
        if (javaClassPath == null) {
            return;
        }
        for (String path : Splitter.on(File.pathSeparatorChar).split(javaClassPath)) {
            File file = new File(path);
            if (this.classpathLocations.contains(file)) continue;
            ClasspathCache.loadClassNames(file, newClassNameLocations);
            this.classpathLocations.add(file);
        }
    }

    private void updateCacheWithBootstrapClasses(Multimap<String, File> newClassNameLocations) {
        String bootClassPath = System.getProperty("sun.boot.class.path");
        if (bootClassPath == null) {
            return;
        }
        for (String path : Splitter.on(File.pathSeparatorChar).split(bootClassPath)) {
            File file = new File(path);
            if (this.classpathLocations.contains(file)) continue;
            ClasspathCache.loadClassNames(file, newClassNameLocations);
            this.classpathLocations.add(file);
        }
    }

    private List<UiAnalyzedMethod> getAnalyzedMethods(File location, String className) throws IOException {
        String name = className.replace('.', '/') + ".class";
        if (location.isDirectory()) {
            URI uri = new File(location, name).toURI();
            return this.getAnalyzedMethods(uri);
        }
        if (location.exists() && location.getName().endsWith(".jar")) {
            String path = location.getPath();
            try {
                URI uri = new URI("jar", "file:" + path + "!/" + name, "");
                return this.getAnalyzedMethods(uri);
            }
            catch (URISyntaxException e) {
                logger.error(e.getMessage(), e);
            }
        }
        return ImmutableList.of();
    }

    private List<UiAnalyzedMethod> getAnalyzedMethods(URI uri) throws IOException {
        AnalyzingClassVisitor cv = new AnalyzingClassVisitor();
        byte[] bytes = Resources.toByteArray(uri.toURL());
        ClassReader cr = new ClassReader(bytes);
        cr.accept(cv, 0);
        return cv.getAnalyzedMethods();
    }

    private List<UiAnalyzedMethod> getAnalyzedMethods(Class<?> clazz) {
        ArrayList<UiAnalyzedMethod> analyzedMethods = Lists.newArrayList();
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.isSynthetic() || Modifier.isNative(method.getModifiers())) continue;
            UiAnalyzedMethod.Builder builder = UiAnalyzedMethod.builder();
            builder.name(method.getName());
            for (Class<?> parameterType : method.getParameterTypes()) {
                builder.addParameterTypes(Type.getType(parameterType).getClassName());
            }
            builder.returnType(Type.getType(method.getReturnType()).getClassName());
            builder.modifiers(method.getModifiers());
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                builder.addExceptions(exceptionType.getName());
            }
            analyzedMethods.add(builder.build());
        }
        return analyzedMethods;
    }

    private void updateCache(ClassLoader loader, Multimap<String, File> newClassNameLocations) {
        List<URL> urls = this.getURLs(loader);
        ArrayList<File> locations = Lists.newArrayList();
        for (URL url : urls) {
            File file = this.tryToGetFileFromURL(url, loader);
            if (file == null) continue;
            locations.add(file);
        }
        for (File location : locations) {
            if (this.classpathLocations.contains(location)) continue;
            ClasspathCache.loadClassNames(location, newClassNameLocations);
            this.classpathLocations.add(location);
        }
    }

    @Nullable
    private File tryToGetFileFromURL(URL url, ClassLoader loader) {
        block6: {
            if (url.getProtocol().equals("vfs")) {
                try {
                    return ClasspathCache.getFileFromJBossVfsURL(url, loader);
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), e);
                    break block6;
                }
            }
            try {
                URI uri = url.toURI();
                if (uri.getScheme().equals("file")) {
                    return new File(uri);
                }
            }
            catch (URISyntaxException e) {
                logger.debug(e.getMessage(), e);
            }
        }
        return null;
    }

    private List<URL> getURLs(ClassLoader loader) {
        if (loader instanceof URLClassLoader) {
            try {
                return Lists.newArrayList(((URLClassLoader)loader).getURLs());
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), e);
                return ImmutableList.of();
            }
        }
        try {
            return Collections.list(loader.getResources("/"));
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), e);
            return ImmutableList.of();
        }
    }

    private List<ClassLoader> getKnownClassLoaders() {
        ImmutableList<ClassLoader> loaders = this.analyzedWorld.getClassLoaders();
        if (loaders.isEmpty()) {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (systemClassLoader == null) {
                return ImmutableList.of();
            }
            return ImmutableList.of(systemClassLoader);
        }
        return loaders;
    }

    private static void loadClassNames(File file, Multimap<String, File> newClassNameLocations) {
        try {
            if (file.isDirectory()) {
                ClasspathCache.loadClassNamesFromDirectory(file, "", file, newClassNameLocations);
            } else if (file.exists() && file.getName().endsWith(".jar")) {
                ClasspathCache.loadClassNamesFromJarFile(file, newClassNameLocations);
            }
        }
        catch (IllegalArgumentException e) {
            logger.debug(e.getMessage(), e);
        }
        catch (IOException e) {
            logger.debug("error reading classes from file: {}", (Object)file, (Object)e);
        }
    }

    private static void loadClassNamesFromDirectory(File dir, String prefix, File location, Multimap<String, File> newClassNameLocations) throws MalformedURLException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String name = file.getName();
            if (file.isFile() && name.endsWith(".class")) {
                String className = prefix + name.substring(0, name.lastIndexOf(46));
                newClassNameLocations.put(className, location);
                continue;
            }
            if (!file.isDirectory()) continue;
            ClasspathCache.loadClassNamesFromDirectory(file, prefix + name + ".", location, newClassNameLocations);
        }
    }

    private static void loadClassNamesFromJarFile(File jarFile, Multimap<String, File> newClassNameLocations) throws IOException {
        Closer closer = Closer.create();
        FileInputStream s = new FileInputStream(jarFile);
        JarInputStream jarIn = closer.register(new JarInputStream(s));
        try {
            ClasspathCache.loadClassNamesFromManifestClassPath(jarIn, jarFile, newClassNameLocations);
            ClasspathCache.loadClassNamesFromJarInputStream(jarIn, jarFile, newClassNameLocations);
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    private static void loadClassNamesFromManifestClassPath(JarInputStream jarIn, File jarFile, Multimap<String, File> newClassNameLocations) {
        Manifest manifest = jarIn.getManifest();
        if (manifest == null) {
            return;
        }
        String classpath = manifest.getMainAttributes().getValue("Class-Path");
        if (classpath == null) {
            return;
        }
        URI baseUri = jarFile.toURI();
        for (String path : Splitter.on(' ').omitEmptyStrings().split(classpath)) {
            File file = new File(baseUri.resolve(path));
            ClasspathCache.loadClassNames(file, newClassNameLocations);
        }
    }

    private static void loadClassNamesFromJarInputStream(JarInputStream jarIn, File jarFile, Multimap<String, File> newClassNameLocations) throws IOException {
        JarEntry jarEntry;
        while ((jarEntry = jarIn.getNextJarEntry()) != null) {
            String name;
            if (jarEntry.isDirectory() || !(name = jarEntry.getName()).endsWith(".class")) continue;
            String className = name.substring(0, name.lastIndexOf(46)).replace('/', '.');
            newClassNameLocations.put(className, jarFile);
        }
    }

    private static File getFileFromJBossVfsURL(URL url, ClassLoader loader) throws Exception {
        Object virtualFile = url.openConnection().getContent();
        Class<?> virtualFileClass = loader.loadClass("org.jboss.vfs.VirtualFile");
        Method getPhysicalFileMethod = Reflections.getMethod(virtualFileClass, "getPhysicalFile", new Class[0]);
        Method getNameMethod = Reflections.getMethod(virtualFileClass, "getName", new Class[0]);
        File physicalFile = (File)Reflections.invoke(getPhysicalFileMethod, virtualFile, new Object[0]);
        Preconditions.checkNotNull(physicalFile, "org.jboss.vfs.VirtualFile.getPhysicalFile() returned null");
        String name = (String)Reflections.invoke(getNameMethod, virtualFile, new Object[0]);
        Preconditions.checkNotNull(name, "org.jboss.vfs.VirtualFile.getName() returned null");
        return new File(physicalFile.getParentFile(), name);
    }

    private static class AnalyzingClassVisitor
    extends ClassVisitor {
        private final List<UiAnalyzedMethod> analyzedMethods = Lists.newArrayList();

        private AnalyzingClassVisitor() {
            super(327680);
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int access, String name, String desc, @Nullable String signature, String[] exceptions) {
            if ((access & 0x1000) != 0 || (access & 0x100) != 0) {
                return null;
            }
            if (name.equals("<init>")) {
                return null;
            }
            UiAnalyzedMethod.Builder builder = UiAnalyzedMethod.builder();
            builder.name(name);
            for (Type parameterType : Type.getArgumentTypes(desc)) {
                builder.addParameterTypes(parameterType.getClassName());
            }
            builder.returnType(Type.getReturnType(desc).getClassName());
            builder.modifiers(access);
            if (exceptions != null) {
                for (String exception : exceptions) {
                    builder.addExceptions(ClassNames.fromInternalName(exception));
                }
            }
            this.analyzedMethods.add(builder.build());
            return null;
        }

        private List<UiAnalyzedMethod> getAnalyzedMethods() {
            return this.analyzedMethods;
        }
    }

    private static class PartialClassNameMatcher {
        private final String partialClassNameUpper;
        private final String prefixedPartialClassNameUpper1;
        private final String prefixedPartialClassNameUpper2;

        private PartialClassNameMatcher(String partialClassName) {
            this.partialClassNameUpper = partialClassName.toUpperCase(Locale.ENGLISH);
            this.prefixedPartialClassNameUpper1 = '.' + this.partialClassNameUpper;
            this.prefixedPartialClassNameUpper2 = '$' + this.partialClassNameUpper;
        }

        private boolean isPotentialFullMatch(String classNameUpper) {
            return classNameUpper.equals(this.partialClassNameUpper) || classNameUpper.endsWith(this.prefixedPartialClassNameUpper1) || classNameUpper.endsWith(this.prefixedPartialClassNameUpper2);
        }

        private boolean isPotentialMatch(String classNameUpper) {
            return classNameUpper.startsWith(this.partialClassNameUpper) || classNameUpper.contains(this.prefixedPartialClassNameUpper1) || classNameUpper.contains(this.prefixedPartialClassNameUpper2);
        }
    }
}

