/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.common.Encryption;
import org.glowroot.common.ObjectMappers;
import org.glowroot.config.AdvancedConfig;
import org.glowroot.config.AnonymousAccess;
import org.glowroot.config.ConfigService;
import org.glowroot.config.GeneralConfig;
import org.glowroot.config.PluginConfig;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.config.PropertyDescriptor;
import org.glowroot.config.PropertyValue;
import org.glowroot.config.SmtpConfig;
import org.glowroot.config.StorageConfig;
import org.glowroot.config.UserInterfaceConfig;
import org.glowroot.config.UserRecordingConfig;
import org.glowroot.local.store.AlertingService;
import org.glowroot.local.store.CappedDatabase;
import org.glowroot.local.store.MailService;
import org.glowroot.local.ui.AdvancedConfigDto;
import org.glowroot.local.ui.AdvancedConfigResponse;
import org.glowroot.local.ui.GET;
import org.glowroot.local.ui.GeneralConfigDto;
import org.glowroot.local.ui.HttpServer;
import org.glowroot.local.ui.HttpSessionManager;
import org.glowroot.local.ui.JsonService;
import org.glowroot.local.ui.JsonServiceException;
import org.glowroot.local.ui.POST;
import org.glowroot.local.ui.PasswordHash;
import org.glowroot.local.ui.PluginConfigDto;
import org.glowroot.local.ui.PluginConfigResponse;
import org.glowroot.local.ui.PluginResponse;
import org.glowroot.local.ui.SmtpConfigDto;
import org.glowroot.local.ui.SmtpConfigResponse;
import org.glowroot.local.ui.StorageConfigDto;
import org.glowroot.local.ui.UserInterfaceConfigDto;
import org.glowroot.local.ui.UserInterfaceConfigResponse;
import org.glowroot.local.ui.UserRecordingConfigDto;
import org.glowroot.shaded.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.shaded.google.common.base.Charsets;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.javax.mail.Message;
import org.glowroot.shaded.javax.mail.Session;
import org.glowroot.shaded.javax.mail.internet.InternetAddress;
import org.glowroot.shaded.javax.mail.internet.MimeMessage;
import org.glowroot.shaded.netty.buffer.ByteBuf;
import org.glowroot.shaded.netty.buffer.Unpooled;
import org.glowroot.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.shaded.netty.handler.codec.http.HttpVersion;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.TransactionModule;
import org.immutables.value.Value;

@JsonService
class ConfigJsonService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigJsonService.class);
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final ConfigService configService;
    private final CappedDatabase cappedDatabase;
    private final ImmutableList<PluginDescriptor> pluginDescriptors;
    private final HttpSessionManager httpSessionManager;
    private final TransactionModule transactionModule;
    private final MailService mailService;
    @MonotonicNonNull
    private volatile HttpServer httpServer;

    ConfigJsonService(ConfigService configService, CappedDatabase cappedDatabase, List<PluginDescriptor> pluginDescriptors, HttpSessionManager httpSessionManager, TransactionModule transactionModule, MailService mailService) {
        this.configService = configService;
        this.cappedDatabase = cappedDatabase;
        this.pluginDescriptors = ImmutableList.copyOf(pluginDescriptors);
        this.httpSessionManager = httpSessionManager;
        this.transactionModule = transactionModule;
        this.mailService = mailService;
    }

    void setHttpServer(HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    @GET(value="/backend/config/general")
    String getGeneralConfig() throws Exception {
        GeneralConfig config = this.configService.getGeneralConfig();
        return mapper.writeValueAsString(GeneralConfigDtoBase.fromConfig(config));
    }

    @GET(value="/backend/config/ui")
    String getUserInterfaceConfig() throws Exception {
        Preconditions.checkNotNull(this.httpServer);
        return this.getUserInterface(false);
    }

    @GET(value="/backend/config/storage")
    String getStorageConfig() throws Exception {
        StorageConfig config = this.configService.getStorageConfig();
        return mapper.writeValueAsString(StorageConfigDtoBase.fromConfig(config));
    }

    @GET(value="/backend/config/smtp")
    String getSmtpConfig() throws Exception {
        SmtpConfig config = this.configService.getSmtpConfig();
        String localServerName = InetAddress.getLocalHost().getHostName();
        return mapper.writeValueAsString(SmtpConfigResponse.builder().config(SmtpConfigDtoBase.fromConfig(config)).localServerName(localServerName).build());
    }

    @GET(value="/backend/config/user-recording")
    String getUserRecordingConfig() throws Exception {
        UserRecordingConfig config = this.configService.getUserRecordingConfig();
        return mapper.writeValueAsString(UserRecordingConfigDtoBase.fromConfig(config));
    }

    @GET(value="/backend/config/advanced")
    String getAdvancedConfig() throws Exception {
        AdvancedConfig config = this.configService.getAdvancedConfig();
        return mapper.writeValueAsString(AdvancedConfigResponse.builder().config(AdvancedConfigDtoBase.fromConfig(config)).timerWrapperMethodsActive(this.transactionModule.isTimerWrapperMethods()).build());
    }

    @GET(value="/backend/config/plugins")
    String getPlugins() throws Exception {
        ArrayList<PluginResponse> pluginResponses = Lists.newArrayList();
        for (PluginDescriptor pluginDescriptor : this.pluginDescriptors) {
            PluginConfig pluginConfig = this.configService.getPluginConfig(pluginDescriptor.id());
            Preconditions.checkNotNull(pluginConfig);
            pluginResponses.add(PluginResponse.builder().id(pluginDescriptor.id()).name(pluginDescriptor.name()).enabled(pluginConfig.enabled()).build());
        }
        return mapper.writeValueAsString(pluginResponses);
    }

    @GET(value="/backend/config/plugin/(.+)")
    String getPluginConfig(String pluginId) throws Exception {
        PluginConfig config = this.configService.getPluginConfig(pluginId);
        PluginDescriptor pluginDescriptor = null;
        for (PluginDescriptor descriptor : this.pluginDescriptors) {
            if (!descriptor.id().equals(pluginId)) continue;
            pluginDescriptor = descriptor;
            break;
        }
        if (config == null || pluginDescriptor == null) {
            throw new IllegalArgumentException("Plugin id not found: " + pluginId);
        }
        return mapper.writeValueAsString(PluginConfigResponse.builder().name(pluginDescriptor.name()).addAllPropertyDescriptors(pluginDescriptor.properties()).config(PluginConfigDtoBase.fromConfig(config)).build());
    }

    @POST(value="/backend/config/general")
    String updateGeneralConfig(String content) throws Exception {
        GeneralConfigDto configDto = mapper.readValue(content, GeneralConfigDto.class);
        try {
            this.configService.updateGeneralConfig(configDto.toConfig(), configDto.version());
        }
        catch (ConfigService.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getGeneralConfig();
    }

    @POST(value="/backend/config/ui")
    Object updateUserInterfaceConfig(String content) throws Exception {
        UserInterfaceConfig config;
        Preconditions.checkNotNull(this.httpServer);
        UserInterfaceConfigDto configDto = mapper.readValue(content, UserInterfaceConfigDto.class);
        configDto.validate();
        UserInterfaceConfig priorConfig = this.configService.getUserInterfaceConfig();
        try {
            config = this.toConfig(configDto, priorConfig);
        }
        catch (CurrentPasswordIncorrectException e) {
            return "{\"currentPasswordIncorrect\":true}";
        }
        try {
            this.configService.updateUserInterfaceConfig(config, configDto.version());
        }
        catch (ConfigService.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.onSuccessfulUserInterfaceUpdate(priorConfig, config);
    }

    @POST(value="/backend/config/storage")
    String updateStorageConfig(String content) throws Exception {
        StorageConfigDto configDto = mapper.readValue(content, StorageConfigDto.class);
        try {
            this.configService.updateStorageConfig(configDto.toConfig(), configDto.version());
        }
        catch (ConfigService.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        this.cappedDatabase.resize(this.configService.getStorageConfig().cappedDatabaseSizeMb() * 1024);
        return this.getStorageConfig();
    }

    @POST(value="/backend/config/smtp")
    String updateSmtpConfig(String content) throws Exception {
        SmtpConfigDto configDto = mapper.readValue(content, SmtpConfigDto.class);
        try {
            this.configService.updateSmtpConfig(this.toConfig(configDto), configDto.version());
        }
        catch (ConfigService.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getSmtpConfig();
    }

    @POST(value="/backend/config/user-recording")
    String updateUserRecordingConfig(String content) throws Exception {
        UserRecordingConfigDto configDto = mapper.readValue(content, UserRecordingConfigDto.class);
        try {
            this.configService.updateUserRecordingConfig(configDto.toConfig(), configDto.version());
        }
        catch (ConfigService.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getUserRecordingConfig();
    }

    @POST(value="/backend/config/advanced")
    String updateAdvancedConfig(String content) throws Exception {
        AdvancedConfigDto configDto = mapper.readValue(content, AdvancedConfigDto.class);
        try {
            this.configService.updateAdvancedConfig(configDto.toConfig(), configDto.version());
        }
        catch (ConfigService.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getAdvancedConfig();
    }

    @POST(value="/backend/config/plugin/(.+)")
    String updatePluginConfig(String pluginId, String content) throws Exception {
        PluginConfigDto configDto = mapper.readValue(content, PluginConfigDto.class);
        try {
            this.configService.updatePluginConfig(configDto.toConfig(pluginId), configDto.version());
        }
        catch (ConfigService.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getPluginConfig(pluginId);
    }

    @POST(value="/backend/config/send-test-email")
    void sendTestEmail(String content) throws Exception {
        String fromDisplayName;
        SmtpConfigDto configDto = mapper.readValue(content, SmtpConfigDto.class);
        String testEmailRecipient = configDto.testEmailRecipient();
        Preconditions.checkNotNull(testEmailRecipient);
        Session session = AlertingService.createMailSession(this.toConfig(configDto), this.configService.getSecretKey());
        MimeMessage message = new MimeMessage(session);
        String fromEmailAddress = configDto.fromEmailAddress();
        if (fromEmailAddress.isEmpty()) {
            String localServerName = InetAddress.getLocalHost().getHostName();
            fromEmailAddress = "glowroot@" + localServerName;
        }
        if ((fromDisplayName = configDto.fromDisplayName()).isEmpty()) {
            fromDisplayName = "Glowroot";
        }
        ((Message)message).setFrom(new InternetAddress(fromEmailAddress, fromDisplayName));
        InternetAddress to = new InternetAddress(testEmailRecipient);
        message.setRecipient(Message.RecipientType.TO, to);
        ((Message)message).setSubject("Test email from Glowroot (EOM)");
        message.setText("");
        this.mailService.send(message);
    }

    @RequiresNonNull(value={"httpServer"})
    private Object onSuccessfulUserInterfaceUpdate(UserInterfaceConfig priorConfig, UserInterfaceConfig config) throws JsonProcessingException {
        boolean portChangedSucceeded = false;
        boolean portChangedFailed = false;
        if (priorConfig.port() != config.port()) {
            try {
                this.httpServer.changePort(config.port());
                portChangedSucceeded = true;
            }
            catch (HttpServer.PortChangeFailedException e) {
                logger.error(e.getMessage(), e);
                portChangedFailed = true;
            }
        }
        String responseText = this.getUserInterface(portChangedFailed);
        ByteBuf responseContent = Unpooled.copiedBuffer(responseText, Charsets.ISO_8859_1);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, responseContent);
        if (portChangedSucceeded) {
            response.headers().set("Glowroot-Port-Changed", (Object)"true");
        }
        if (!priorConfig.adminPasswordEnabled() && config.adminPasswordEnabled()) {
            this.httpSessionManager.createSession(response, true);
        } else if (priorConfig.adminPasswordEnabled() && !config.adminPasswordEnabled()) {
            this.httpSessionManager.clearAllSessions();
            this.httpSessionManager.deleteSessionCookie(response);
        }
        return response;
    }

    @RequiresNonNull(value={"httpServer"})
    private String getUserInterface(boolean portChangeFailed) throws JsonProcessingException {
        UserInterfaceConfig config = this.configService.getUserInterfaceConfig();
        UserInterfaceConfigDto configDto = UserInterfaceConfigDto.builder().port(config.port()).adminPasswordEnabled(config.adminPasswordEnabled()).readOnlyPasswordEnabled(config.readOnlyPasswordEnabled()).anonymousAccess(config.anonymousAccess()).sessionTimeoutMinutes(config.sessionTimeoutMinutes()).version(config.version()).build();
        return mapper.writeValueAsString(UserInterfaceConfigResponse.builder().config(configDto).activePort(this.httpServer.getPort()).portChangeFailed(portChangeFailed).build());
    }

    private UserInterfaceConfig toConfig(UserInterfaceConfigDto configDto, UserInterfaceConfig priorConfig) throws Exception {
        UserInterfaceConfig.Builder builder = UserInterfaceConfig.builder().port(configDto.port()).sessionTimeoutMinutes(configDto.sessionTimeoutMinutes());
        if (configDto.currentAdminPassword().length() > 0 || configDto.newAdminPassword().length() > 0) {
            AdminPasswordHelper adminPasswordHelper = new AdminPasswordHelper(configDto.currentAdminPassword(), configDto.newAdminPassword(), priorConfig.adminPasswordHash());
            builder.adminPasswordHash(adminPasswordHelper.verifyAndGenerateNewPasswordHash());
        } else {
            builder.adminPasswordHash(priorConfig.adminPasswordHash());
        }
        if (!configDto.readOnlyPasswordEnabled()) {
            builder.readOnlyPasswordHash("");
        } else if (configDto.readOnlyPasswordEnabled() && !configDto.newReadOnlyPassword().isEmpty()) {
            String readOnlyPasswordHash = PasswordHash.createHash(configDto.newReadOnlyPassword());
            builder.readOnlyPasswordHash(readOnlyPasswordHash);
        } else {
            builder.readOnlyPasswordHash(priorConfig.readOnlyPasswordHash());
        }
        if (priorConfig.anonymousAccess() != AnonymousAccess.ADMIN && configDto.anonymousAccess() == AnonymousAccess.ADMIN && configDto.currentAdminPassword().isEmpty()) {
            throw new IllegalStateException();
        }
        builder.anonymousAccess(configDto.anonymousAccess());
        return builder.build();
    }

    private SmtpConfig toConfig(SmtpConfigDto configDto) throws Exception {
        SmtpConfig.Builder builder = SmtpConfig.builder().fromEmailAddress(configDto.fromEmailAddress()).fromDisplayName(configDto.fromDisplayName()).host(configDto.host()).port(configDto.port()).ssl(configDto.ssl()).username(configDto.username()).putAllAdditionalProperties(configDto.additionalProperties());
        if (!configDto.passwordExists()) {
            builder.encryptedPassword("");
        } else if (configDto.passwordExists() && !configDto.newPassword().isEmpty()) {
            String newEncryptedPassword = Encryption.encrypt(configDto.newPassword(), this.configService.getSecretKey());
            builder.encryptedPassword(newEncryptedPassword);
        } else {
            SmtpConfig priorConfig = this.configService.getSmtpConfig();
            builder.encryptedPassword(priorConfig.encryptedPassword());
        }
        return builder.build();
    }

    private static class CurrentPasswordIncorrectException
    extends Exception {
        private CurrentPasswordIncorrectException() {
        }
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class PluginConfigDtoBase {
        PluginConfigDtoBase() {
        }

        abstract boolean enabled();

        abstract Map<String, PropertyValue> properties();

        abstract String version();

        PluginConfig toConfig(String id) {
            return PluginConfig.builder().id(id).enabled(this.enabled()).putAllProperties(this.properties()).build();
        }

        private static PluginConfigDto fromConfig(PluginConfig config) {
            return PluginConfigDto.builder().enabled(config.enabled()).putAllProperties(config.properties()).version(config.version()).build();
        }
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class AdvancedConfigDtoBase {
        AdvancedConfigDtoBase() {
        }

        abstract boolean timerWrapperMethods();

        abstract boolean weavingTimer();

        abstract int immediatePartialStoreThresholdSeconds();

        abstract int maxAggregateQueriesPerQueryType();

        abstract int maxTraceEntriesPerTransaction();

        abstract int maxStackTraceSamplesPerTransaction();

        abstract boolean captureThreadInfo();

        abstract boolean captureGcInfo();

        abstract int mbeanGaugeNotFoundDelaySeconds();

        abstract int internalQueryTimeoutSeconds();

        abstract String version();

        AdvancedConfig toConfig() {
            return AdvancedConfig.builder().timerWrapperMethods(this.timerWrapperMethods()).weavingTimer(this.weavingTimer()).immediatePartialStoreThresholdSeconds(this.immediatePartialStoreThresholdSeconds()).maxAggregateQueriesPerQueryType(this.maxAggregateQueriesPerQueryType()).maxTraceEntriesPerTransaction(this.maxTraceEntriesPerTransaction()).maxStackTraceSamplesPerTransaction(this.maxStackTraceSamplesPerTransaction()).captureThreadInfo(this.captureThreadInfo()).captureGcInfo(this.captureGcInfo()).mbeanGaugeNotFoundDelaySeconds(this.mbeanGaugeNotFoundDelaySeconds()).internalQueryTimeoutSeconds(this.internalQueryTimeoutSeconds()).build();
        }

        private static AdvancedConfigDto fromConfig(AdvancedConfig config) {
            return AdvancedConfigDto.builder().timerWrapperMethods(config.timerWrapperMethods()).weavingTimer(config.weavingTimer()).immediatePartialStoreThresholdSeconds(config.immediatePartialStoreThresholdSeconds()).maxAggregateQueriesPerQueryType(config.maxAggregateQueriesPerQueryType()).maxTraceEntriesPerTransaction(config.maxTraceEntriesPerTransaction()).maxStackTraceSamplesPerTransaction(config.maxStackTraceSamplesPerTransaction()).captureThreadInfo(config.captureThreadInfo()).captureGcInfo(config.captureGcInfo()).mbeanGaugeNotFoundDelaySeconds(config.mbeanGaugeNotFoundDelaySeconds()).internalQueryTimeoutSeconds(config.internalQueryTimeoutSeconds()).version(config.version()).build();
        }
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class UserRecordingConfigDtoBase {
        UserRecordingConfigDtoBase() {
        }

        abstract boolean enabled();

        abstract String user();

        abstract int profileIntervalMillis();

        abstract String version();

        UserRecordingConfig toConfig() {
            return UserRecordingConfig.builder().enabled(this.enabled()).user(this.user()).profileIntervalMillis(this.profileIntervalMillis()).build();
        }

        private static UserRecordingConfigDto fromConfig(UserRecordingConfig config) {
            return UserRecordingConfigDto.builder().enabled(config.enabled()).user(config.user()).profileIntervalMillis(config.profileIntervalMillis()).version(config.version()).build();
        }
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class SmtpConfigDtoBase {
        SmtpConfigDtoBase() {
        }

        abstract String fromEmailAddress();

        abstract String fromDisplayName();

        abstract String host();

        @Nullable
        abstract Integer port();

        abstract boolean ssl();

        abstract String username();

        abstract boolean passwordExists();

        abstract Map<String, String> additionalProperties();

        String newPassword() {
            return "";
        }

        @Nullable
        abstract String testEmailRecipient();

        abstract String version();

        private static SmtpConfigDto fromConfig(SmtpConfig config) {
            return SmtpConfigDto.builder().fromEmailAddress(config.fromEmailAddress()).fromDisplayName(config.fromDisplayName()).host(config.host()).port(config.port()).ssl(config.ssl()).username(config.username()).passwordExists(!config.encryptedPassword().isEmpty()).putAllAdditionalProperties(config.additionalProperties()).version(config.version()).build();
        }
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class StorageConfigDtoBase {
        StorageConfigDtoBase() {
        }

        abstract int aggregateExpirationHours();

        abstract int traceExpirationHours();

        abstract int gaugeExpirationHours();

        abstract int cappedDatabaseSizeMb();

        abstract String version();

        StorageConfig toConfig() {
            return StorageConfig.builder().aggregateExpirationHours(this.aggregateExpirationHours()).traceExpirationHours(this.traceExpirationHours()).gaugeExpirationHours(this.gaugeExpirationHours()).cappedDatabaseSizeMb(this.cappedDatabaseSizeMb()).build();
        }

        private static StorageConfigDto fromConfig(StorageConfig config) {
            return StorageConfigDto.builder().aggregateExpirationHours(config.aggregateExpirationHours()).traceExpirationHours(config.traceExpirationHours()).gaugeExpirationHours(config.gaugeExpirationHours()).cappedDatabaseSizeMb(config.cappedDatabaseSizeMb()).version(config.version()).build();
        }
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class UserInterfaceConfigDtoBase {
        UserInterfaceConfigDtoBase() {
        }

        abstract int port();

        abstract boolean adminPasswordEnabled();

        abstract boolean readOnlyPasswordEnabled();

        abstract AnonymousAccess anonymousAccess();

        String currentAdminPassword() {
            return "";
        }

        String newAdminPassword() {
            return "";
        }

        String newReadOnlyPassword() {
            return "";
        }

        abstract int sessionTimeoutMinutes();

        abstract String version();

        void validate() {
            if (this.readOnlyPasswordEnabled()) {
                Preconditions.checkState(this.adminPasswordEnabled());
            }
            switch (this.anonymousAccess()) {
                case ADMIN: {
                    Preconditions.checkState(!this.adminPasswordEnabled());
                    Preconditions.checkState(!this.readOnlyPasswordEnabled());
                    break;
                }
                case READ_ONLY: {
                    Preconditions.checkState(this.adminPasswordEnabled());
                    Preconditions.checkState(!this.readOnlyPasswordEnabled());
                    break;
                }
                case NONE: {
                    Preconditions.checkState(this.adminPasswordEnabled());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected anonymous access: " + (Object)((Object)this.anonymousAccess()));
                }
            }
        }
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class GeneralConfigDtoBase {
        GeneralConfigDtoBase() {
        }

        abstract boolean enabled();

        abstract int traceStoreThresholdMillis();

        abstract int profilingIntervalMillis();

        abstract String defaultDisplayedTransactionType();

        abstract ImmutableList<Double> defaultDisplayedPercentiles();

        abstract String version();

        GeneralConfig toConfig() {
            return GeneralConfig.builder().enabled(this.enabled()).traceStoreThresholdMillis(this.traceStoreThresholdMillis()).profilingIntervalMillis(this.profilingIntervalMillis()).defaultDisplayedTransactionType(this.defaultDisplayedTransactionType()).defaultDisplayedPercentiles(Ordering.natural().immutableSortedCopy(this.defaultDisplayedPercentiles())).build();
        }

        private static GeneralConfigDto fromConfig(GeneralConfig config) {
            return GeneralConfigDto.builder().enabled(config.enabled()).traceStoreThresholdMillis(config.traceStoreThresholdMillis()).profilingIntervalMillis(config.profilingIntervalMillis()).defaultDisplayedTransactionType(config.defaultDisplayedTransactionType()).defaultDisplayedPercentiles(config.defaultDisplayedPercentiles()).version(config.version()).build();
        }
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class PluginConfigResponseBase {
        PluginConfigResponseBase() {
        }

        abstract String name();

        abstract PluginConfigDto config();

        abstract ImmutableList<PropertyDescriptor> propertyDescriptors();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class PluginResponseBase {
        PluginResponseBase() {
        }

        abstract String id();

        abstract String name();

        abstract boolean enabled();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class AdvancedConfigResponseBase {
        AdvancedConfigResponseBase() {
        }

        abstract AdvancedConfigDto config();

        abstract boolean timerWrapperMethodsActive();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class SmtpConfigResponseBase {
        SmtpConfigResponseBase() {
        }

        abstract SmtpConfigDto config();

        abstract String localServerName();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class UserInterfaceConfigResponseBase {
        UserInterfaceConfigResponseBase() {
        }

        abstract UserInterfaceConfigDto config();

        abstract int activePort();

        abstract boolean portChangeFailed();
    }

    private static class AdminPasswordHelper {
        private final String currentPassword;
        private final String newPassword;
        private final String originalPasswordHash;

        private AdminPasswordHelper(String currentPassword, String newPassword, String originalPasswordHash) {
            this.currentPassword = currentPassword;
            this.newPassword = newPassword;
            this.originalPasswordHash = originalPasswordHash;
        }

        private String verifyAndGenerateNewPasswordHash() throws Exception {
            if (this.enablePassword()) {
                Preconditions.checkState(this.originalPasswordHash.isEmpty(), "Password is already enabled");
                return PasswordHash.createHash(this.newPassword);
            }
            if (!PasswordHash.validatePassword(this.currentPassword, this.originalPasswordHash)) {
                throw new CurrentPasswordIncorrectException();
            }
            if (this.disablePassword()) {
                return "";
            }
            if (this.changePassword()) {
                return PasswordHash.createHash(this.newPassword);
            }
            throw new IllegalStateException("Current and new password are both empty");
        }

        private boolean enablePassword() {
            return this.currentPassword.isEmpty() && !this.newPassword.isEmpty();
        }

        private boolean disablePassword() {
            return !this.currentPassword.isEmpty() && this.newPassword.isEmpty();
        }

        private boolean changePassword() {
            return !this.currentPassword.isEmpty() && !this.newPassword.isEmpty();
        }
    }
}

