/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.store.AggregateDao;
import org.glowroot.local.ui.ErrorJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
final class ErrorSummaryRequest
extends ErrorJsonService.ErrorSummaryRequestBase {
    private final long from;
    private final long to;
    private final String transactionType;
    private final AggregateDao.ErrorSummarySortOrder sortOrder;
    private final int limit;

    private ErrorSummaryRequest(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.transactionType = builder.transactionType;
        this.sortOrder = builder.sortOrder;
        this.limit = builder.limit;
    }

    private ErrorSummaryRequest(ErrorSummaryRequest original, long from, long to, String transactionType, AggregateDao.ErrorSummarySortOrder sortOrder, int limit) {
        this.from = from;
        this.to = to;
        this.transactionType = transactionType;
        this.sortOrder = sortOrder;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="sortOrder")
    public AggregateDao.ErrorSummarySortOrder sortOrder() {
        return this.sortOrder;
    }

    @Override
    @JsonProperty(value="limit")
    public int limit() {
        return this.limit;
    }

    public final ErrorSummaryRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        long newValue = value;
        return new ErrorSummaryRequest(this, newValue, this.to, this.transactionType, this.sortOrder, this.limit);
    }

    public final ErrorSummaryRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        long newValue = value;
        return new ErrorSummaryRequest(this, this.from, newValue, this.transactionType, this.sortOrder, this.limit);
    }

    public final ErrorSummaryRequest withTransactionType(String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ErrorSummaryRequest(this, this.from, this.to, newValue, this.sortOrder, this.limit);
    }

    public final ErrorSummaryRequest withSortOrder(AggregateDao.ErrorSummarySortOrder value) {
        if (this.sortOrder == value) {
            return this;
        }
        AggregateDao.ErrorSummarySortOrder newValue = Preconditions.checkNotNull(value);
        return new ErrorSummaryRequest(this, this.from, this.to, this.transactionType, newValue, this.limit);
    }

    public final ErrorSummaryRequest withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        int newValue = value;
        return new ErrorSummaryRequest(this, this.from, this.to, this.transactionType, this.sortOrder, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ErrorSummaryRequest && this.equalTo((ErrorSummaryRequest)another);
    }

    private boolean equalTo(ErrorSummaryRequest another) {
        return this.from == another.from && this.to == another.to && this.transactionType.equals(another.transactionType) && this.sortOrder.equals((Object)another.sortOrder) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.from);
        h = h * 17 + Longs.hashCode(this.to);
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + this.sortOrder.hashCode();
        h = h * 17 + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ErrorSummaryRequest").add("from", this.from).add("to", this.to).add("transactionType", this.transactionType).add("sortOrder", (Object)this.sortOrder).add("limit", this.limit).toString();
    }

    @JsonCreator
    public static ErrorSummaryRequest fromAllAttributes(@JsonProperty(value="from") @Nullable Long from, @JsonProperty(value="to") @Nullable Long to, @JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="sortOrder") @Nullable AggregateDao.ErrorSummarySortOrder sortOrder, @JsonProperty(value="limit") @Nullable Integer limit) {
        Builder builder = ErrorSummaryRequest.builder();
        if (from != null) {
            builder.from(from);
        }
        if (to != null) {
            builder.to(to);
        }
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (sortOrder != null) {
            builder.sortOrder(sortOrder);
        }
        if (limit != null) {
            builder.limit(limit);
        }
        return builder.build();
    }

    static ErrorSummaryRequest copyOf(ErrorJsonService.ErrorSummaryRequestBase instance) {
        if (instance instanceof ErrorSummaryRequest) {
            return (ErrorSummaryRequest)instance;
        }
        return ErrorSummaryRequest.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 31L;
        private static final long INITIALIZED_BIT_FROM = 1L;
        private static final long INITIALIZED_BIT_TO = 2L;
        private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 4L;
        private static final long INITIALIZED_BIT_SORT_ORDER = 8L;
        private static final long INITIALIZED_BIT_LIMIT = 16L;
        private long initializedBitset;
        private long from;
        private long to;
        @Nullable
        private String transactionType;
        @Nullable
        private AggregateDao.ErrorSummarySortOrder sortOrder;
        private int limit;

        private Builder() {
        }

        public final Builder from(ErrorJsonService.ErrorSummaryRequestBase instance) {
            Preconditions.checkNotNull(instance);
            this.from(instance.from());
            this.to(instance.to());
            this.transactionType(instance.transactionType());
            this.sortOrder(instance.sortOrder());
            this.limit(instance.limit());
            return this;
        }

        public final Builder from(long from) {
            this.from = from;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder to(long to) {
            this.to = to;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.transactionType = Preconditions.checkNotNull(transactionType);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder sortOrder(AggregateDao.ErrorSummarySortOrder sortOrder) {
            this.sortOrder = Preconditions.checkNotNull(sortOrder);
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initializedBitset |= 0x10L;
            return this;
        }

        public ErrorSummaryRequest build() {
            this.checkRequiredAttributes();
            return new ErrorSummaryRequest(this);
        }

        private boolean fromIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean toIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean transactionTypeIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean sortOrderIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean limitIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 31L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.fromIsSet()) {
                attributes.add("from");
            }
            if (!this.toIsSet()) {
                attributes.add("to");
            }
            if (!this.transactionTypeIsSet()) {
                attributes.add("transactionType");
            }
            if (!this.sortOrderIsSet()) {
                attributes.add("sortOrder");
            }
            if (!this.limitIsSet()) {
                attributes.add("limit");
            }
            return "Cannot build ErrorSummaryRequest, some of required attributes are not set " + attributes;
        }
    }
}

