/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.GaugeConfigDto;
import org.glowroot.local.ui.GaugeJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class GaugeConfigWithWarningMessages
extends GaugeJsonService.GaugeConfigWithWarningMessagesBase {
    private final GaugeConfigDto config;
    private final ImmutableList<String> warningMessages;

    private GaugeConfigWithWarningMessages(Builder builder) {
        this.config = builder.config;
        this.warningMessages = builder.warningMessagesBuilder.build();
    }

    private GaugeConfigWithWarningMessages(GaugeConfigWithWarningMessages original, GaugeConfigDto config, ImmutableList<String> warningMessages) {
        this.config = config;
        this.warningMessages = warningMessages;
    }

    @Override
    @JsonProperty(value="config")
    public GaugeConfigDto config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="warningMessages")
    public ImmutableList<String> warningMessages() {
        return this.warningMessages;
    }

    public final GaugeConfigWithWarningMessages withConfig(GaugeConfigDto value) {
        if (this.config == value) {
            return this;
        }
        GaugeConfigDto newValue = Preconditions.checkNotNull(value);
        return new GaugeConfigWithWarningMessages(this, newValue, this.warningMessages);
    }

    public final GaugeConfigWithWarningMessages withWarningMessages(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new GaugeConfigWithWarningMessages(this, this.config, newValue);
    }

    public final GaugeConfigWithWarningMessages withWarningMessages(Iterable<String> elements) {
        if (this.warningMessages == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new GaugeConfigWithWarningMessages(this, this.config, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GaugeConfigWithWarningMessages && this.equalTo((GaugeConfigWithWarningMessages)another);
    }

    private boolean equalTo(GaugeConfigWithWarningMessages another) {
        return this.config.equals(another.config) && this.warningMessages.equals(another.warningMessages);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.warningMessages.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GaugeConfigWithWarningMessages").add("config", this.config).add("warningMessages", this.warningMessages).toString();
    }

    @JsonCreator
    public static GaugeConfigWithWarningMessages fromAllAttributes(@JsonProperty(value="config") @Nullable GaugeConfigDto config, @JsonProperty(value="warningMessages") @Nullable ImmutableList<String> warningMessages) {
        Builder builder = GaugeConfigWithWarningMessages.builder();
        if (config != null) {
            builder.config(config);
        }
        if (warningMessages != null) {
            builder.addAllWarningMessages(warningMessages);
        }
        return builder.build();
    }

    static GaugeConfigWithWarningMessages copyOf(GaugeJsonService.GaugeConfigWithWarningMessagesBase instance) {
        if (instance instanceof GaugeConfigWithWarningMessages) {
            return (GaugeConfigWithWarningMessages)instance;
        }
        return GaugeConfigWithWarningMessages.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_CONFIG = 1L;
        private long initializedBitset;
        @Nullable
        private GaugeConfigDto config;
        private ImmutableList.Builder<String> warningMessagesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(GaugeJsonService.GaugeConfigWithWarningMessagesBase instance) {
            Preconditions.checkNotNull(instance);
            this.config(instance.config());
            this.addAllWarningMessages(instance.warningMessages());
            return this;
        }

        public final Builder config(GaugeConfigDto config) {
            this.config = Preconditions.checkNotNull(config);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addWarningMessages(String element) {
            this.warningMessagesBuilder.add((Object)element);
            return this;
        }

        public final Builder addWarningMessages(String ... elements) {
            this.warningMessagesBuilder.add(elements);
            return this;
        }

        public final Builder warningMessages(Iterable<String> elements) {
            this.warningMessagesBuilder = ImmutableList.builder();
            return this.addAllWarningMessages(elements);
        }

        public final Builder addAllWarningMessages(Iterable<String> elements) {
            this.warningMessagesBuilder.addAll((Iterable)elements);
            return this;
        }

        public GaugeConfigWithWarningMessages build() {
            this.checkRequiredAttributes();
            return new GaugeConfigWithWarningMessages(this);
        }

        private boolean configIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.configIsSet()) {
                attributes.add("config");
            }
            return "Cannot build GaugeConfigWithWarningMessages, some of required attributes are not set " + attributes;
        }
    }
}

