/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import org.glowroot.local.ui.ConditionalHttpContentCompressor;
import org.glowroot.local.ui.HttpServerHandler;
import org.glowroot.local.ui.HttpService;
import org.glowroot.local.ui.HttpSessionManager;
import org.glowroot.local.ui.LayoutService;
import org.glowroot.shaded.google.common.util.concurrent.ThreadFactoryBuilder;
import org.glowroot.shaded.netty.bootstrap.ServerBootstrap;
import org.glowroot.shaded.netty.channel.Channel;
import org.glowroot.shaded.netty.channel.ChannelInitializer;
import org.glowroot.shaded.netty.channel.ChannelPipeline;
import org.glowroot.shaded.netty.channel.EventLoopGroup;
import org.glowroot.shaded.netty.channel.nio.NioEventLoopGroup;
import org.glowroot.shaded.netty.channel.socket.SocketChannel;
import org.glowroot.shaded.netty.channel.socket.nio.NioServerSocketChannel;
import org.glowroot.shaded.netty.handler.codec.http.HttpObjectAggregator;
import org.glowroot.shaded.netty.handler.codec.http.HttpServerCodec;
import org.glowroot.shaded.netty.handler.stream.ChunkedWriteHandler;
import org.glowroot.shaded.netty.util.internal.logging.InternalLoggerFactory;
import org.glowroot.shaded.netty.util.internal.logging.Slf4JLoggerFactory;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class HttpServer {
    private static final Logger logger = LoggerFactory.getLogger(HttpServer.class);
    private final ServerBootstrap bootstrap;
    private final HttpServerHandler handler;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final String bindAddress;
    private volatile Channel serverChannel;
    private volatile int port;

    HttpServer(String bindAddress, int port, int numWorkerThreads, LayoutService layoutService, Map<Pattern, HttpService> httpServices, HttpSessionManager httpSessionManager, List<Object> jsonServices) throws Exception {
        Channel serverChannel;
        InternalLoggerFactory.setDefaultFactory(new Slf4JLoggerFactory());
        ThreadFactory bossThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Glowroot-Http-Boss-%d").build();
        ThreadFactory workerThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Glowroot-Http-Worker-%d").build();
        this.bossGroup = new NioEventLoopGroup(1, bossThreadFactory);
        this.workerGroup = new NioEventLoopGroup(numWorkerThreads, workerThreadFactory);
        final HttpServerHandler handler = new HttpServerHandler(layoutService, httpServices, httpSessionManager, jsonServices);
        this.bootstrap = new ServerBootstrap();
        ((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new HttpServerCodec());
                p.addLast(new HttpObjectAggregator(0x100000));
                p.addLast(new ConditionalHttpContentCompressor());
                p.addLast(new ChunkedWriteHandler());
                p.addLast(handler);
            }
        });
        this.handler = handler;
        logger.debug("<init>(): binding http server to port {}", (Object)port);
        this.bindAddress = bindAddress;
        try {
            serverChannel = this.bootstrap.bind(new InetSocketAddress(bindAddress, port)).sync().channel();
        }
        catch (Exception e) {
            try {
                serverChannel = this.bootstrap.bind(new InetSocketAddress(bindAddress, 0)).sync().channel();
            }
            catch (Exception f) {
                this.bossGroup.shutdownGracefully();
                this.workerGroup.shutdownGracefully();
                throw f;
            }
            logger.error("error binding to port: {} (bound to port {} instead)", (Object)port, (Object)((InetSocketAddress)serverChannel.localAddress()).getPort());
            logger.debug(e.getMessage(), e);
        }
        this.serverChannel = serverChannel;
        this.port = ((InetSocketAddress)serverChannel.localAddress()).getPort();
        logger.debug("<init>(): http server bound");
    }

    int getPort() {
        return this.port;
    }

    void changePort(int newPort) throws PortChangeFailedException {
        Channel previousServerChannel = this.serverChannel;
        ChangePort changePort = new ChangePort(newPort);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Glowroot-Temporary-Thread").build();
        ExecutorService executor = Executors.newSingleThreadExecutor(threadFactory);
        try {
            executor.submit(changePort).get();
        }
        catch (Exception e) {
            throw new PortChangeFailedException(e);
        }
        finally {
            executor.shutdownNow();
        }
        previousServerChannel.close();
        this.handler.closeAllButCurrent();
    }

    void close() {
        logger.debug("close(): stopping http server");
        this.serverChannel.close().awaitUninterruptibly();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.handler.close();
        logger.debug("close(): http server stopped");
    }

    public static class PortChangeFailedException
    extends Exception {
        private PortChangeFailedException(Exception cause) {
            super(cause);
        }
    }

    private class ChangePort
    implements Runnable {
        private final int newPort;

        ChangePort(int newPort) {
            this.newPort = newPort;
        }

        @Override
        public void run() {
            try {
                InetSocketAddress localAddress = new InetSocketAddress(HttpServer.this.bindAddress, this.newPort);
                HttpServer.this.serverChannel = HttpServer.this.bootstrap.bind(localAddress).sync().channel();
                HttpServer.this.port = this.newPort;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

