/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.InstrumentationConfigDto;
import org.glowroot.local.ui.InstrumentationJsonService;
import org.glowroot.local.ui.MethodSignature;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class InstrumentationConfigResponse
extends InstrumentationJsonService.InstrumentationConfigResponseBase {
    private final InstrumentationConfigDto config;
    private final ImmutableList<MethodSignature> methodSignatures;

    private InstrumentationConfigResponse(Builder builder) {
        this.config = builder.config;
        this.methodSignatures = builder.methodSignaturesBuilder.build();
    }

    private InstrumentationConfigResponse(InstrumentationConfigResponse original, InstrumentationConfigDto config, ImmutableList<MethodSignature> methodSignatures) {
        this.config = config;
        this.methodSignatures = methodSignatures;
    }

    @Override
    @JsonProperty(value="config")
    public InstrumentationConfigDto config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="methodSignatures")
    public ImmutableList<MethodSignature> methodSignatures() {
        return this.methodSignatures;
    }

    public final InstrumentationConfigResponse withConfig(InstrumentationConfigDto value) {
        if (this.config == value) {
            return this;
        }
        InstrumentationConfigDto newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfigResponse(this, newValue, this.methodSignatures);
    }

    public final InstrumentationConfigResponse withMethodSignatures(MethodSignature ... elements) {
        ImmutableList<MethodSignature> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfigResponse(this, this.config, newValue);
    }

    public final InstrumentationConfigResponse withMethodSignatures(Iterable<? extends MethodSignature> elements) {
        if (this.methodSignatures == elements) {
            return this;
        }
        ImmutableList<MethodSignature> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfigResponse(this, this.config, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof InstrumentationConfigResponse && this.equalTo((InstrumentationConfigResponse)another);
    }

    private boolean equalTo(InstrumentationConfigResponse another) {
        return this.config.equals(another.config) && this.methodSignatures.equals(another.methodSignatures);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.methodSignatures.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("InstrumentationConfigResponse").add("config", this.config).add("methodSignatures", this.methodSignatures).toString();
    }

    @JsonCreator
    public static InstrumentationConfigResponse fromAllAttributes(@JsonProperty(value="config") @Nullable InstrumentationConfigDto config, @JsonProperty(value="methodSignatures") @Nullable ImmutableList<MethodSignature> methodSignatures) {
        Builder builder = InstrumentationConfigResponse.builder();
        if (config != null) {
            builder.config(config);
        }
        if (methodSignatures != null) {
            builder.addAllMethodSignatures(methodSignatures);
        }
        return builder.build();
    }

    static InstrumentationConfigResponse copyOf(InstrumentationJsonService.InstrumentationConfigResponseBase instance) {
        if (instance instanceof InstrumentationConfigResponse) {
            return (InstrumentationConfigResponse)instance;
        }
        return InstrumentationConfigResponse.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_CONFIG = 1L;
        private long initializedBitset;
        @Nullable
        private InstrumentationConfigDto config;
        private ImmutableList.Builder<MethodSignature> methodSignaturesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(InstrumentationJsonService.InstrumentationConfigResponseBase instance) {
            Preconditions.checkNotNull(instance);
            this.config(instance.config());
            this.addAllMethodSignatures(instance.methodSignatures());
            return this;
        }

        public final Builder config(InstrumentationConfigDto config) {
            this.config = Preconditions.checkNotNull(config);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addMethodSignatures(MethodSignature element) {
            this.methodSignaturesBuilder.add((Object)element);
            return this;
        }

        public final Builder addMethodSignatures(MethodSignature ... elements) {
            this.methodSignaturesBuilder.add(elements);
            return this;
        }

        public final Builder methodSignatures(Iterable<? extends MethodSignature> elements) {
            this.methodSignaturesBuilder = ImmutableList.builder();
            return this.addAllMethodSignatures(elements);
        }

        public final Builder addAllMethodSignatures(Iterable<? extends MethodSignature> elements) {
            this.methodSignaturesBuilder.addAll(elements);
            return this;
        }

        public InstrumentationConfigResponse build() {
            this.checkRequiredAttributes();
            return new InstrumentationConfigResponse(this);
        }

        private boolean configIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.configIsSet()) {
                attributes.add("config");
            }
            return "Cannot build InstrumentationConfigResponse, some of required attributes are not set " + attributes;
        }
    }
}

