/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.glowroot.api.PluginServices;
import org.glowroot.common.ObjectMappers;
import org.glowroot.config.ConfigService;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.config.UserInterfaceConfig;
import org.glowroot.jvm.HeapDumps;
import org.glowroot.jvm.OptionalService;
import org.glowroot.local.ui.Layout;
import org.glowroot.shaded.fasterxml.jackson.core.JsonFactory;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.google.common.io.CharStreams;

class LayoutService {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final String version;
    private final ConfigService configService;
    private final ImmutableList<PluginDescriptor> pluginDescriptors;
    private final OptionalService<HeapDumps> heapDumps;
    private final long fixedAggregateIntervalSeconds;
    private final long fixedAggregateRollupSeconds;
    private final long fixedGaugeIntervalSeconds;
    private final long fixedGaugeRollupSeconds;
    @Nullable
    private volatile Layout layout;

    LayoutService(String version, ConfigService configService, List<PluginDescriptor> pluginDescriptors, OptionalService<HeapDumps> heapDumps, long fixedAggregateIntervalSeconds, long fixedAggregateRollupSeconds, long fixedGaugeIntervalSeconds, long fixedGaugeRollupSeconds) {
        this.version = version;
        this.configService = configService;
        this.pluginDescriptors = ImmutableList.copyOf(pluginDescriptors);
        this.heapDumps = heapDumps;
        this.fixedAggregateIntervalSeconds = fixedAggregateIntervalSeconds;
        this.fixedAggregateRollupSeconds = fixedAggregateRollupSeconds;
        this.fixedGaugeIntervalSeconds = fixedGaugeIntervalSeconds;
        this.fixedGaugeRollupSeconds = fixedGaugeRollupSeconds;
        PluginServices.ConfigListener listener = new PluginServices.ConfigListener(){

            @Override
            public void onChange() {
                LayoutService.this.layout = null;
            }
        };
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            configService.addPluginConfigListener(pluginDescriptor.id(), listener);
        }
        configService.addConfigListener(listener);
    }

    String getLayout() throws IOException {
        Layout localLayout = this.layout;
        if (localLayout == null) {
            this.layout = localLayout = LayoutService.buildLayout(this.version, this.configService, this.pluginDescriptors, this.heapDumps.getService(), this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
        }
        return mapper.writeValueAsString(localLayout);
    }

    String getLayoutVersion() {
        Layout localLayout = this.layout;
        if (localLayout == null) {
            this.layout = localLayout = LayoutService.buildLayout(this.version, this.configService, this.pluginDescriptors, this.heapDumps.getService(), this.fixedAggregateIntervalSeconds, this.fixedAggregateRollupSeconds, this.fixedGaugeIntervalSeconds, this.fixedGaugeRollupSeconds);
        }
        return localLayout.version();
    }

    String getNeedsAuthenticationLayout() throws IOException {
        UserInterfaceConfig userInterfaceConfig = this.configService.getUserInterfaceConfig();
        StringBuilder sb = new StringBuilder();
        JsonGenerator jg = jsonFactory.createGenerator(CharStreams.asWriter(sb));
        jg.writeStartObject();
        jg.writeBooleanField("needsAuthentication", true);
        jg.writeBooleanField("readOnlyPasswordEnabled", userInterfaceConfig.readOnlyPasswordEnabled());
        jg.writeStringField("footerMessage", "Glowroot version " + this.version);
        jg.writeEndObject();
        jg.close();
        return sb.toString();
    }

    private static Layout buildLayout(String version, ConfigService configService, List<PluginDescriptor> pluginDescriptors, @Nullable HeapDumps heapDumps, long fixedAggregateIntervalSeconds, long fixedAggregateRollupSeconds, long fixedGaugeIntervalSeconds, long fixedGaugeRollupSeconds) {
        ArrayList<String> transactionTypes = Lists.newArrayList(configService.getAllTransactionTypes());
        String defaultDisplayedTransactionType = configService.getDefaultDisplayedTransactionType();
        ArrayList<String> orderedTransactionTypes = Lists.newArrayList();
        if (transactionTypes.isEmpty()) {
            defaultDisplayedTransactionType = "NO TRANSACTION TYPES DEFINED";
        } else {
            if (!transactionTypes.contains(defaultDisplayedTransactionType)) {
                defaultDisplayedTransactionType = (String)transactionTypes.iterator().next();
            }
            transactionTypes.remove(defaultDisplayedTransactionType);
        }
        orderedTransactionTypes.add(defaultDisplayedTransactionType);
        orderedTransactionTypes.addAll(Ordering.from(String.CASE_INSENSITIVE_ORDER).sortedCopy(transactionTypes));
        TreeSet<String> transactionCustomAttributes = Sets.newTreeSet();
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            transactionCustomAttributes.addAll(pluginDescriptor.transactionCustomAttributes());
        }
        UserInterfaceConfig userInterfaceConfig = configService.getUserInterfaceConfig();
        return Layout.builder().jvmHeapDump(heapDumps != null).footerMessage("Glowroot version " + version).adminPasswordEnabled(userInterfaceConfig.adminPasswordEnabled()).readOnlyPasswordEnabled(userInterfaceConfig.readOnlyPasswordEnabled()).anonymousAccess(userInterfaceConfig.anonymousAccess()).addAllTransactionTypes(orderedTransactionTypes).defaultTransactionType(defaultDisplayedTransactionType).defaultPercentiles(configService.getGeneralConfig().defaultDisplayedPercentiles()).addAllTransactionCustomAttributes(transactionCustomAttributes).fixedAggregateIntervalSeconds(fixedAggregateIntervalSeconds).fixedAggregateRollupSeconds(fixedAggregateRollupSeconds).fixedGaugeIntervalSeconds(fixedGaugeIntervalSeconds).fixedGaugeRollupSeconds(fixedGaugeRollupSeconds).build();
    }
}

