/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.GaugeJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class MBeanAttributeNamesResponse
extends GaugeJsonService.MBeanAttributeNamesResponseBase {
    private final boolean mbeanUnavailable;
    private final boolean mbeanUnmatched;
    private final boolean duplicateMBean;
    private final ImmutableList<String> mbeanAttributes;

    private MBeanAttributeNamesResponse(Builder builder) {
        this.mbeanAttributes = builder.mbeanAttributesBuilder.build();
        this.mbeanUnavailable = builder.mbeanUnavailableIsSet() ? builder.mbeanUnavailable : super.mbeanUnavailable();
        this.mbeanUnmatched = builder.mbeanUnmatchedIsSet() ? builder.mbeanUnmatched : super.mbeanUnmatched();
        this.duplicateMBean = builder.duplicateMBeanIsSet() ? builder.duplicateMBean : super.duplicateMBean();
    }

    private MBeanAttributeNamesResponse(MBeanAttributeNamesResponse original, boolean mbeanUnavailable, boolean mbeanUnmatched, boolean duplicateMBean, ImmutableList<String> mbeanAttributes) {
        this.mbeanUnavailable = mbeanUnavailable;
        this.mbeanUnmatched = mbeanUnmatched;
        this.duplicateMBean = duplicateMBean;
        this.mbeanAttributes = mbeanAttributes;
    }

    @Override
    @JsonProperty(value="mbeanUnavailable")
    public boolean mbeanUnavailable() {
        return this.mbeanUnavailable;
    }

    @Override
    @JsonProperty(value="mbeanUnmatched")
    public boolean mbeanUnmatched() {
        return this.mbeanUnmatched;
    }

    @Override
    @JsonProperty(value="duplicateMBean")
    public boolean duplicateMBean() {
        return this.duplicateMBean;
    }

    @Override
    @JsonProperty(value="mbeanAttributes")
    public ImmutableList<String> mbeanAttributes() {
        return this.mbeanAttributes;
    }

    public final MBeanAttributeNamesResponse withMbeanUnavailable(boolean value) {
        if (this.mbeanUnavailable == value) {
            return this;
        }
        boolean newValue = value;
        return new MBeanAttributeNamesResponse(this, newValue, this.mbeanUnmatched, this.duplicateMBean, this.mbeanAttributes);
    }

    public final MBeanAttributeNamesResponse withMbeanUnmatched(boolean value) {
        if (this.mbeanUnmatched == value) {
            return this;
        }
        boolean newValue = value;
        return new MBeanAttributeNamesResponse(this, this.mbeanUnavailable, newValue, this.duplicateMBean, this.mbeanAttributes);
    }

    public final MBeanAttributeNamesResponse withDuplicateMBean(boolean value) {
        if (this.duplicateMBean == value) {
            return this;
        }
        boolean newValue = value;
        return new MBeanAttributeNamesResponse(this, this.mbeanUnavailable, this.mbeanUnmatched, newValue, this.mbeanAttributes);
    }

    public final MBeanAttributeNamesResponse withMbeanAttributes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new MBeanAttributeNamesResponse(this, this.mbeanUnavailable, this.mbeanUnmatched, this.duplicateMBean, newValue);
    }

    public final MBeanAttributeNamesResponse withMbeanAttributes(Iterable<String> elements) {
        if (this.mbeanAttributes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new MBeanAttributeNamesResponse(this, this.mbeanUnavailable, this.mbeanUnmatched, this.duplicateMBean, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MBeanAttributeNamesResponse && this.equalTo((MBeanAttributeNamesResponse)another);
    }

    private boolean equalTo(MBeanAttributeNamesResponse another) {
        return this.mbeanUnavailable == another.mbeanUnavailable && this.mbeanUnmatched == another.mbeanUnmatched && this.duplicateMBean == another.duplicateMBean && this.mbeanAttributes.equals(another.mbeanAttributes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.mbeanUnavailable);
        h = h * 17 + Booleans.hashCode(this.mbeanUnmatched);
        h = h * 17 + Booleans.hashCode(this.duplicateMBean);
        h = h * 17 + this.mbeanAttributes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MBeanAttributeNamesResponse").add("mbeanUnavailable", this.mbeanUnavailable).add("mbeanUnmatched", this.mbeanUnmatched).add("duplicateMBean", this.duplicateMBean).add("mbeanAttributes", this.mbeanAttributes).toString();
    }

    @JsonCreator
    public static MBeanAttributeNamesResponse fromAllAttributes(@JsonProperty(value="mbeanUnavailable") @Nullable Boolean mbeanUnavailable, @JsonProperty(value="mbeanUnmatched") @Nullable Boolean mbeanUnmatched, @JsonProperty(value="duplicateMBean") @Nullable Boolean duplicateMBean, @JsonProperty(value="mbeanAttributes") @Nullable ImmutableList<String> mbeanAttributes) {
        Builder builder = MBeanAttributeNamesResponse.builder();
        if (mbeanUnavailable != null) {
            builder.mbeanUnavailable(mbeanUnavailable);
        }
        if (mbeanUnmatched != null) {
            builder.mbeanUnmatched(mbeanUnmatched);
        }
        if (duplicateMBean != null) {
            builder.duplicateMBean(duplicateMBean);
        }
        if (mbeanAttributes != null) {
            builder.addAllMbeanAttributes(mbeanAttributes);
        }
        return builder.build();
    }

    static MBeanAttributeNamesResponse copyOf(GaugeJsonService.MBeanAttributeNamesResponseBase instance) {
        if (instance instanceof MBeanAttributeNamesResponse) {
            return (MBeanAttributeNamesResponse)instance;
        }
        return MBeanAttributeNamesResponse.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long NONDEFAULT_BIT_MBEAN_UNAVAILABLE = 1L;
        private static final long NONDEFAULT_BIT_MBEAN_UNMATCHED = 2L;
        private static final long NONDEFAULT_BIT_DUPLICATE_M_BEAN = 4L;
        private long nondefaultBitset;
        private boolean mbeanUnavailable;
        private boolean mbeanUnmatched;
        private boolean duplicateMBean;
        private ImmutableList.Builder<String> mbeanAttributesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(GaugeJsonService.MBeanAttributeNamesResponseBase instance) {
            Preconditions.checkNotNull(instance);
            this.mbeanUnavailable(instance.mbeanUnavailable());
            this.mbeanUnmatched(instance.mbeanUnmatched());
            this.duplicateMBean(instance.duplicateMBean());
            this.addAllMbeanAttributes(instance.mbeanAttributes());
            return this;
        }

        public final Builder mbeanUnavailable(boolean mbeanUnavailable) {
            this.mbeanUnavailable = mbeanUnavailable;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder mbeanUnmatched(boolean mbeanUnmatched) {
            this.mbeanUnmatched = mbeanUnmatched;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder duplicateMBean(boolean duplicateMBean) {
            this.duplicateMBean = duplicateMBean;
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder addMbeanAttributes(String element) {
            this.mbeanAttributesBuilder.add((Object)element);
            return this;
        }

        public final Builder addMbeanAttributes(String ... elements) {
            this.mbeanAttributesBuilder.add(elements);
            return this;
        }

        public final Builder mbeanAttributes(Iterable<String> elements) {
            this.mbeanAttributesBuilder = ImmutableList.builder();
            return this.addAllMbeanAttributes(elements);
        }

        public final Builder addAllMbeanAttributes(Iterable<String> elements) {
            this.mbeanAttributesBuilder.addAll((Iterable)elements);
            return this;
        }

        public MBeanAttributeNamesResponse build() {
            return new MBeanAttributeNamesResponse(this);
        }

        private boolean mbeanUnavailableIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean mbeanUnmatchedIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean duplicateMBeanIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }
    }
}

