/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.GaugeJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class MBeanObjectNameRequest
extends GaugeJsonService.MBeanObjectNameRequestBase {
    private final String partialMBeanObjectName;
    private final int limit;

    private MBeanObjectNameRequest(Builder builder) {
        this.partialMBeanObjectName = builder.partialMBeanObjectName;
        this.limit = builder.limit;
    }

    private MBeanObjectNameRequest(MBeanObjectNameRequest original, String partialMBeanObjectName, int limit) {
        this.partialMBeanObjectName = partialMBeanObjectName;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="partialMBeanObjectName")
    public String partialMBeanObjectName() {
        return this.partialMBeanObjectName;
    }

    @Override
    @JsonProperty(value="limit")
    public int limit() {
        return this.limit;
    }

    public final MBeanObjectNameRequest withPartialMBeanObjectName(String value) {
        if (this.partialMBeanObjectName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new MBeanObjectNameRequest(this, newValue, this.limit);
    }

    public final MBeanObjectNameRequest withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        int newValue = value;
        return new MBeanObjectNameRequest(this, this.partialMBeanObjectName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MBeanObjectNameRequest && this.equalTo((MBeanObjectNameRequest)another);
    }

    private boolean equalTo(MBeanObjectNameRequest another) {
        return this.partialMBeanObjectName.equals(another.partialMBeanObjectName) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.partialMBeanObjectName.hashCode();
        h = h * 17 + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MBeanObjectNameRequest").add("partialMBeanObjectName", this.partialMBeanObjectName).add("limit", this.limit).toString();
    }

    @JsonCreator
    public static MBeanObjectNameRequest fromAllAttributes(@JsonProperty(value="partialMBeanObjectName") @Nullable String partialMBeanObjectName, @JsonProperty(value="limit") @Nullable Integer limit) {
        Builder builder = MBeanObjectNameRequest.builder();
        if (partialMBeanObjectName != null) {
            builder.partialMBeanObjectName(partialMBeanObjectName);
        }
        if (limit != null) {
            builder.limit(limit);
        }
        return builder.build();
    }

    static MBeanObjectNameRequest copyOf(GaugeJsonService.MBeanObjectNameRequestBase instance) {
        if (instance instanceof MBeanObjectNameRequest) {
            return (MBeanObjectNameRequest)instance;
        }
        return MBeanObjectNameRequest.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_PARTIAL_M_BEAN_OBJECT_NAME = 1L;
        private static final long INITIALIZED_BIT_LIMIT = 2L;
        private long initializedBitset;
        @Nullable
        private String partialMBeanObjectName;
        private int limit;

        private Builder() {
        }

        public final Builder from(GaugeJsonService.MBeanObjectNameRequestBase instance) {
            Preconditions.checkNotNull(instance);
            this.partialMBeanObjectName(instance.partialMBeanObjectName());
            this.limit(instance.limit());
            return this;
        }

        public final Builder partialMBeanObjectName(String partialMBeanObjectName) {
            this.partialMBeanObjectName = Preconditions.checkNotNull(partialMBeanObjectName);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initializedBitset |= 2L;
            return this;
        }

        public MBeanObjectNameRequest build() {
            this.checkRequiredAttributes();
            return new MBeanObjectNameRequest(this);
        }

        private boolean partialMBeanObjectNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean limitIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.partialMBeanObjectNameIsSet()) {
                attributes.add("partialMBeanObjectName");
            }
            if (!this.limitIsSet()) {
                attributes.add("limit");
            }
            return "Cannot build MBeanObjectNameRequest, some of required attributes are not set " + attributes;
        }
    }
}

