/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.JvmJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;

@ParametersAreNonnullByDefault
@Immutable
final class MBeanTreeRequest
extends JvmJsonService.MBeanTreeRequestBase {
    private final ImmutableList<String> expanded;

    private MBeanTreeRequest(Builder builder) {
        this.expanded = builder.expandedBuilder.build();
    }

    private MBeanTreeRequest(MBeanTreeRequest original, ImmutableList<String> expanded) {
        this.expanded = expanded;
    }

    @JsonProperty(value="expanded")
    public ImmutableList<String> expanded() {
        return this.expanded;
    }

    public final MBeanTreeRequest withExpanded(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new MBeanTreeRequest(this, newValue);
    }

    public final MBeanTreeRequest withExpanded(Iterable<String> elements) {
        if (this.expanded == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new MBeanTreeRequest(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MBeanTreeRequest && this.equalTo((MBeanTreeRequest)another);
    }

    private boolean equalTo(MBeanTreeRequest another) {
        return this.expanded.equals(another.expanded);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.expanded.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MBeanTreeRequest").add("expanded", this.expanded).toString();
    }

    @JsonCreator
    public static MBeanTreeRequest fromAllAttributes(@JsonProperty(value="expanded") @Nullable List<String> expanded) {
        Builder builder = MBeanTreeRequest.builder();
        if (expanded != null) {
            builder.addAllExpanded(expanded);
        }
        return builder.build();
    }

    static MBeanTreeRequest copyOf(JvmJsonService.MBeanTreeRequestBase instance) {
        if (instance instanceof MBeanTreeRequest) {
            return (MBeanTreeRequest)instance;
        }
        return MBeanTreeRequest.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private ImmutableList.Builder<String> expandedBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(JvmJsonService.MBeanTreeRequestBase instance) {
            Preconditions.checkNotNull(instance);
            this.addAllExpanded(instance.expanded());
            return this;
        }

        public final Builder addExpanded(String element) {
            this.expandedBuilder.add((Object)element);
            return this;
        }

        public final Builder addExpanded(String ... elements) {
            this.expandedBuilder.add(elements);
            return this;
        }

        public final Builder expanded(Iterable<String> elements) {
            this.expandedBuilder = ImmutableList.builder();
            return this.addAllExpanded(elements);
        }

        public final Builder addAllExpanded(Iterable<String> elements) {
            this.expandedBuilder.addAll((Iterable)elements);
            return this;
        }

        public MBeanTreeRequest build() {
            return new MBeanTreeRequest(this);
        }
    }
}

