/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.InstrumentationJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class MethodSignature
extends InstrumentationJsonService.MethodSignatureBase {
    private final String name;
    private final ImmutableList<String> parameterTypes;
    private final String returnType;
    private final ImmutableList<String> modifiers;

    private MethodSignature(Builder builder) {
        this.name = builder.name;
        this.parameterTypes = builder.parameterTypesBuilder.build();
        this.returnType = builder.returnType;
        this.modifiers = builder.modifiersBuilder.build();
    }

    private MethodSignature(MethodSignature original, String name, ImmutableList<String> parameterTypes, String returnType, ImmutableList<String> modifiers) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.modifiers = modifiers;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="parameterTypes")
    public ImmutableList<String> parameterTypes() {
        return this.parameterTypes;
    }

    @Override
    @JsonProperty(value="returnType")
    public String returnType() {
        return this.returnType;
    }

    @Override
    @JsonProperty(value="modifiers")
    public ImmutableList<String> modifiers() {
        return this.modifiers;
    }

    public final MethodSignature withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new MethodSignature(this, newValue, this.parameterTypes, this.returnType, this.modifiers);
    }

    public final MethodSignature withParameterTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new MethodSignature(this, this.name, newValue, this.returnType, this.modifiers);
    }

    public final MethodSignature withParameterTypes(Iterable<String> elements) {
        if (this.parameterTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new MethodSignature(this, this.name, newValue, this.returnType, this.modifiers);
    }

    public final MethodSignature withReturnType(String value) {
        if (this.returnType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new MethodSignature(this, this.name, this.parameterTypes, newValue, this.modifiers);
    }

    public final MethodSignature withModifiers(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new MethodSignature(this, this.name, this.parameterTypes, this.returnType, newValue);
    }

    public final MethodSignature withModifiers(Iterable<String> elements) {
        if (this.modifiers == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new MethodSignature(this, this.name, this.parameterTypes, this.returnType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MethodSignature && this.equalTo((MethodSignature)another);
    }

    private boolean equalTo(MethodSignature another) {
        return this.name.equals(another.name) && this.parameterTypes.equals(another.parameterTypes) && this.returnType.equals(another.returnType) && this.modifiers.equals(another.modifiers);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.parameterTypes.hashCode();
        h = h * 17 + this.returnType.hashCode();
        h = h * 17 + this.modifiers.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MethodSignature").add("name", this.name).add("parameterTypes", this.parameterTypes).add("returnType", this.returnType).add("modifiers", this.modifiers).toString();
    }

    @JsonCreator
    public static MethodSignature fromAllAttributes(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="parameterTypes") @Nullable ImmutableList<String> parameterTypes, @JsonProperty(value="returnType") @Nullable String returnType, @JsonProperty(value="modifiers") @Nullable ImmutableList<String> modifiers) {
        Builder builder = MethodSignature.builder();
        if (name != null) {
            builder.name(name);
        }
        if (parameterTypes != null) {
            builder.addAllParameterTypes(parameterTypes);
        }
        if (returnType != null) {
            builder.returnType(returnType);
        }
        if (modifiers != null) {
            builder.addAllModifiers(modifiers);
        }
        return builder.build();
    }

    static MethodSignature copyOf(InstrumentationJsonService.MethodSignatureBase instance) {
        if (instance instanceof MethodSignature) {
            return (MethodSignature)instance;
        }
        return MethodSignature.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private static final long INITIALIZED_BIT_RETURN_TYPE = 2L;
        private long initializedBitset;
        @Nullable
        private String name;
        private ImmutableList.Builder<String> parameterTypesBuilder = ImmutableList.builder();
        @Nullable
        private String returnType;
        private ImmutableList.Builder<String> modifiersBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(InstrumentationJsonService.MethodSignatureBase instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            this.addAllParameterTypes(instance.parameterTypes());
            this.returnType(instance.returnType());
            this.addAllModifiers(instance.modifiers());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addParameterTypes(String element) {
            this.parameterTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addParameterTypes(String ... elements) {
            this.parameterTypesBuilder.add(elements);
            return this;
        }

        public final Builder parameterTypes(Iterable<String> elements) {
            this.parameterTypesBuilder = ImmutableList.builder();
            return this.addAllParameterTypes(elements);
        }

        public final Builder addAllParameterTypes(Iterable<String> elements) {
            this.parameterTypesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder returnType(String returnType) {
            this.returnType = Preconditions.checkNotNull(returnType);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addModifiers(String element) {
            this.modifiersBuilder.add((Object)element);
            return this;
        }

        public final Builder addModifiers(String ... elements) {
            this.modifiersBuilder.add(elements);
            return this;
        }

        public final Builder modifiers(Iterable<String> elements) {
            this.modifiersBuilder = ImmutableList.builder();
            return this.addAllModifiers(elements);
        }

        public final Builder addAllModifiers(Iterable<String> elements) {
            this.modifiersBuilder.addAll((Iterable)elements);
            return this;
        }

        public MethodSignature build() {
            this.checkRequiredAttributes();
            return new MethodSignature(this);
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean returnTypeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.returnTypeIsSet()) {
                attributes.add("returnType");
            }
            return "Cannot build MethodSignature, some of required attributes are not set " + attributes;
        }
    }
}

