/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class SmtpConfigDto
extends ConfigJsonService.SmtpConfigDtoBase {
    private final String fromEmailAddress;
    private final String fromDisplayName;
    private final String host;
    @Nullable
    private final Integer port;
    private final boolean ssl;
    private final String username;
    private final boolean passwordExists;
    private final ImmutableMap<String, String> additionalProperties;
    private final String newPassword;
    @Nullable
    private final String testEmailRecipient;
    private final String version;

    private SmtpConfigDto(Builder builder) {
        this.fromEmailAddress = builder.fromEmailAddress;
        this.fromDisplayName = builder.fromDisplayName;
        this.host = builder.host;
        this.port = builder.port;
        this.ssl = builder.ssl;
        this.username = builder.username;
        this.passwordExists = builder.passwordExists;
        this.additionalProperties = builder.additionalPropertiesBuilder.build();
        this.testEmailRecipient = builder.testEmailRecipient;
        this.version = builder.version;
        this.newPassword = builder.newPassword != null ? builder.newPassword : Preconditions.checkNotNull(super.newPassword());
    }

    private SmtpConfigDto(SmtpConfigDto original, String fromEmailAddress, String fromDisplayName, String host, @Nullable Integer port, boolean ssl, String username, boolean passwordExists, ImmutableMap<String, String> additionalProperties, String newPassword, @Nullable String testEmailRecipient, String version) {
        this.fromEmailAddress = fromEmailAddress;
        this.fromDisplayName = fromDisplayName;
        this.host = host;
        this.port = port;
        this.ssl = ssl;
        this.username = username;
        this.passwordExists = passwordExists;
        this.additionalProperties = additionalProperties;
        this.newPassword = newPassword;
        this.testEmailRecipient = testEmailRecipient;
        this.version = version;
    }

    @Override
    @JsonProperty(value="fromEmailAddress")
    public String fromEmailAddress() {
        return this.fromEmailAddress;
    }

    @Override
    @JsonProperty(value="fromDisplayName")
    public String fromDisplayName() {
        return this.fromDisplayName;
    }

    @Override
    @JsonProperty(value="host")
    public String host() {
        return this.host;
    }

    @Override
    @Nullable
    @JsonProperty(value="port")
    public Integer port() {
        return this.port;
    }

    @Override
    @JsonProperty(value="ssl")
    public boolean ssl() {
        return this.ssl;
    }

    @Override
    @JsonProperty(value="username")
    public String username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="passwordExists")
    public boolean passwordExists() {
        return this.passwordExists;
    }

    @JsonProperty(value="additionalProperties")
    public ImmutableMap<String, String> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    @JsonProperty(value="newPassword")
    public String newPassword() {
        return this.newPassword;
    }

    @Override
    @Nullable
    @JsonProperty(value="testEmailRecipient")
    public String testEmailRecipient() {
        return this.testEmailRecipient;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final SmtpConfigDto withFromEmailAddress(String value) {
        if (this.fromEmailAddress == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new SmtpConfigDto(this, newValue, this.fromDisplayName, this.host, this.port, this.ssl, this.username, this.passwordExists, this.additionalProperties, this.newPassword, this.testEmailRecipient, this.version);
    }

    public final SmtpConfigDto withFromDisplayName(String value) {
        if (this.fromDisplayName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new SmtpConfigDto(this, this.fromEmailAddress, newValue, this.host, this.port, this.ssl, this.username, this.passwordExists, this.additionalProperties, this.newPassword, this.testEmailRecipient, this.version);
    }

    public final SmtpConfigDto withHost(String value) {
        if (this.host == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new SmtpConfigDto(this, this.fromEmailAddress, this.fromDisplayName, newValue, this.port, this.ssl, this.username, this.passwordExists, this.additionalProperties, this.newPassword, this.testEmailRecipient, this.version);
    }

    public final SmtpConfigDto withPort(@Nullable Integer value) {
        if (this.port == value) {
            return this;
        }
        Integer newValue = value;
        return new SmtpConfigDto(this, this.fromEmailAddress, this.fromDisplayName, this.host, newValue, this.ssl, this.username, this.passwordExists, this.additionalProperties, this.newPassword, this.testEmailRecipient, this.version);
    }

    public final SmtpConfigDto withSsl(boolean value) {
        if (this.ssl == value) {
            return this;
        }
        boolean newValue = value;
        return new SmtpConfigDto(this, this.fromEmailAddress, this.fromDisplayName, this.host, this.port, newValue, this.username, this.passwordExists, this.additionalProperties, this.newPassword, this.testEmailRecipient, this.version);
    }

    public final SmtpConfigDto withUsername(String value) {
        if (this.username == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new SmtpConfigDto(this, this.fromEmailAddress, this.fromDisplayName, this.host, this.port, this.ssl, newValue, this.passwordExists, this.additionalProperties, this.newPassword, this.testEmailRecipient, this.version);
    }

    public final SmtpConfigDto withPasswordExists(boolean value) {
        if (this.passwordExists == value) {
            return this;
        }
        boolean newValue = value;
        return new SmtpConfigDto(this, this.fromEmailAddress, this.fromDisplayName, this.host, this.port, this.ssl, this.username, newValue, this.additionalProperties, this.newPassword, this.testEmailRecipient, this.version);
    }

    public final SmtpConfigDto withAdditionalProperties(Map<String, ? extends String> entries) {
        if (this.additionalProperties == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new SmtpConfigDto(this, this.fromEmailAddress, this.fromDisplayName, this.host, this.port, this.ssl, this.username, this.passwordExists, newValue, this.newPassword, this.testEmailRecipient, this.version);
    }

    public final SmtpConfigDto withNewPassword(String value) {
        if (this.newPassword == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new SmtpConfigDto(this, this.fromEmailAddress, this.fromDisplayName, this.host, this.port, this.ssl, this.username, this.passwordExists, this.additionalProperties, newValue, this.testEmailRecipient, this.version);
    }

    public final SmtpConfigDto withTestEmailRecipient(@Nullable String value) {
        if (this.testEmailRecipient == value) {
            return this;
        }
        String newValue = value;
        return new SmtpConfigDto(this, this.fromEmailAddress, this.fromDisplayName, this.host, this.port, this.ssl, this.username, this.passwordExists, this.additionalProperties, this.newPassword, newValue, this.version);
    }

    public final SmtpConfigDto withVersion(String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new SmtpConfigDto(this, this.fromEmailAddress, this.fromDisplayName, this.host, this.port, this.ssl, this.username, this.passwordExists, this.additionalProperties, this.newPassword, this.testEmailRecipient, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof SmtpConfigDto && this.equalTo((SmtpConfigDto)another);
    }

    private boolean equalTo(SmtpConfigDto another) {
        return this.fromEmailAddress.equals(another.fromEmailAddress) && this.fromDisplayName.equals(another.fromDisplayName) && this.host.equals(another.host) && Objects.equal(this.port, another.port) && this.ssl == another.ssl && this.username.equals(another.username) && this.passwordExists == another.passwordExists && this.additionalProperties.equals(another.additionalProperties) && this.newPassword.equals(another.newPassword) && Objects.equal(this.testEmailRecipient, another.testEmailRecipient) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.fromEmailAddress.hashCode();
        h = h * 17 + this.fromDisplayName.hashCode();
        h = h * 17 + this.host.hashCode();
        h = h * 17 + Objects.hashCode(this.port);
        h = h * 17 + Booleans.hashCode(this.ssl);
        h = h * 17 + this.username.hashCode();
        h = h * 17 + Booleans.hashCode(this.passwordExists);
        h = h * 17 + this.additionalProperties.hashCode();
        h = h * 17 + this.newPassword.hashCode();
        h = h * 17 + Objects.hashCode(this.testEmailRecipient);
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SmtpConfigDto").add("fromEmailAddress", this.fromEmailAddress).add("fromDisplayName", this.fromDisplayName).add("host", this.host).add("port", this.port).add("ssl", this.ssl).add("username", this.username).add("passwordExists", this.passwordExists).add("additionalProperties", this.additionalProperties).add("newPassword", this.newPassword).add("testEmailRecipient", this.testEmailRecipient).add("version", this.version).toString();
    }

    @JsonCreator
    public static SmtpConfigDto fromAllAttributes(@JsonProperty(value="fromEmailAddress") @Nullable String fromEmailAddress, @JsonProperty(value="fromDisplayName") @Nullable String fromDisplayName, @JsonProperty(value="host") @Nullable String host, @JsonProperty(value="port") @Nullable Integer port, @JsonProperty(value="ssl") @Nullable Boolean ssl, @JsonProperty(value="username") @Nullable String username, @JsonProperty(value="passwordExists") @Nullable Boolean passwordExists, @JsonProperty(value="additionalProperties") @Nullable Map<String, String> additionalProperties, @JsonProperty(value="newPassword") @Nullable String newPassword, @JsonProperty(value="testEmailRecipient") @Nullable String testEmailRecipient, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = SmtpConfigDto.builder();
        if (fromEmailAddress != null) {
            builder.fromEmailAddress(fromEmailAddress);
        }
        if (fromDisplayName != null) {
            builder.fromDisplayName(fromDisplayName);
        }
        if (host != null) {
            builder.host(host);
        }
        if (port != null) {
            builder.port(port);
        }
        if (ssl != null) {
            builder.ssl(ssl);
        }
        if (username != null) {
            builder.username(username);
        }
        if (passwordExists != null) {
            builder.passwordExists(passwordExists);
        }
        if (additionalProperties != null) {
            builder.putAllAdditionalProperties(additionalProperties);
        }
        if (newPassword != null) {
            builder.newPassword(newPassword);
        }
        if (testEmailRecipient != null) {
            builder.testEmailRecipient(testEmailRecipient);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static SmtpConfigDto copyOf(ConfigJsonService.SmtpConfigDtoBase instance) {
        if (instance instanceof SmtpConfigDto) {
            return (SmtpConfigDto)instance;
        }
        return SmtpConfigDto.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 127L;
        private static final long INITIALIZED_BIT_FROM_EMAIL_ADDRESS = 1L;
        private static final long INITIALIZED_BIT_FROM_DISPLAY_NAME = 2L;
        private static final long INITIALIZED_BIT_HOST = 4L;
        private static final long INITIALIZED_BIT_SSL = 8L;
        private static final long INITIALIZED_BIT_USERNAME = 16L;
        private static final long INITIALIZED_BIT_PASSWORD_EXISTS = 32L;
        private static final long INITIALIZED_BIT_VERSION = 64L;
        private long initializedBitset;
        @Nullable
        private String fromEmailAddress;
        @Nullable
        private String fromDisplayName;
        @Nullable
        private String host;
        @Nullable
        private Integer port;
        private boolean ssl;
        @Nullable
        private String username;
        private boolean passwordExists;
        private ImmutableMap.Builder<String, String> additionalPropertiesBuilder = ImmutableMap.builder();
        @Nullable
        private String newPassword;
        @Nullable
        private String testEmailRecipient;
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder from(ConfigJsonService.SmtpConfigDtoBase instance) {
            Preconditions.checkNotNull(instance);
            this.fromEmailAddress(instance.fromEmailAddress());
            this.fromDisplayName(instance.fromDisplayName());
            this.host(instance.host());
            Integer portValue = instance.port();
            if (portValue != null) {
                this.port(portValue);
            }
            this.ssl(instance.ssl());
            this.username(instance.username());
            this.passwordExists(instance.passwordExists());
            this.putAllAdditionalProperties(instance.additionalProperties());
            this.newPassword(instance.newPassword());
            String testEmailRecipientValue = instance.testEmailRecipient();
            if (testEmailRecipientValue != null) {
                this.testEmailRecipient(testEmailRecipientValue);
            }
            this.version(instance.version());
            return this;
        }

        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = Preconditions.checkNotNull(fromEmailAddress);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder fromDisplayName(String fromDisplayName) {
            this.fromDisplayName = Preconditions.checkNotNull(fromDisplayName);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder host(String host) {
            this.host = Preconditions.checkNotNull(host);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public final Builder ssl(boolean ssl) {
            this.ssl = ssl;
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder username(String username) {
            this.username = Preconditions.checkNotNull(username);
            this.initializedBitset |= 0x10L;
            return this;
        }

        public final Builder passwordExists(boolean passwordExists) {
            this.passwordExists = passwordExists;
            this.initializedBitset |= 0x20L;
            return this;
        }

        public final Builder putAdditionalProperties(String key, String value) {
            this.additionalPropertiesBuilder.put(key, value);
            return this;
        }

        public final Builder putAdditionalProperties(Map.Entry<String, ? extends String> entry) {
            this.additionalPropertiesBuilder.put(entry);
            return this;
        }

        public final Builder additionalProperties(Map<String, ? extends String> entries) {
            this.additionalPropertiesBuilder = ImmutableMap.builder();
            return this.putAllAdditionalProperties(entries);
        }

        public final Builder putAllAdditionalProperties(Map<String, ? extends String> entries) {
            this.additionalPropertiesBuilder.putAll(entries);
            return this;
        }

        public final Builder newPassword(String newPassword) {
            this.newPassword = Preconditions.checkNotNull(newPassword);
            return this;
        }

        public final Builder testEmailRecipient(@Nullable String testEmailRecipient) {
            this.testEmailRecipient = testEmailRecipient;
            return this;
        }

        public final Builder version(String version) {
            this.version = Preconditions.checkNotNull(version);
            this.initializedBitset |= 0x40L;
            return this;
        }

        public SmtpConfigDto build() {
            this.checkRequiredAttributes();
            return new SmtpConfigDto(this);
        }

        private boolean fromEmailAddressIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean fromDisplayNameIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean hostIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean sslIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean usernameIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private boolean passwordExistsIsSet() {
            return (this.initializedBitset & 0x20L) != 0L;
        }

        private boolean versionIsSet() {
            return (this.initializedBitset & 0x40L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 127L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.fromEmailAddressIsSet()) {
                attributes.add("fromEmailAddress");
            }
            if (!this.fromDisplayNameIsSet()) {
                attributes.add("fromDisplayName");
            }
            if (!this.hostIsSet()) {
                attributes.add("host");
            }
            if (!this.sslIsSet()) {
                attributes.add("ssl");
            }
            if (!this.usernameIsSet()) {
                attributes.add("username");
            }
            if (!this.passwordExistsIsSet()) {
                attributes.add("passwordExists");
            }
            if (!this.versionIsSet()) {
                attributes.add("version");
            }
            return "Cannot build SmtpConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

