/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.local.ui.SmtpConfigDto;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class SmtpConfigResponse
extends ConfigJsonService.SmtpConfigResponseBase {
    private final SmtpConfigDto config;
    private final String localServerName;

    private SmtpConfigResponse(Builder builder) {
        this.config = builder.config;
        this.localServerName = builder.localServerName;
    }

    private SmtpConfigResponse(SmtpConfigResponse original, SmtpConfigDto config, String localServerName) {
        this.config = config;
        this.localServerName = localServerName;
    }

    @Override
    @JsonProperty(value="config")
    public SmtpConfigDto config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="localServerName")
    public String localServerName() {
        return this.localServerName;
    }

    public final SmtpConfigResponse withConfig(SmtpConfigDto value) {
        if (this.config == value) {
            return this;
        }
        SmtpConfigDto newValue = Preconditions.checkNotNull(value);
        return new SmtpConfigResponse(this, newValue, this.localServerName);
    }

    public final SmtpConfigResponse withLocalServerName(String value) {
        if (this.localServerName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new SmtpConfigResponse(this, this.config, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof SmtpConfigResponse && this.equalTo((SmtpConfigResponse)another);
    }

    private boolean equalTo(SmtpConfigResponse another) {
        return this.config.equals(another.config) && this.localServerName.equals(another.localServerName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.localServerName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SmtpConfigResponse").add("config", this.config).add("localServerName", this.localServerName).toString();
    }

    @JsonCreator
    public static SmtpConfigResponse fromAllAttributes(@JsonProperty(value="config") @Nullable SmtpConfigDto config, @JsonProperty(value="localServerName") @Nullable String localServerName) {
        Builder builder = SmtpConfigResponse.builder();
        if (config != null) {
            builder.config(config);
        }
        if (localServerName != null) {
            builder.localServerName(localServerName);
        }
        return builder.build();
    }

    static SmtpConfigResponse copyOf(ConfigJsonService.SmtpConfigResponseBase instance) {
        if (instance instanceof SmtpConfigResponse) {
            return (SmtpConfigResponse)instance;
        }
        return SmtpConfigResponse.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_CONFIG = 1L;
        private static final long INITIALIZED_BIT_LOCAL_SERVER_NAME = 2L;
        private long initializedBitset;
        @Nullable
        private SmtpConfigDto config;
        @Nullable
        private String localServerName;

        private Builder() {
        }

        public final Builder from(ConfigJsonService.SmtpConfigResponseBase instance) {
            Preconditions.checkNotNull(instance);
            this.config(instance.config());
            this.localServerName(instance.localServerName());
            return this;
        }

        public final Builder config(SmtpConfigDto config) {
            this.config = Preconditions.checkNotNull(config);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder localServerName(String localServerName) {
            this.localServerName = Preconditions.checkNotNull(localServerName);
            this.initializedBitset |= 2L;
            return this;
        }

        public SmtpConfigResponse build() {
            this.checkRequiredAttributes();
            return new SmtpConfigResponse(this);
        }

        private boolean configIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean localServerNameIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.configIsSet()) {
                attributes.add("config");
            }
            if (!this.localServerNameIsSet()) {
                attributes.add("localServerName");
            }
            return "Cannot build SmtpConfigResponse, some of required attributes are not set " + attributes;
        }
    }
}

